/*
 * drivers/usb/f_usb/usb_otg_reg.h
 *
 * Copyright (C) 2011-2012 FUJITSU SEMICONDUCTOR LIMITED
 *
 * ALL RIGHTS RESERVED, COPYRIGHT (C) SOCIONEXT INC. 2015
 * LICENSED MATERIAL - PROGRAM PROPERTY OF SOCIONEXT INC.
 *
 * Copyright 2018 Sony Imaging Products and Solutions Incorporated.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _USB_OTG_REG_H_
#define _USB_OTG_REG_H_

static inline unsigned int get_reg_param(UDIF_VA base_address, unsigned int offset, unsigned int bit)
{
	UDIF_U32 reg_param;

	reg_param = udif_ioread32((UDIF_VA)(base_address + offset));

	return ((unsigned int)reg_param & bit);
}

static inline void set_reg_param(UDIF_VA base_address, unsigned int offset, unsigned int bit)
{
	UDIF_U32 reg_param;

	reg_param = udif_ioread32((UDIF_VA)(base_address + offset));
	reg_param |= bit;
	udif_iowrite32(reg_param, (UDIF_VA)(base_address + offset));

	return;
}

static inline void clear_reg_param(UDIF_VA base_address, unsigned int offset, unsigned int bit)
{
	UDIF_U32 reg_param;

	reg_param = udif_ioread32(base_address + offset);
	reg_param &= ~bit;
	udif_iowrite32(reg_param, (UDIF_VA)(base_address + offset));

	return;
}

static inline void write_reg_param(UDIF_VA base_address, unsigned int offset, unsigned int bit)
{
	udif_iowrite32((UDIF_U32)bit, (UDIF_VA)(base_address + offset));

	return;
}

/* OTG *//* FIXME all assignments */
#ifdef CONFIG_ARCH_CXD900XX_FPGA
#define FUSB_VBUS_GPIO_PORT          (17)
#define FUSB_VBUS_GPIO_BIT           (0)
#define FUSB_ID_GPIO_PORT            (17)
#define FUSB_ID_GPIO_BIT             (1)
#else
#define FUSB_VBUS_GPIO_PORT          (17)  /* TBD */
#define FUSB_VBUS0_GPIO_BIT          (12)
#define FUSB_VBUS1_GPIO_BIT          (11)
#define FUSB_ID_GPIO_PORT            (17)  /* TBD */
#define FUSB_ID_GPIO_BIT             (24)
#endif

#define FUSB_VBUS0_INTR_NAME        "vbus0"
#define FUSB_VBUS1_INTR_NAME        "vbus1"
#define FUSB_ID_INTR_NAME         "usbid"

#endif /* _F_USB_REGISTER_H_ */

