/**
 *	@file	usb_extcmd_conf.h
 *	@brief	USB EXTCMD(USB Extension Command) - conf
 *	
 *		Copyright 2008 Sony Corporation
 * Copyright 2018 Sony Imaging Products and Solutions Incorporated.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
#ifndef __USBG_EXTCMD_CONF_H__
#define __USBG_EXTCMD_CONF_H__


#include <linux/usb/specific_gadget/usb_node_info.h>

/*
 *	@brief	Extension command function's information
 */
#define MY_VER		"02.00.000"
#define MY_NAME		"usb_extcmd"
#define MY_DESC		"USB Extension Command function driver"
#define MY_MINOR	USB_MINOR_EXT_CMD
#define MY_NODE		USB_NODE_EXT_CMD

#define EXTCMD_SEMAPHORE	///< use semaphore
//#define EXTCMD_SPINLOCK		///< use spinlock

#define NEW_SENSE_KEY		///< sense key type

#define EXTCMD_DBG_MEMORY	///< enable debug memory

#define EXTCMD_DEBUG_ERR	///< enable ERR printk
//#define EXTCMD_DEBUG_INF	///< enable INF printk
//#define EXTCMD_DEBUG_FNC	///< enable FNC printk
//#define EXTCMD_DEBUG_API	///< enable API printk

#endif // __USBG_EXTCMD_CONF_H__
