#ifndef _ASMARM_BUG_H
#define _ASMARM_BUG_H


#ifdef CONFIG_BUG
#ifdef CONFIG_DEBUG_BUGVERBOSE
extern void __bug(const char *file, int line) __attribute__((noreturn));
extern void __bug_noarg(void);

/* give file/line information */
#define BUG()		_BUG(__FILE__, __LINE__)

/* expand __FILE__ and __LINE__ macros before stringify them */
#define _BUG(file, line) __BUG(file, line)

#define __BUG(__file, __line) \
        do {                                                            \
		asm volatile("\tbl	__bug_noarg\n"			\
			     ".pushsection .rodata\n"			\
			     "1:\t.asciz " #__file "\n"			\
			     ".popsection\n"				\
			     "\t.word	1b\n"				\
			     "\t.word	" #__line "\n"			\
			     :::);					\
		unreachable();						\
	} while (0)

#else

/* this just causes an oops */
#define BUG()		do { *(int *)0 = 0; for (;;); } while (0)

#endif

#define HAVE_ARCH_BUG
#endif

#include <asm-generic/bug.h>

#endif
