/*
 * arch/arm/mach-cxd900x0/include/mach/hwbp.h
 *
 * Hardware breakpoint API definitions
 *
 * Copyright 2015,2016 Sony Corporation
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 */
#ifndef __ARCH_CXD900X0_MACH_HWBP_H
#define __ARCH_CXD900X0_MACH_HWBP_H

#ifdef CONFIG_CXD900X0_HWBP
extern int hwbp_setup(u32 id, u32 addr, u32 ctrl);
extern void hwbp_ctrl_local(u32 id, int enable);
extern int hwbp_enable(u32 id);
extern int hwbp_disable(u32 id);
extern void _hwbp_bp_setup(uint slot, u32 addr, u32 ctrl);
extern void _hwbp_bp_ctrl(uint slot, int enable);
extern void _hwbp_wp_setup(uint slot, u32 addr, u32 ctrl);
extern void _hwbp_wp_ctrl(uint slot, int enable);
extern void hwbp_update(void);
extern int hwbp_find_slot(unsigned long addr);
extern void cxd900x0_hwbp_resume(void);
#else /* CONFIG_CXD900X0_HWBP */
static inline int hwbp_setup(u32 id, u32 addr, u32 ctrl){ return 0; }
static inline void hwbp_ctrl_local(u32 id, int enable){}
static inline int hwbp_enable(u32 id){ return 0; }
static inline int hwbp_disable(u32 id){ return 0; }
static inline void _hwbp_bp_setup(uint slot, u32 addr, u32 ctrl){}
static inline void _hwbp_bp_ctrl(uint slot, int enable){}
static inline void _hwbp_wp_setup(uint slot, u32 addr, u32 ctrl){}
static inline void _hwbp_wp_ctrl(uint slot, int enable){}
static inline void hwbp_update(void){}
static inline int hwbp_find_slot(unsigned long addr){ return -1; }
static inline void cxd900x0_hwbp_resume(void){}
#endif /* CONFIG_CXD900X0_HWBP */

/* ID */
#define HWBP_PC(slot)	(HWBP_TYPE_PC  + (slot))
#define HWBP_MEM(slot)	(HWBP_TYPE_MEM + (slot))

/* ctrl flags */
#define HWBP_ENABLE	0x00000001
#define HWBP_PRIV	0x00000002
#define HWBP_USER	0x00000004
#define HWBP_ACCANY	(HWBP_PRIV|HWBP_USER)
#define HWBP_LOAD	0x00000008
#define HWBP_STORE	0x00000010
#define HWBP_MISMATCH	0x00400000
/*   byte lane bitmap */
#define HWBP_BM_SHIFT	5
#define HWBP_BM(x)	((x) << HWBP_BM_SHIFT)
#define HWBP_BYTE4	HWBP_BM(0xf)
#define HWBP_HIHALF	HWBP_BM(0xc)
#define HWBP_LOHALF	HWBP_BM(0x3)
/*   address mask bits */
#define HWBP_AM_SHIFT	24
#define HWBP_AM(x)	((x) << HWBP_AM_SHIFT)

/* helper */
#define HWBP_TYPE_PC  0x00
#define HWBP_TYPE_MEM 0x10
#define HWBP_TYPEMASK 0x10
#define HWBP_SLOTMASK 0x0f
#define HWBP_TYPE(x)  ((x) & HWBP_TYPEMASK)
#define HWBP_SLOT(x)  ((x) & HWBP_SLOTMASK)
#define HWBP_ADDR(x)  ((x) & ~0x3)

extern void hwbp_set_handler(int (*fn)(int id, unsigned long addr,
				       unsigned int fsr, struct pt_regs *regs));
extern void hwbp_boot_time_notify(char *);

#endif /* __ARCH_CXD900X0_MACH_HWBP_H */
