/*
 * arch/arm/mach-cxd900x0/include/mach/regs-adc.h
 *
 * ADConverter registers
 *
 * Copyright 2014 Sony Corporation
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 */

#ifndef __ARCH_CXD900X0_REGS_ADC_H
#define __ARCH_CXD900X0_REGS_ADC_H

#include <mach/platform.h>

/****************************************************************************
 * Register Name
 ****************************************************************************/
#define AIN_SEL           (0x0)
#define ADC_TRG           (0x4)
#define ADC_MODE          (0x8)
#define ADC_INT           (0xc)
#define ADC_STATUS        (0x10)
#define ADC_DATA(ch)      (0x14 + 0x4 * (ch))
#define ADC_CLKCTRL       (0x44)
#define ADC_WAIT          (0x48)

/******************************************************************************
 * Register Setting Define
 ******************************************************************************/
/*-------- AIN_SEL Register --------*/
#define VAL_AIN_SEL(ch)                 (0x1 << (ch))
/*-------- ADC_TRG Register --------*/
#define VAL_ADC_STOP                    0x0
#define VAL_ADC_START                   0x1
#define VAL_ADC_START_USEC              0x1 // wait for over 1 cycle to change ADC_STATUS
/*-------- ADC_MODE Register -------*/
#define VAL_ADC_MODE_OFF                0x0
#define VAL_ADC_MODE_BOOT               0x1
#define VAL_ADC_MODE_AUTOOFF            (0x1 << 1)
/*-------- ADC_INT Register --------*/
#define VAL_ADC_INT_DISABLE             0x0
#define VAL_ADC_IEN                     (0x1 << 8)
#define VAL_ADC_ICLR                    (0x1 << 4)
/*-------- ADC_STATUS Register -------*/
#define MASK_STATUS_PDWNB               (0x1 << 8)
#define MASK_STATUS_SEQ                 (0x1 << 4)
#define MASK_STATUS_CNV                 (0x1 << 0)
/*-------- ADC_DATA Register -------*/
#define MASK_ADC_DATA                   0x3ff
/*-------- ADC_CLKCTRL Register ----*/
#define VAL_ADC_STCCYC                  (0xfe << 8) // 255 cycle
#define VAL_ADCLK_2                     0x00
#define VAL_ADCLK_4                     0x01
#define VAL_ADCLK_8                     0x02
#define VAL_ADCLK_6                     0x03
/*-------- ADC_WAIT Register -------*/
#define VAL_ADC_WAIT                    0x2f

#endif
