/*
 * arch/arm/mach-cxd90014/reg_WPCIE.h
 *
 * Copyright (C) 2011-2012 FUJITSU SEMICONDUCTOR LIMITED
 *
 * ALL RIGHTS RESERVED, COPYRIGHT (C) SOCIONEXT INC. 2015
 * LICENSED MATERIAL - PROGRAM PROPERTY OF SOCIONEXT INC.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef     __REG_WPCIE_H__
#define     __REG_WPCIE_H__

#ifdef __cplusplus
extern "C" {
#endif

typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       RST_PONX        : 1;
        uint32_t       RST_PEX         : 1;
        uint32_t                       : 27;
        uint32_t       PRV_SUPPORT_LINK_SPD: 1;
        uint32_t       ST_RE_TYPE      : 1;
        uint32_t       PRV_RE_TYPE     : 1;
    }   bit;
}   WPCIE_UN_CONTROL;

typedef     uint32_t       WPCIE_TD_SELECT;

typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       FUNC0           : 1;
        uint32_t       FUNC1           : 1;
        uint32_t       FUNC2           : 1;
        uint32_t       FUNC3           : 1;
        uint32_t       FUNC4           : 1;
        uint32_t       FUNC5           : 1;
        uint32_t       FUNC6           : 1;
        uint32_t       FUNC7           : 1;
        uint32_t                       : 24;
    }   bit;
}   WPCIE_UN_FUNCTION;

typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       ST_LTSSM        : 4;
        uint32_t                       : 4;
        uint32_t       ST_LTSSM_SUB    : 3;
        uint32_t                       : 5;
        uint32_t                       : 16;
    }   bit;
}   WPCIE_UN_ST_LTSMM;

typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       PM_F0_PMST      : 2;
        uint32_t       PM_F1_PMST      : 2;
        uint32_t       PM_F2_PMST      : 2;
        uint32_t       PM_F3_PMST      : 2;
        uint32_t       PM_F4_PMST      : 2;
        uint32_t       PM_F5_PMST      : 2;
        uint32_t       PM_F6_PMST      : 2;
        uint32_t       PM_F7_PMST      : 2;
        uint32_t                       : 16;
    }   bit;
}   WPCIE_UN_ST_PWR_MNG;

typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       ST_DMA_INT_0    : 1;
        uint32_t       ST_DMA_INT_1    : 1;
        uint32_t       ST_DMA_INT_2    : 1;
        uint32_t       ST_DMA_INT_3    : 1;
        uint32_t       ST_DMA_INT_4    : 1;
        uint32_t       ST_DMA_INT_5    : 1;
        uint32_t       ST_DMA_INT_6    : 1;
        uint32_t       ST_DMA_INT_7    : 1;
        uint32_t       ST_DMA_INT_8    : 1;
        uint32_t       ST_DMA_INT_9    : 1;
        uint32_t       ST_DMA_INT_10   : 1;
        uint32_t       ST_DMA_INT_11   : 1;
        uint32_t       ST_DMA_INT_12   : 1;
        uint32_t       ST_DMA_INT_13   : 1;
        uint32_t       ST_DMA_INT_14   : 1;
        uint32_t       ST_DMA_INT_15   : 1;
        uint32_t                       : 16;
    }   bit;
}   WPCIE_UN_ST_DMA_INT;

typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       ST_AXI_ERR_0    : 1;
        uint32_t       ST_AXI_ERR_1    : 1;
        uint32_t       ST_AXI_ERR_2    : 1;
        uint32_t       ST_AXI_ERR_3    : 1;
        uint32_t       ST_AXI_ERR_4    : 1;
        uint32_t       ST_AXI_ERR_5    : 1;
        uint32_t       ST_AXI_ERR_6    : 1;
        uint32_t       ST_AXI_ERR_7    : 1;
        uint32_t                       : 8;
        uint32_t                       : 16;
    }   bit;
}   WPCIE_UN_ST_AXI_ERR;

typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       RST_PEX_NEG         : 1;    /**< B00  */
        uint32_t       RST_PEX_POS         : 1;    /**< B01  */
        uint32_t       ST_GRGMX_NEG        : 1;    /**< B02  */
        uint32_t       ST_GRGMX_POS        : 1;    /**< B03  */
        uint32_t       ST_DL_UP_NEG        : 1;    /**< B04  */
        uint32_t       ST_DL_UP_POS        : 1;    /**< B05  */
        uint32_t                           : 2;    /**< B07:06   */
        uint32_t       PM_AUXEN_EDGE       : 1;    /**< B08  */
        uint32_t       PM_TOFF_REQ_EDGE    : 1;    /**< B09  */
        uint32_t       PM_PMERQ_DET_EDGE   : 1;    /**< B10  */
        uint32_t                           : 5;    /**< B15:11   */
        uint32_t                           : 8;    /**< B23:16   */
        uint32_t       MSG_INTA_NEG        : 1;    /**< B24  */
        uint32_t       MSG_INTA_POS        : 1;    /**< B25  */
        uint32_t       MSG_INTB_NEG        : 1;    /**< B26  */
        uint32_t       MSG_INTB_POS        : 1;    /**< B27  */
        uint32_t       MSG_INTC_NEG        : 1;    /**< B28  */
        uint32_t       MSG_INTC_POS        : 1;    /**< B29  */
        uint32_t       MSG_INTD_NEG        : 1;    /**< B30  */
        uint32_t       MSG_INTD_POS        : 1;    /**< B31  */
    }   bit;
}   WPCIE_UN_EXTINT;

typedef     uint32_t       WPCIE_TD_EXTINT_DM;

typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       FUNCTION        : 8;                /**< FUNCTION */
        uint32_t       DMACH           : 8;                /**< DMACH */
        uint32_t       VC              : 8;                /**< VC */
        uint32_t                       : 8;                /**< reserved */
    }   bit;
}   WPCIE_UN_CONFIG;

typedef     uint32_t       WPCIE_TD_PHY_CONTROL;

/* ==================================================================== */
#define __I     volatile const                                  /**< read only */
#define __O     volatile                                        /**< write only */
#define __IO    volatile                                        /**< read / write */

/* ==================================================================== */

#pragma pack(push,4)
/**
 * @brief WPCIE (@0x0-0xFFF)
*/
typedef     struct      {
    __IO     WPCIE_UN_CONTROL        CONTROL;                   /**< +00H */
    __IO     WPCIE_TD_SELECT         SELECT;                    /**< +04H */
    uint32_t                         __res1[2];                 /**< +008,00Freserved */
    __IO     WPCIE_UN_ST_LTSMM       ST_LTSMM;                  /**< +10H */
    __IO     WPCIE_UN_ST_PWR_MNG     ST_PWR_MNG;                /**< +14H */
    uint32_t                         __res2[2];                 /**< +018,01Freserved */
    __IO     WPCIE_UN_ST_DMA_INT     ST_DMA_INT_STS;            /**< +20H */
    uint32_t                         __res3[1];                 /**< +024,027reserved */
    __IO     WPCIE_UN_ST_DMA_INT     ST_DMA_INT_ENB;            /**< +28H */
    __IO     WPCIE_UN_ST_DMA_INT     ST_DMA_INT_RAW;            /**< +2CH */
    __IO     WPCIE_UN_ST_AXI_ERR     ST_TRM_INT_O;              /**< +30H */
    __IO     WPCIE_UN_ST_AXI_ERR     ST_TRS_INT_O;              /**< +34H */
    __IO     WPCIE_UN_ST_AXI_ERR     ST_ICS_INT_O;              /**< +38H */
    uint32_t                         __res4[1];                 /**< +03C,03Freserved */
    __IO     WPCIE_UN_EXTINT         EXTINT_STS;                /**< +40H */
    __IO     WPCIE_UN_EXTINT         EXTINT_CLR;                /**< +44H */
    __IO     WPCIE_UN_EXTINT         EXTINT_ENB;                /**< +48H */
    __IO     WPCIE_UN_EXTINT         EXTINT_RAW;                /**< +4CH */
    __IO     WPCIE_UN_EXTINT         EXTINT_SEL;                /**< +50H */
    __IO     WPCIE_UN_EXTINT         EXTINT_POL;                /**< +54H */
    __IO     WPCIE_UN_EXTINT         EXTINT_MOD;                /**< +58H */
    __IO     WPCIE_UN_EXTINT         EXTINT_MON;                /**< +5CH */
    __IO     WPCIE_TD_EXTINT_DM      EXTINT_DM_STS;             /**< +60H */
    __IO     WPCIE_TD_EXTINT_DM      EXTINT_DM_CLR;             /**< +64H */
    __IO     WPCIE_TD_EXTINT_DM      EXTINT_DM_ENB;             /**< +68H */
    __IO     WPCIE_TD_EXTINT_DM      EXTINT_DM_RAW;             /**< +6CH */
    __IO     WPCIE_TD_EXTINT_DM      EXTINT_DM_SEL;             /**< +70H */
    __IO     WPCIE_TD_EXTINT_DM      EXTINT_DM_POL;             /**< +74H */
    __IO     WPCIE_TD_EXTINT_DM      EXTINT_DM_MOD;             /**< +78H */
    __IO     WPCIE_TD_EXTINT_DM      EXTINT_DM_MON;             /**< +7CH */
    __IO     WPCIE_UN_FUNCTION       MSG_FN_REQ;                /**< +80H */
    __IO     WPCIE_UN_FUNCTION       MSG_FN_CLR;                /**< +84H */
    __IO     WPCIE_UN_FUNCTION       MSG_FN_STS;                /**< +88H */
    __IO     WPCIE_UN_FUNCTION       MSG_FN_SEL;                /**< +8CH */
    uint32_t                         __res5[((0xFC-0x90)/4)];   /**< +090,0FBreserved */
    __IO     WPCIE_UN_CONFIG         CONFIG;                    /**< +FCH */
    __IO     WPCIE_TD_PHY_CONTROL    PHY_CONTROL;               /**< +100H */
    uint32_t                         __res6[((0x1000-0x104)/4)]; /**< +104,FFFreserved */
}reg_wpcie_t;
#pragma pack(pop)


#ifdef __cplusplus
}
#endif
#endif      /* __REG_WPCIE_H__ */
/*---------------------------------------------------------------------------
  END
---------------------------------------------------------------------------*/
