/*
 * arch/arm/mach-cxd900x0/core.c
 *
 * machine_desc and initialize function
 *
 * Copyright 2015 Sony Corporation
 *
 * This code is based on arch/arm/mach-realview/realview_eb.c.
 */
/*
 *  linux/arch/arm/mach-realview/realview_eb.c
 *
 *  Copyright (C) 2004 ARM Limited
 *  Copyright (C) 2000 Deep Blue Solutions Ltd
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <linux/device.h>
#include <linux/init.h>
#include <linux/sched.h>
#include <linux/interrupt.h>
#include <linux/irq.h>
#include <linux/sysdev.h>
#include <linux/mman.h>

#ifdef CONFIG_PM
#include <mach/pm.h>
#include <linux/syscore_ops.h>
#endif /* CONFIG_PM */

#include <asm/pgtable.h>
#include <asm/page.h>
#include <asm/mach/map.h>
#include <mach/hardware.h>
#include "../mm/mm.h"

#include <asm/io.h>
#include <asm/irq.h>

#include <mach/gic_export.h>
#include <mach/regs-misc.h>
#include <mach/cxd900x0_cpuid.h>
#ifdef CONFIG_CACHE_PL310
#include <mach/pl310.h>
#endif
#include <mach/cxd900x0_board.h>

#ifdef CONFIG_CXD900X0_PCIE2_DME
#include <mach/pcie_export.h>
#endif

/* L2 cache enable/disable */
static int l2off = 0;
static int __init setup_l2off(char *str)
{
	l2off = 1;
	return 0;
}
early_param("l2off", setup_l2off);

/*---------------------------- I/O mapping --------------------------*/

static struct map_desc cxd900x0_io_desc[] __initdata = {
	{
		.virtual	= IO_ADDRESS(CXD900X0_IO_BASE),
		.pfn		= __phys_to_pfn(CXD900X0_IO_BASE),
		.length		= CXD900X0_IO_SIZE,
		.type		= MT_DEVICE },
	{
		.virtual	= IO_ADDRESS(CXD900X0_NANDC_BASE),
		.pfn		= __phys_to_pfn(CXD900X0_NANDC_BASE),
		.length		= CXD900X0_NANDC_SIZE,
		.type		= MT_DEVICE },
	{
		.virtual	= IO_ADDRESS(CXD900X0_AXIRAM_BASE),
		.pfn		= __phys_to_pfn(CXD900X0_AXIRAM_BASE),
		.length		= CXD900X0_AXIRAM_SIZE,
		.type		= MT_DEVICE },
	{
		.virtual	= IO_ADDRESS(CXD900X0_HIO_BASE),
		.pfn		= __phys_to_pfn(CXD900X0_HIO_BASE),
		.length		= CXD900X0_HIO_SIZE,
		.type		= MT_DEVICE },
	{
		.virtual	= IO_ADDRESS(CXD900X0_APB6_BASE),
		.pfn		= __phys_to_pfn(CXD900X0_APB6_BASE),
		.length		= CXD900X0_APB6_SIZE,
		.type		= MT_DEVICE },
	{
		.virtual	= IO_ADDRESS(CXD900X0_SRAMC_CS_BASE),
		.pfn		= __phys_to_pfn(CXD900X0_SRAMC_CS_BASE),
		.length		= CXD900X0_SRAMC_CS_SIZE,
		.type		= MT_DEVICE },
	{
		.virtual	= IO_ADDRESS(CXD900X0_PCIE0_IO_VIRT_BASE),
		.pfn		= __phys_to_pfn(CXD900X0_PCIE0_IO_PHYS_BASE),
		.length		= CXD900X0_PCIE0_IO_SIZE,
		.type		= MT_DEVICE },
	{
		.virtual	= IO_ADDRESS(CXD900X0_PCIE1_IO_VIRT_BASE),
		.pfn		= __phys_to_pfn(CXD900X0_PCIE1_IO_PHYS_BASE),
		.length		= CXD900X0_PCIE1_IO_SIZE,
		.type		= MT_DEVICE },
};

static unsigned long esram_rgn1_start;
static unsigned long esram_rgn1_size;
static unsigned int  esram_rgn1_memtype;

static void __init cxd900x0_map_sram(void)
{
	struct map_desc map;
	unsigned long start, end;
	unsigned long start1, size1;

	start = CXD900X0_ESRAM_BASE;
	end   = start + CXD900X0_ESRAM_SIZE;

	start1 = esram_rgn1_start;
	size1  = esram_rgn1_size;
	if (!start1 || !size1) {
		start1 = end;
		size1  = 0;
	}

	/* head */
	if (start < start1) {
		/* eSRAM uncacheable */
		map.pfn     = __phys_to_pfn(start);
		map.length  = start1 - start;
		map.virtual = IO_ADDRESS(start);
		map.type    = memtype_uc;
		create_mapping(&map);
	}
	if (start1 >= end)
		return;
	/* esram region1 */
	map.pfn     = __phys_to_pfn(start1);
	map.length  = size1;
	map.virtual = IO_ADDRESS(start1);
	map.type    = esram_rgn1_memtype;
	create_mapping(&map);
	start = start1 + size1;
	if (start >= end)
		return;
	/* tail */
	map.pfn     = __phys_to_pfn(start);
	map.length  = end - start;
	map.virtual = IO_ADDRESS(start);
	map.type    = memtype_uc;
	create_mapping(&map);
}

static int __init setup_esram_region(char *p)
{
	unsigned long start, size;
	char *endp;

	esram_rgn1_memtype = MT_MEMORY;
	size = memparse(p, &endp);
	if ('@' == *endp) {
		start = memparse(endp + 1, &endp);
		if (':' == *endp) {
			endp++;
			if (!strncmp(endp, "uc", 2)) {
				esram_rgn1_memtype = memtype_uc;
			} else if (!strncmp(endp, "nc", 2)) {
				esram_rgn1_memtype = MT_MEMORY_NC_XN;
			} else {
				printk(KERN_ERR "ERROR: illegal eSRAM memtype: %s\n", endp);
				return 1;
			}
		}
		if (CXD900X0_ESRAM_BASE <= start
		    && start+size <= CXD900X0_ESRAM_BASE+CXD900X0_ESRAM_SIZE) {
			esram_rgn1_start = start;
			esram_rgn1_size  = size;
			return 0;
		}
	}
	printk(KERN_ERR "ERROR: illegal eSRAM region: %s\n", p);
	return 1;
}
early_param("esram", setup_esram_region);

void __init cxd900x0_map_io(void)
{
	int i;

	/* overwrite memtype */
	for (i = 0; i < ARRAY_SIZE(cxd900x0_io_desc); i++) {
		cxd900x0_io_desc[i].type = memtype_io;
	}
	iotable_init(cxd900x0_io_desc, ARRAY_SIZE(cxd900x0_io_desc));

#ifdef CONFIG_CACHE_PL310
	if (!l2off) {
		l2x0_init((void __iomem *)VA_PL310, AUX_VAL, AUX_MASK);
		l2x0_info();
	}
#endif /* CONFIG_CACHE_PL310 */

	cxd900x0_map_sram();
}

/*------------------------------ SYSCORE -----------------------------*/
#ifdef CONFIG_PM

static int cxd900x0_suspend(void)
{
#ifdef CONFIG_CXD900X0_PCIE2_DME
	f_pcie2_dme_suspend();
#endif /* CONFIG_CXD900X0_PCIE2_DME */
	gic_cxd900x0_suspend();
        return 0;
}

static void cxd900x0_resume(void)
{
	cxd900x0_board_init();

	gic_cxd900x0_resume();
#ifdef CONFIG_CXD900X0_PCIE2_DME
	f_pcie2_dme_resume();
#endif /* CONFIG_CXD900X0_PCIE2_DME */
}

static struct syscore_ops cxd900x0_syscore_ops = {

	.suspend        = cxd900x0_suspend,
	.resume         = cxd900x0_resume,
};

static void cxd900x0_reset(int force)
{
        if (force) {
                local_irq_disable();
                /* assert XRESET_REQ */
                writel(MISC_RSTREQ_EN|MISC_RSTREQ_ASSERT, VA_MISC_RSTREQ_SET);
		wmb();

                while (1) ;
        }
        writel(MISC_RSTREQ_ASSERT, VA_MISC_RSTREQ_SET);
	wmb();
}
void (*pm_machine_reset)(int) = cxd900x0_reset;
EXPORT_SYMBOL(pm_machine_reset);

static void cxd900x0_poweroff(void)
{
        printk(KERN_ERR "not implemented yet.\n");
        local_irq_disable();
        while (1) ;
}
#endif /* CONFIG_PM */

/*------------------------------ SYSCORE -----------------------------*/

int __init cxd900x0_core_init(void)
{
	int ret = 0;
#ifdef CONFIG_OVERCOMMIT_ALWAYS
	extern int sysctl_overcommit_memory;
#endif

#ifdef CONFIG_PM
	pm_power_off = cxd900x0_poweroff;
	cxd900x0_pm_setup();
#endif

#ifdef CONFIG_OVERCOMMIT_ALWAYS
	sysctl_overcommit_memory = OVERCOMMIT_ALWAYS;
#endif

#ifdef CONFIG_PM
	register_syscore_ops(&cxd900x0_syscore_ops);
#endif

	return ret;
}

void __init cxd900x0_init_irq(void)
{
	gic_init(0, 29, (void __iomem *)VA_GIC_DIST, (void __iomem *)VA_GIC_CPU);
	gic_cxd900x0_init();
	gic_dump();
}

static int xrstreq_mode = -1; /* do not touch RSTREQ register */

static void cxd900x0_xrstreq_init(void)
{
	if (xrstreq_mode < 0)
		return;

	if (!xrstreq_mode) {
		writel_relaxed(MISC_RSTREQ_EN, VA_MISC_RSTREQ_CLR);
	} else {
		writel_relaxed(MISC_RSTREQ_EN, VA_MISC_RSTREQ_SET);
	}
}

static int __init cxd900x0_xrstreq_setup(char *str)
{
	int val;

	get_option(&str, &val);
	if (!val) {
		xrstreq_mode = 0;
	} else {
		xrstreq_mode = 1;
	}
	cxd900x0_xrstreq_init();

	return 1;
}
__setup("xrstreq=", cxd900x0_xrstreq_setup);

/*
 * Called from mach-cxd900x0/pm.c just after resume.
 * It is earlier than sysdev resume.
 */
#if !defined(CONFIG_CXD900X0_QEMU)
 #include <mach/hwbp.h>
void cxd900x0_early_resume(void)
{
	extern void cxd900x0_wdt_resume(void);

#ifdef CONFIG_CACHE_PL310
	if (!l2off) {
		extern void pl310_enable(void);
		pl310_enable();
	}
#endif /* CONFIG_CACHE_PL310 */
	cxd900x0_xrstreq_init();
	cxd900x0_wdt_resume();
	cxd900x0_hwbp_resume();
}
#endif /* !CONFIG_CXD900X0_QEMU */
