/*
 * arch/arm/mach-cxd900x0/include/mach/memory.h
 *
 * memory address definitions
 *
 * Copyright 2015 Sony Corporation
 *
 * This code is based on include/asm-arm/arch-integrator/memory.h.
 */
/*
 *  linux/include/asm-arm/arch-integrator/mmu.h
 *
 *  Copyright (C) 1999 ARM Limited
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef __ARCH_CXD900X0_MEMORY_H
#define __ARCH_CXD900X0_MEMORY_H
#include <mach/hardware.h>

#define PAGE_OFFSET		UL(CONFIG_PAGE_OFFSET)
#define TASK_SIZE		(UL(CONFIG_PAGE_OFFSET) - UL(0x01000000))
#if CONFIG_TASK_MMAP_OFFSET == 0
#define TASK_UNMAPPED_BASE	UL(CONFIG_PAGE_OFFSET / 2)
#else
#define TASK_UNMAPPED_BASE	UL(CONFIG_TASK_MMAP_OFFSET)
#endif

#ifdef __ASSEMBLY__
#define PLAT_PHYS_OFFSET	(DDR0_BASE)
#else
#define PLAT_PHYS_OFFSET	UL(DDR0_BASE)
#endif

#if defined(CONFIG_SPARSEMEM)

#define SECTION_SIZE_BITS	CONFIG_SNSC_SPARSE_SECTION_SHIFT
#define MAX_PHYSADDR_BITS	32
#define MAX_PHYSMEM_BITS	32
#define MAX_HOTPLUG_MEM		(CONFIG_CXD900X0_SIZE_DDR0+CONFIG_CXD900X0_SIZE_DDR1)

#define DDR0_END	(DDR0_BASE + CONFIG_CXD900X0_SIZE_DDR0)
#define DDR1_END	(DDR1_BASE + CONFIG_CXD900X0_SIZE_DDR1)
#define VA_DDR0		PAGE_OFFSET
#define VA_DDR1		(VA_DDR0 + CONFIG_CXD900X0_SIZE_DDR0)
#define VA_DDR1_END	(VA_DDR1 + CONFIG_CXD900X0_SIZE_DDR1)
/* [default]
                physical               virtual
  DDR0:  0x00000000-0x3fffffff  0x60000000-0x9fffffff
  DDR1:  0x80000000-0x8fffffff  0xa0000000-0xafffffff
*/

#define __phys_to_virt(x)						\
	((ulong)(x) < DDR1_BASE ? (x)+VA_DDR0 : (x)-DDR1_BASE+VA_DDR1)

#define __virt_to_phys(x)						\
	((ulong)(x) < VA_DDR1 ? (x)-VA_DDR0 : (x)-VA_DDR1+DDR1_BASE)

#endif /* CONFIG_SPARSEMEM */

#endif /* __ARCH_CXD900X0_MEMORY_H */
