/*
 * arch/arm/mach-cxd900x0/include/mach/platform.h
 *
 * CXD900X0 address map
 *
 * Copyright 2015 Sony Corporation
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 */
#ifndef __ARCH_CXD900X0_PLATFORM_H
#define __ARCH_CXD900X0_PLATFORM_H

#define DDR0_BASE		0x00000000
#define DDR0_START		0x00100000
#define DDR0_SIZE		0x80000000
#define DDR1_BASE		0x80000000
#define DDR1_SIZE		0x7e000000

/*---------------- I/O ----------------*/
#define CXD900X0_IO_BASE	0xf0000000
#define CXD900X0_IO_SIZE	(SZ_16M * 5)
#define CXD900X0_AHB_BASE	0xf0000000
#define CXD900X0_AXI_BASE	0xf1000000
#define CXD900X0_APB0_BASE	0xf2000000
#define CXD900X0_APB1_BASE	0xf2800000
#define CXD900X0_APB2_BASE	0xf3000000
#define CXD900X0_APB3_BASE	0xf3400000
#define CXD900X0_APB4_BASE	0xf3800000
#define CXD900X0_APB5_BASE	0xf3c00000
#define CXD900X0_APB7_BASE	0xf4000000

/*----- AHB -----*/
#define CXD900X0_DDRC_A		0xf0104000
#define CXD900X0_DDRC_B		0xf0105000

/*----- APB0 -----*/
#define CXD900X0_UART(x)	(0xf2000000+0x1000*(x))

#define CXD900X0_WDT_TIMER	0xf2402000
#define VA_WDT_TIMER		IO_ADDRESSP(CXD900X0_WDT_TIMER)

#define CXD900X0_TIMER_BASE(x)	(0xf2403000+0x100*(x))
#define VA_TIMER(x)		IO_ADDRESSP(CXD900X0_TIMER_BASE(x))

#define CXD900X0_ADC_BASE(x)	(0xf2406000+0x1000*(x))
#define VA_ADC(x)		IO_ADDRESSP(CXD900X0_ADC_BASE(x))

#define CXD900X0_DAP_BASE	0xf2600000

/*----- APB1 -----*/
#define CXD900X0_AVB_BASE	0xf2800000
#define CXD900X0_AVBCKG_BASE	(CXD900X0_AVB_BASE + 0x0000)
#define VA_AVBCKG		IO_ADDRESSP(CXD900X0_AVBCKG_BASE)
#define CXD900X0_BAM_BASE	(CXD900X0_AVB_BASE + 0x1000)
#define CXD900X0_BAM_SIZE	(SZ_4K)
#define VA_BAM			IO_ADDRESSP(CXD900X0_BAM_BASE)
#define CXD900X0_MACRO_BASE	0xf2910000
#define CXD900X0_GPIO_BASE	(CXD900X0_MACRO_BASE + 0x0000)
#define CXD900X0_GPIO(ch,reg)	(CXD900X0_GPIO_BASE+GPIO_REG(ch,reg))
#define PA_GPIO(ch,reg)		CXD900X0_GPIO(ch,reg)
#define VA_GPIO(ch,reg)		IO_ADDRESSP(CXD900X0_GPIO(ch,reg))

#define CXD900X0_OCTRL_BASE	(CXD900X0_MACRO_BASE + 0x2000)
#define CXD900X0_OCTRL(x)	(CXD900X0_OCTRL_BASE + ((x) << 8))
#define VA_OCTRL(x)		IO_ADDRESSP(CXD900X0_OCTRL(x))
#define CXD900X0_SYNCSEL	(CXD900X0_MACRO_BASE + 0x4020)
#define VA_SYNCSEL		IO_ADDRESSP(CXD900X0_SYNCSEL)

#define CXD900X0_MISC_BASE	(CXD900X0_MACRO_BASE + 0x5000)
#define VA_MISC			IO_ADDRESSP(CXD900X0_MISC_BASE)
#define CXD900X0_CLKRST_BASE	(CXD900X0_MACRO_BASE+0x6600)

#define CXD900X0_CLKCRG(base,x)	((base) + 0x1000 * ((x) + 1))

#define CXD900X0_CLK0		0xf2a00000
#define CXD900X0_CLKRST0(x)	(CXD900X0_CLK0 + ((x) << 4))
#define CXD900X0_CLKCRG0(x)	CXD900X0_CLKCRG(CXD900X0_CLK0, x)
#define VA_CLKRST0(x)		IO_ADDRESSP(CXD900X0_CLKRST0(x))
#define VA_CLKCRG0(x)		IO_ADDRESSP(CXD900X0_CLKCRG0(x))

#define CXD900X0_CLK1		0xf2a10000
#define CXD900X0_CLKRST1(x)	(CXD900X0_CLK1 + ((x) << 4))
#define CXD900X0_CLKCRG1(x)	CXD900X0_CLKCRG(CXD900X0_CLK1, x)
#define VA_CLKRST1(x)		IO_ADDRESSP(CXD900X0_CLKRST1(x))
#define VA_CLKCRG1(x)		IO_ADDRESSP(CXD900X0_CLKCRG1(x))

#define CXD900X0_CLK2		0xf2a20000
#define CXD900X0_CLKRST2(x)	(CXD900X0_CLK2 + ((x) << 4))
#define CXD900X0_CLKCRG2(x)	CXD900X0_CLKCRG(CXD900X0_CLK2, x)
#define VA_CLKRST2(x)		IO_ADDRESSP(CXD900X0_CLKRST2(x))
#define VA_CLKCRG2(x)		IO_ADDRESSP(CXD900X0_CLKCRG2(x))

#define CXD900X0_CLK3		0xf2900000
#define CXD900X0_CLKRST3(x)	(CXD900X0_CLK3 + ((x) << 4))
#define CXD900X0_CLKCRG3(x)	CXD900X0_CLKCRG(CXD900X0_CLK3, x)
#define VA_CLKRST3(x)		IO_ADDRESSP(CXD900X0_CLKRST3(x))
#define VA_CLKCRG3(x)		IO_ADDRESSP(CXD900X0_CLKCRG3(x))

#define CXD900X0_CLK4		0xf2a30000
#define CXD900X0_CLKRST4(x)	(CXD900X0_CLK4 + ((x) << 4))
#define CXD900X0_CLKCRG4(x)	CXD900X0_CLKCRG(CXD900X0_CLK4, x)
#define VA_CLKRST4(x)		IO_ADDRESSP(CXD900X0_CLKRST4(x))
#define VA_CLKCRG4(x)		IO_ADDRESSP(CXD900X0_CLKCRG4(x))

/*----- APB6 -----*/
#define CXD900X0_APB6_BASE	0xf9000000
#define CXD900X0_APB6_SIZE	(SZ_1M)
#define CXD900X0_SRAMC_BASE	0xf9003000
#define CXD900X0_SRAMC_SIZE	SZ_4K
#define CXD900X0_SSRAMC_BASE	0xf9004000
#define CXD900X0_SSRAMC_SIZE	SZ_4K
/*----- SRAMC MEM (SYNC and CS2) -----*/
#define CXD900X0_SSRAMC_CS_BASE	0xf9010000
#define CXD900X0_SSRAMC_CS_SIZE	SZ_64K
#define CXD900X0_SRAMC_CS2_BASE	0xf9020000
#define CXD900X0_SRAMC_CS2_SIZE	SZ_64K

/*----- AXI ------*/
#define CXD900X0_NANDC_BASE	0xf5000000
#define CXD900X0_NANDC_SIZE	(SZ_1M)
#define CXD900X0_AXIRAM_BASE	0xf6000000
#define CXD900X0_AXIRAM_SIZE	(SZ_1M)

/*---------------- MPCore ----------------*/
#define CXD900X0_HIO_BASE	0xf8000000
#define CXD900X0_HIO_SIZE	(SZ_1M)
/* MPCore */
#define CXD900X0_MPCORE_BASE	(CXD900X0_HIO_BASE+0x00000)
#define CXD900X0_SCU_BASE	0xf8000000
#define CXD900X0_GIC_CPU_BASE	0xf8000100 /* CPU I/F */
#define CXD900X0_GTIMER_BASE	0xf8000200 /* Global Timer */
#define VA_GLOBALTIMER		IO_ADDRESSP(CXD900X0_GTIMER_BASE)
#define CXD900X0_LOCALTIMER_BASE	0xf8000600
#define CXD900X0_LOCALTIMER_BASE_SIZE (0x0100)
#define VA_LOCALTIMER		IO_ADDRESSP(CXD900X0_LOCALTIMER_BASE)
#define CXD900X0_GIC_DIST_BASE	0xf8001000 /* INT DIST */
#define SCU_BASE		CXD900X0_SCU_BASE
#define VA_SCU			IO_ADDRESSP(CXD900X0_SCU_BASE)
#define VA_GIC_CPU		IO_ADDRESSP(CXD900X0_GIC_CPU_BASE)
#define VA_GIC_DIST		IO_ADDRESSP(CXD900X0_GIC_DIST_BASE)
#define GIC_CPU_BASE		CXD900X0_GIC_CPU_BASE
/* L2 Cache */
#define CXD900X0_PL310_BASE	0xf8002000
#define VA_PL310		IO_ADDRESSP(CXD900X0_PL310_BASE)

/*---------------- SRAMC ----------------*/
#define CXD900X0_SRAMC_CS_BASE		0xfa000000
#define CXD900X0_SRAMC_CS_SIZE		(SZ_64M)
#define CXD900X0_SRAMC_CS0_BASE		0xfa000000
#define CXD900X0_SRAMC_CS1_BASE		0xfc000000

/*---------------- eSRAM ----------------*/
#define CXD900X0_ESRAM_BASE	0xfe000000
#define CXD900X0_ESRAM_SIZE	SZ_16M
#define CXD900X0_ESRAM_BANK(x)	(CXD900X0_ESRAM_BASE + (((x) < 2) ? (SZ_4M * (x)) : (SZ_8M + ((x) - 2) * SZ_512K)))
#define VA_BOOTRAM		IO_ADDRESS(CXD900X0_ESRAM_BASE)

/*---------------- PCIe space ----------------*/
#define CXD900X0_PCIE0_IO_PHYS_BASE	0xbf800000
#define CXD900X0_PCIE0_IO_VIRT_BASE	0xf8800000
#define CXD900X0_PCIE0_IO_SIZE		SZ_1M
#define CXD900X0_PCIE0_MEM_NONPREF	0xc0000000
#define CXD900X0_PCIE0_MEM_NONPREF_SIZE	(640*SZ_1M)

#define CXD900X0_PCIE1_IO_PHYS_BASE	0xbfc00000
#define CXD900X0_PCIE1_IO_VIRT_BASE	0xf8c00000
#define CXD900X0_PCIE1_IO_SIZE		SZ_1M
#define CXD900X0_PCIE1_MEM_NONPREF	0xe8000000
#define CXD900X0_PCIE1_MEM_NONPREF_SIZE	SZ_128M

/*---------------- USB3 space ----------------*/
#define CXD900X0_USB_BASE		0xf2920000
#define CXD900X0_USB_DRD_BASE	0xf0200000
#define CXD900X0_USB_DRD_SIZE	SZ_1M

#ifndef __ASSEMBLY__
extern int cxd900x0_core_init(void);
extern struct sys_timer cxd4115_timer;
extern void cxd900x0_map_io(void);
extern void cxd900x0_init_irq(void);
#endif /* !__ASSEMBLY__ */

#endif /* __ARCH_CXD900X0_PLATFORM_H */
