/*
 *  Profiling infrastructure declarations.
 *
 *    Copyright IBM Corp. 2009, 2013
 *    Author(s): Peter Oberparleiter <oberpar@linux.vnet.ibm.com>
 */

#ifndef GCOV_H
#define GCOV_H GCOV_H

#define GCC_VERSION_LOWER(major, minor)        ((__GNUC__ < major) || \
			  (__GNUC__ == major) && (__GNUC_MINOR__ < minor))

/* An opaque type for the actual, gcc-version specific data structure. */
struct gcov_info;

/* Base interface. */
enum gcov_action {
	GCOV_ADD,
	GCOV_REMOVE,
};

void gcov_event(enum gcov_action action, struct gcov_info *info);
void gcov_enable_events(void);

/* Iterator control. */
struct seq_file;
struct gcov_iterator;

struct gcov_iterator *gcov_iter_new(struct gcov_info *info);
void gcov_iter_free(struct gcov_iterator *iter);
void gcov_iter_start(struct gcov_iterator *iter);
int gcov_iter_next(struct gcov_iterator *iter);
int gcov_iter_write(struct gcov_iterator *iter, struct seq_file *seq);
struct gcov_info *gcov_iter_get_info(struct gcov_iterator *iter);

/* gcov_info control. */
void gcov_info_reset(struct gcov_info *info);
int gcov_info_is_compatible(struct gcov_info *info1, struct gcov_info *info2);
void gcov_info_add(struct gcov_info *dest, struct gcov_info *source);
struct gcov_info *gcov_info_dup(struct gcov_info *info);
void gcov_info_free(struct gcov_info *info);
const char *gcov_info_get_filename(struct gcov_info *info);

struct gcov_link {
	enum {
		OBJ_TREE,
		SRC_TREE,
	} dir;
	const char *ext;
};
extern const struct gcov_link gcov_link[];

#endif /* GCOV_H */
