/*
 * Copyright 2018 Sony Imaging Products & Solutions Inc.
 * Copyright 2018 Sony Corporation.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef _CXD900XX_RESET_REGS_H_
#define _CXD900XX_RESET_REGS_H_

#define CXD900XX_SCU_BITS                    32

// Software Reset Enable Register for communication IP
#define CXD900XX_RST_EMMC5P1_BOOT_APB        0     //eMMC5p1_boot_APB 0 WPSET 0x0 eMMC5p1_boot prstn reset (Level)
#define CXD900XX_RST_EMMC5P1_BOOT_AXI        1     //eMMC5p1_boot_AXI 1 WPSET 0x0 eMMC5p1_boot axi_reset_n reset (Level)
#define CXD900XX_RST_EMMC5P1_SDIO_APB        2     //eMMC5p1_SDIO_APB 2 WPSET 0x0 eMMC5p1_SDIO prstn reset (Level)
#define CXD900XX_RST_EMMC5P1_SDIO_AXI        3     //eMMC5p1_SDIO_AXI 3 WPSET 0x0 eMMC5p1_SDIO axi_reset_n reset (Level)
#define CXD900XX_RST_SDIF0_APB               4     //SDIF0_APB 4 WPSET 0x0 SDIF0 prstn reset (Level)
#define CXD900XX_RST_SDIF0_AXI               5     //SDIF0_AXI 5 WPSET 0x0 SDIF0 axi_reset_n reset (Level)
#define CXD900XX_RST_SDIF1_APB               6     //SDIF1_APB 6 WPSET 0x0 SDIF1 prstn reset (Level)
#define CXD900XX_RST_SDIF1_AXI               7     //SDIF1_AXI 7 WPSET 0x0 SDIF1 axi_reset_n reset (Level)
#define CXD900XX_RST_USB_AXI                 8     //USB_AXI 8 WPSET 0x0 USB AXI reset
#define CXD900XX_RST_USB_APB                 9     //USB_APB 9 WPSET 0x0 USB APB reset
#define CXD900XX_RST_USB_U2PHY               10    //USB_U2PHY 10 WPSET 0x0 USB PHY reset
#define CXD900XX_RST_USB_U31PHY              11    //USB_U31PHY 11 WPSET 0x0 USB PHY reset
#define CXD900XX_RST_MEMORY_STICK            12    //Memory_Stick 12 WPSET 0x0 Memory reset (Level)
#define CXD900XX_RST_REVERSE_0_13            13
#define CXD900XX_RST_REVERSE_0_14            14
#define CXD900XX_RST_REVERSE_0_15            15
#define CXD900XX_RST_REVERSE_0_16            16
#define CXD900XX_RST_REVERSE_0_17            17
#define CXD900XX_RST_REVERSE_0_18            18
#define CXD900XX_RST_REVERSE_0_19            19
#define CXD900XX_RST_CRYPT_AES_XTS_BOOT      20    //Crypt_AES_XTS_boot 20 WPSET 0x0 Crypt AES-XTS reset (Level)
#define CXD900XX_RST_CRYPT_NETWORK_SPACC     21    //Crypt_Network_SPAcc 21 WPSET 0x0 Crypt Network reset (Level)
#define CXD900XX_RST_REVERSE_0_22            22
#define CXD900XX_RST_DECOMPRESSOR            23    //Decompressor 23 WPSET 0x0 Decompressor reset (Level)
#define CXD900XX_RST_FEC                     24    //FEC 24 WPSET 0x0 Forward Error Correction reset (Level)
#define CXD900XX_RST_REVERSE_0_25            25
#define CXD900XX_RST_REVERSE_0_26            26
#define CXD900XX_RST_REVERSE_0_27            27
#define CXD900XX_RST_REVERSE_0_28            28
#define CXD900XX_RST_REVERSE_0_29            29
#define CXD900XX_RST_REVERSE_0_30            30
#define CXD900XX_RST_REVERSE_0_31            31


// Software Reset Enable Register for communication IP
#define CXD900XX_RST_PCIEX4_I_PWRUP          32    //PCIeX4_i_PWRUP 0 RWCSTAT 0x1 PCIeX4_i_PWRUP
#define CXD900XX_RST_PCIEX4_I_BUTTON         33    //PCIeX4_i_BUTTON 1 RWCSTAT 0x1 PCIeX4_i_PWRUP
#define CXD900XX_RST_PCIEX4_I_PE             34    //PCIeX4_i_PE 2 RWCSTAT 0x1 PCIeX4_i_BUTTON
#define CXD900XX_RST_PCIEX4_I_APB            35    //PCIeX4_i_APB 3 RWCSTAT 0x1 PCIeX4_i_APB
#define CXD900XX_RST_PCIEX2_M1_PWRUP         36    //PCIeX2_m1_PWRUP 4 RWCSTAT 0x1 PCIeX2_m1_PWRUP
#define CXD900XX_RST_PCIEX2_M1_BUTTON        37    //PCIeX2_m1_BUTTON 5 RWCSTAT 0x1 PCIeX2_m1_BUTTON
#define CXD900XX_RST_PCIEX2_M1_PE            38    //PCIeX2_m1_PE 6 RWCSTAT 0x1 PCIeX2_m1_PErst
#define CXD900XX_RST_PCIEX2_M1_APB           39    //PCIeX2_m1_APB 7 RWCSTAT 0x1 PCIeX2_m1_APB
#define CXD900XX_RST_PCIEX2_M0_PWRUP         40    //PCIeX2_m0_PWRUP 8 RWCSTAT 0x1 PCIeX2_m0_PWRUP
#define CXD900XX_RST_PCIEX2_M0_BUTTON        41    //PCIeX2_m0_BUTTON 9 RWCSTAT 0x1 PCIeX2_m0_BUTTON
#define CXD900XX_RST_PCIEX2_M0_PE            42    //PCIeX2_m0_PE 10 RWCSTAT 0x1 PCIeX2_m0_PErst
#define CXD900XX_RST_PCIEX2_M0_APB           43    //PCIeX2_m0_APB 11 RWCSTAT 0x1 PCIeX2_m0_APB
#define CXD900XX_RST_PCIEX1_C_PWRUP          44    //PCIeX1_c_PWRUP 12 RWCSTAT 0x1 PCIeX1_c_PWRUP
#define CXD900XX_RST_PCIEX1_C_BUTTON         45    //PCIeX1_c_BUTTON 13 RWCSTAT 0x1 PCIeX1_c_BUTTON
#define CXD900XX_RST_PCIEX1_C_PE             46    //PCIeX1_c_PE 14 RWCSTAT 0x1 PCIeX1_c_PErst
#define CXD900XX_RST_PCIEX1_C_APB            47    //PCIeX1_c_APB 15 RWCSTAT 0x1 PCIeX1_c_APB
#define CXD900XX_RST_PCIEX1_N_PWRUP          48    //PCIeX1_n_PWRUP 16 RWCSTAT 0x1 PCIeX1_n_PWRUP
#define CXD900XX_RST_PCIEX1_N_BUTTON         49    //PCIeX1_n_BUTTON 17 RWCSTAT 0x1 PCIeX1_n_BUTTON
#define CXD900XX_RST_PCIEX1_N_PE             50    //PCIeX1_n_PE 18 RWCSTAT 0x1 PCIeX1_n_PErst
#define CXD900XX_RST_PCIEX1_N_APB            51    //PCIeX1_n_APB 19 RWCSTAT 0x1 PCIeX1_n_APB
#define CXD900XX_RST_REVERSE_1_20            52
#define CXD900XX_RST_REVERSE_1_21            53
#define CXD900XX_RST_REVERSE_1_22            54
#define CXD900XX_RST_REVERSE_1_23            55
#define CXD900XX_RST_REVERSE_1_24            56
#define CXD900XX_RST_REVERSE_1_25            57
#define CXD900XX_RST_REVERSE_1_26            58
#define CXD900XX_RST_REVERSE_1_27            59
#define CXD900XX_RST_REVERSE_1_28            60
#define CXD900XX_RST_REVERSE_1_29            61
#define CXD900XX_RST_REVERSE_1_30            62
#define CXD900XX_RST_REVERSE_1_31            63


// Software Reset Enable Register for mem
#define CXD900XX_RST_DDR_PHY_REG_0           64    //DDR_PHY_REG 3:0 RWCSTAT 0x0 DDR PHYx_regHRESETn reset status
#define CXD900XX_RST_DDR_PHY_REG_1           65    //DDR_PHY_REG 3:0 RWCSTAT 0x0 DDR PHYx_regHRESETn reset status
#define CXD900XX_RST_DDR_PHY_REG_2           66    //DDR_PHY_REG 3:0 RWCSTAT 0x0 DDR PHYx_regHRESETn reset status
#define CXD900XX_RST_DDR_PHY_REG_3           67    //DDR_PHY_REG 3:0 RWCSTAT 0x0 DDR PHYx_regHRESETn reset status
#define CXD900XX_RST_DDR_AHB_0               68    //DDR_AHB 7:4 RWCSTAT 0x0 DDR regHRESETn reset status
#define CXD900XX_RST_DDR_AHB_1               69    //DDR_AHB 7:4 RWCSTAT 0x0 DDR regHRESETn reset status
#define CXD900XX_RST_DDR_AHB_2               70    //DDR_AHB 7:4 RWCSTAT 0x0 DDR regHRESETn reset status
#define CXD900XX_RST_DDR_AHB_3               71    //DDR_AHB 7:4 RWCSTAT 0x0 DDR regHRESETn reset status
#define CXD900XX_RST_DDR_AXI_0               72    //DDR_AXI 11:8 RWCSTAT 0x0 DDR axi0_ARESETn reset status
#define CXD900XX_RST_DDR_AXI_1               73    //DDR_AXI 11:8 RWCSTAT 0x0 DDR axi0_ARESETn reset status
#define CXD900XX_RST_DDR_AXI_2               74    //DDR_AXI 11:8 RWCSTAT 0x0 DDR axi0_ARESETn reset status
#define CXD900XX_RST_DDR_AXI_3               75    //DDR_AXI 11:8 RWCSTAT 0x0 DDR axi0_ARESETn reset status
#define CXD900XX_RST_DDR_CORE_0              76    //DDR_CORE 15:12 RWCSTAT 0x0 DDR rst_n reset status
#define CXD900XX_RST_DDR_CORE_1              77    //DDR_CORE 15:12 RWCSTAT 0x0 DDR rst_n reset status
#define CXD900XX_RST_DDR_CORE_2              78    //DDR_CORE 15:12 RWCSTAT 0x0 DDR rst_n reset status
#define CXD900XX_RST_DDR_CORE_3              79    //DDR_CORE 15:12 RWCSTAT 0x0 DDR rst_n reset status
#define CXD900XX_RST_DDR_PHY_0               80    //DDR_PHY 19:16 RWCSTAT 0x0 DDR PHYx_phy_rst_n reset status
#define CXD900XX_RST_DDR_PHY_1               81    //DDR_PHY 19:16 RWCSTAT 0x0 DDR PHYx_phy_rst_n reset status
#define CXD900XX_RST_DDR_PHY_2               82    //DDR_PHY 19:16 RWCSTAT 0x0 DDR PHYx_phy_rst_n reset status
#define CXD900XX_RST_DDR_PHY_3               83    //DDR_PHY 19:16 RWCSTAT 0x0 DDR PHYx_phy_rst_n reset status
#define CXD900XX_RST_REVERSE_2_20            84
#define CXD900XX_RST_REVERSE_2_21            85
#define CXD900XX_RST_REVERSE_2_22            86
#define CXD900XX_RST_REVERSE_2_23            87
#define CXD900XX_RST_REVERSE_2_24            88
#define CXD900XX_RST_REVERSE_2_25            89
#define CXD900XX_RST_REVERSE_2_26            90
#define CXD900XX_RST_REVERSE_2_27            91
#define CXD900XX_RST_REVERSE_2_28            92
#define CXD900XX_RST_REVERSE_2_29            93
#define CXD900XX_RST_REVERSE_2_30            94
#define CXD900XX_RST_REVERSE_2_31            95


// Software Reset Enable Register for cpu DMA bus
#define CXD900XX_RST_REVERSE_3_0             96
#define CXD900XX_RST_REVERSE_3_1             97
#define CXD900XX_RST_SUB_CA35SP_CPU          98    //Sub_CA35SP_CPU 2 RWCSTAT 0x1 CA35 SP CPU soft reset status
#define CXD900XX_RST_SUB_CA35SP_DBG          99    //Sub_CA35SP_DBG 3 RWCSTAT 0x1 CA35 SP DEBUG soft reset status
#define CXD900XX_RST_SUB_CA35SP_L2R          100   //Sub_CA35SP_L2R 4 RWCSTAT 0x1 CA35 SP L2 soft reset status
#define CXD900XX_RST_SUB_CA35SP_CORE         101   //Sub_CA35SP_CORE 5 RWCSTAT 0x1 CA35 SP CORE soft reset status
#define CXD900XX_RST_CA35MP4_0CORE           102   //CA35MP4_0CORE 6 RWCSTAT 0x0 Coresignt soft reset status
#define CXD900XX_RST_CA35MP4_1CORE           103   //CA35MP4_1CORE 7 RWCSTAT 0x0 Coresignt soft reset status
#define CXD900XX_RST_CA35MP4_2CORE           104   //CA35MP4_2CORE 8 RWCSTAT 0x0 Coresignt soft reset status
#define CXD900XX_RST_CA35MP4_3CORE           105   //CA35MP4_3CORE 9 RWCSTAT 0x0 Coresignt soft reset status
#define CXD900XX_RST_CA35MP4_DBG             106   //CA35MP4_DBG 10 RWCSTAT 0x0 Coresignt soft reset status
#define CXD900XX_RST_CA35MP4_L2R             107   //CA35MP4_L2R 11 RWCSTAT 0x0 Coresignt soft reset status
#define CXD900XX_RST_GIC_MAIN                108   //GIC_main 12 RWCSTAT 0x0 GIC_main soft reset status
#define CXD900XX_RST_GIC_SUB                 109   //GIC_sub 13 RWCSTAT 0x0 GIC_sub soft reset status
#define CXD900XX_RST_DMAC_330_0              110   //DMAC_330_0 14 RWCSTAT 0x0 DMAC_330_0 soft reset status
#define CXD900XX_RST_DMAC_330_1              111   //DMAC_330_1 15 RWCSTAT 0x0 DMAC_330_1 soft reset status
#define CXD900XX_RST_DMAC_PERI0              112   //DMAC_peri0 16 RWCSTAT 0x0 DMAC_peri0 soft reset status
#define CXD900XX_RST_DMAC_PERI1              113   //DMAC_peri1 17 RWCSTAT 0x0 DMAC_peri1 soft reset status
#define CXD900XX_RST_REVERSE_3_18            114
#define CXD900XX_RST_BUS_PROFILER            115   //Bus_profiler 19 RWCSTAT 0x0 Bus_profiler soft reset status
#define CXD900XX_RST_AXI2AVB_MAIN_CPU        116   //AXI2AVB_main_cpu 20 RWCSTAT 0x0 AXI2AVB_main_cpu soft reset status
#define CXD900XX_RST_AXI2AVB_SUB_CPU         117   //AXI2AVB_sub_cpu 21 RWCSTAT 0x0 AXI2AVB_sub_cpu soft reset status
#define CXD900XX_RST_AXI2AVB_PCI             118   //AXI2AVB_pci 22 RWCSTAT 0x0 AXI2AVB_pci soft reset status
#define CXD900XX_RST_AXI2AVB_PCI_I0          119   //AXI2AVB_pci_i0 23 RWCSTAT 0x0 AXI2AVB_pci_i0 soft reset status
#define CXD900XX_RST_REVERSE_3_24            120
#define CXD900XX_RST_AXI2AVB_MEDIA           121   //AXI2AVB_media 25 RWCSTAT 0x0 AXI2AVB_media soft reset status
#define CXD900XX_RST_AXI2AVB_DMA0            122   //AXI2AVB_dma0 26 RWCSTAT 0x0 AXI2AVB_dma0 soft reset status
#define CXD900XX_RST_REVERSE_3_27            123
#define CXD900XX_RST_REVERSE_3_28            124
#define CXD900XX_RST_REVERSE_3_29            125
#define CXD900XX_RST_REVERSE_3_30            126
#define CXD900XX_RST_REVERSE_3_31            127


// Software Reset Enable Register for timer
#define CXD900XX_RST_TIMER_0                 128    //Timer_0 0 RWCSTAT 0x0 main CPU Timer0 reset status
#define CXD900XX_RST_TIMER_1                 129    //Timer_1 1 RWCSTAT 0x0 main CPU Timer1 reset status
#define CXD900XX_RST_TIMER_2                 130    //Timer_2 2 RWCSTAT 0x0 main CPU Timer2 reset status
#define CXD900XX_RST_TIMER_3                 131    //Timer_3 3 RWCSTAT 0x0 main CPU Timer3 reset status
#define CXD900XX_RST_TIMER_4                 132    //Timer_4 4 RWCSTAT 0x0 main CPU Timer4 reset status
#define CXD900XX_RST_TIMER_5                 133    //Timer_5 5 RWCSTAT 0x0 main CPU Timer5 reset status
#define CXD900XX_RST_TIMER_6                 134    //Timer_6 6 RWCSTAT 0x0 main CPU Timer6 reset status
#define CXD900XX_RST_TIMER_7                 135    //Timer_7 7 RWCSTAT 0x0 main CPU Timer7 reset status
#define CXD900XX_RST_TIMER_8                 136    //Timer_8 8 RWCSTAT 0x0 main CPU Timer8 reset status
#define CXD900XX_RST_TIMER_9                 137    //Timer_9 9 RWCSTAT 0x0 main CPU Timer9 reset status
#define CXD900XX_RST_TIMER_10                138    //Timer_10 10 RWCSTAT 0x0 main CPU Timer10 reset status
#define CXD900XX_RST_TIMER_11                139    //Timer_11 11 RWCSTAT 0x0 main CPU Timer11 reset status
#define CXD900XX_RST_TIMER_12                140    //Timer_12 12 RWCSTAT 0x0 main CPU Timer12 reset status
#define CXD900XX_RST_TIMER_13                141    //Timer_13 13 RWCSTAT 0x0 main CPU Timer13 reset status
#define CXD900XX_RST_TIMER_14                142    //Timer_14 14 RWCSTAT 0x0 main CPU Timer14 reset status
#define CXD900XX_RST_TIMER_15                143    //Timer_15 15 RWCSTAT 0x0 main CPU Timer15 reset status
#define CXD900XX_RST_REVERSE_4_16            144
#define CXD900XX_RST_REVERSE_4_17            145
#define CXD900XX_RST_WDT_MAIN_CPU            146    //WDT_main_CPU 18 RWCSTAT 0x0 main CPU WDT reset status
#define CXD900XX_RST_REVERSE_4_19            147
#define CXD900XX_RST_TPU0                    148    //TPU0 20 RWCSTAT 0x0 TPU0reset status
#define CXD900XX_RST_TPU1                    149    //TPU1 21 RWCSTAT 0x0 TPU1reset status
#define CXD900XX_RST_TPU2                    150    //TPU2 22 RWCSTAT 0x0 TPU2reset status
#define CXD900XX_RST_TPU3                    151    //TPU3 23 RWCSTAT 0x0 TPU3reset status
#define CXD900XX_RST_TPUINPUT0               152    //TPUINPUT0 24 RWCSTAT 0x0 TPUINPUT0 reset status
#define CXD900XX_RST_TPUINPUT1               153    //TPUINPUT1 25 RWCSTAT 0x0 TPUINPUT1 reset status
#define CXD900XX_RST_REVERSE_4_26            154
#define CXD900XX_RST_REVERSE_4_27            155
#define CXD900XX_RST_REVERSE_4_28            156
#define CXD900XX_RST_REVERSE_4_29            157
#define CXD900XX_RST_REVERSE_4_30            158
#define CXD900XX_RST_REVERSE_4_31            159


// Software Reset Enable Register for peripheral communication IP
#define CXD900XX_RST_SIO0                    160    //SIO0 0 RWCSTAT 0x0 SIO0 reset status
#define CXD900XX_RST_SIO1                    161    //SIO1 1 RWCSTAT 0x0 SIO1 reset status
#define CXD900XX_RST_SIO2                    162    //SIO2 2 RWCSTAT 0x0 SIO2 reset status
#define CXD900XX_RST_REVERSE_5_3             163
#define CXD900XX_RST_REVERSE_5_4             164
#define CXD900XX_RST_REVERSE_5_5             165
#define CXD900XX_RST_UART0                   166    //UART0 6 RWCSTAT 0x0 UART0 reset status
#define CXD900XX_RST_UART1                   167    //UART1 7 RWCSTAT 0x0 UART1 reset status
#define CXD900XX_RST_UART2                   168    //UART2 8 RWCSTAT 0x0 UART2 reset status
#define CXD900XX_RST_UART3                   169    //UART3 9 RWCSTAT 0x0 UART3 reset status
#define CXD900XX_RST_UART4                   170    //UART4 10 RWCSTAT 0x0 UART4 reset status
#define CXD900XX_RST_REVERSE_5_11            171
#define CXD900XX_RST_SPI0_SSP                172    //SPI0_SSP 12 RWCSTAT 0x0 SPI0 nSSPRST reset status
#define CXD900XX_RST_SPI0_APB                173    //SPI0_APB 13 RWCSTAT 0x0 SPI0 PRESETn reset status
#define CXD900XX_RST_SPI1_SSP                174    //SPI1_SSP 14 RWCSTAT 0x0 SPI1 nSSPRST reset status
#define CXD900XX_RST_SPI1_APB                175    //SPI1_APB 15 RWCSTAT 0x0 SPI1 PRESETn reset status
#define CXD900XX_RST_SPI2_SSP                176    //SPI2_SSP 16 RWCSTAT 0x0 SPI2 nSSPRST reset status
#define CXD900XX_RST_SPI2_APB                177    //SPI2_APB 17 RWCSTAT 0x0 SPI2 PRESETn reset status
#define CXD900XX_RST_SPI3_SSP                178    //SPI3_SSP 18 RWCSTAT 0x0 SPI3 nSSPRST reset status
#define CXD900XX_RST_SPI3_APB                179    //SPI3_APB 19 RWCSTAT 0x0 SPI3 PRESETn reset status
#define CXD900XX_RST_SPI4_SSP                180    //SPI4_SSP 20 RWCSTAT 0x0 SPI4 nSSPRST reset status
#define CXD900XX_RST_SPI4_APB                181    //SPI4_APB 21 RWCSTAT 0x0 SPI4 PRESETn reset status
#define CXD900XX_RST_REVERSE_5_22            182
#define CXD900XX_RST_REVERSE_5_23            183
#define CXD900XX_RST_I2C0                    184    //I2C0 24 RWCSTAT 0x0 I2C0 reset status
#define CXD900XX_RST_I2C1                    185    //I2C1 25 RWCSTAT 0x0 I2C1 reset status
#define CXD900XX_RST_REVERSE_5_26            186
#define CXD900XX_RST_REVERSE_5_27            187
#define CXD900XX_RST_REVERSE_5_28            188
#define CXD900XX_RST_REVERSE_5_29            189
#define CXD900XX_RST_REVERSE_5_30            190
#define CXD900XX_RST_REVERSE_5_31            191


// Software Reset Enable Register for misc IP
#define CXD900XX_RST_GPIO_SYS                192    //GPIO_SYS 0 RWCSTAT 0x0 GPIO SYS reset status
#define CXD900XX_RST_GPIO_INT                193    //GPIO_INT 1 RWCSTAT 0x0 GPIO INT reset status
#define CXD900XX_RST_REVERSE_6_2             194
#define CXD900XX_RST_GPIO_00                 195    //GPIO_00 3 RWCSTAT 0x0 GPIO0 reset status
#define CXD900XX_RST_GPIO_01                 196    //GPIO_01 4 RWCSTAT 0x0 GPIO1 reset status
#define CXD900XX_RST_GPIO_02                 197    //GPIO_02 5 RWCSTAT 0x0 GPIO2 reset status
#define CXD900XX_RST_GPIO_03                 198    //GPIO_03 6 RWCSTAT 0x0 GPIO3 reset status
#define CXD900XX_RST_GPIO_04                 199    //GPIO_04 7 RWCSTAT 0x0 GPIO4 reset status
#define CXD900XX_RST_GPIO_05                 200    //GPIO_05 8 RWCSTAT 0x0 GPIO5 reset status
#define CXD900XX_RST_GPIO_06                 201    //GPIO_06 9 RWCSTAT 0x0 GPIO6 reset status
#define CXD900XX_RST_GPIO_07                 202    //GPIO_07 10 RWCSTAT 0x0 GPIO7 reset status
#define CXD900XX_RST_GPIO_08                 203    //GPIO_08 11 RWCSTAT 0x0 GPIO8 reset status
#define CXD900XX_RST_REVERSE_6_12            204
#define CXD900XX_RST_GPIO_10                 205    //GPIO_10 13 RWCSTAT 0x0 GPIO10 reset status
#define CXD900XX_RST_GPIO_11                 206    //GPIO_11 14 RWCSTAT 0x0 GPIO11 reset status
#define CXD900XX_RST_GPIO_12                 207    //GPIO_12 15 RWCSTAT 0x0 GPIO12 reset status
#define CXD900XX_RST_GPIO_13                 208    //GPIO_13 16 RWCSTAT 0x0 GPIO13 reset status
#define CXD900XX_RST_REVERSE_6_17            209
#define CXD900XX_RST_REVERSE_6_18            210
#define CXD900XX_RST_REVERSE_6_19            211
#define CXD900XX_RST_AD0                     212    //AD0 20 RWCSTAT 0x0 ADC0 reset status
#define CXD900XX_RST_AD1                     213    //AD1 21 RWCSTAT 0x0 ADC1 reset status
#define CXD900XX_RST_EFUSE                   214    //eFuse 22 RWCSTAT 0x0 eFUSE reset status
#define CXD900XX_RST_OMC_AND_ROSC            215    //OMC_and_ROSC 23 RWCSTAT 0x0 ROSC reset status
#define CXD900XX_RST_REVERSE_6_24            216
#define CXD900XX_RST_REVERSE_6_25            217
#define CXD900XX_RST_REVERSE_6_26            218
#define CXD900XX_RST_REVERSE_6_27            219
#define CXD900XX_RST_REVERSE_6_28            220
#define CXD900XX_RST_REVERSE_6_29            221
#define CXD900XX_RST_REVERSE_6_30            222
#define CXD900XX_RST_REVERSE_6_31            223


// Software Reset Enable Register for misc IP
#define CXD900XX_RST_S_LOGIC                 224
#define CXD900XX_RST_REVERSE_7_1             225
#define CXD900XX_RST_REVERSE_7_2             226
#define CXD900XX_RST_REVERSE_7_3             227
#define CXD900XX_RST_REVERSE_7_4             228
#define CXD900XX_RST_REVERSE_7_5             229
#define CXD900XX_RST_REVERSE_7_6             230
#define CXD900XX_RST_REVERSE_7_7             231
#define CXD900XX_RST_REVERSE_7_8             232
#define CXD900XX_RST_REVERSE_7_9             233
#define CXD900XX_RST_REVERSE_7_10            234
#define CXD900XX_RST_REVERSE_7_11            235
#define CXD900XX_RST_REVERSE_7_12            236
#define CXD900XX_RST_REVERSE_7_13            237
#define CXD900XX_RST_REVERSE_7_14            238
#define CXD900XX_RST_REVERSE_7_15            239
#define CXD900XX_RST_REVERSE_7_16            240
#define CXD900XX_RST_REVERSE_7_17            241
#define CXD900XX_RST_REVERSE_7_18            242
#define CXD900XX_RST_REVERSE_7_19            243
#define CXD900XX_RST_REVERSE_7_20            244
#define CXD900XX_RST_REVERSE_7_21            245
#define CXD900XX_RST_REVERSE_7_22            246
#define CXD900XX_RST_REVERSE_7_23            247
#define CXD900XX_RST_REVERSE_7_24            248
#define CXD900XX_RST_REVERSE_7_25            249
#define CXD900XX_RST_REVERSE_7_26            250
#define CXD900XX_RST_REVERSE_7_27            251
#define CXD900XX_RST_REVERSE_7_28            252
#define CXD900XX_RST_REVERSE_7_29            253
#define CXD900XX_RST_REVERSE_7_30            254
#define CXD900XX_RST_REVERSE_7_31            255


#endif /* _CXD900XX_RESET_REGS_H_ */
