/*
 * drivers/clocksource/cxd-sched_clock.c
 *
 * IRQ definitions
 *
 * Copyright 2018 Sony Corporation
 *
 * This code is based on kernel/time/sched_clock.c
 */
/*
 * sched_clock.c: Generic sched_clock() support, to extend low level
 *                hardware time counters to full 64-bit ns values.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */
#include <linux/sched.h>
#include <linux/clocksource.h>
#include <linux/sched_clock.h>

#define MHz 1000000
#define GHz (1000*MHz)

#ifdef CONFIG_ARCH_CXD900XX_FPGA
# define FREQx8 CONFIG_ARCH_CXD900XX_FPGACLK
# define SCALE 100000
# define MULT (GHz/SCALE)
# define DIV  (FREQx8/SCALE)
#else
# define FREQ (2*MHz)
# define PERIOD (GHz/FREQ) /*ns*/
#endif

static inline u64 notrace cyc_to_ns(u64 cyc)
{
#ifdef CONFIG_ARCH_CXD900XX_FPGA
	cyc *= MULT * 8;
	return cyc / DIV;
#else
	return cyc * PERIOD;
#endif
}

unsigned long long notrace sched_clock(void)
{
	u64 cyc;

	cyc = get_cycles();
	return cyc_to_ns(cyc);
}
