/*
 *  i2c-guc.h -
 */
#ifndef _I2C_GUC_H
#define _I2C_GUC_H


//#define writel(data, reg)	*(volatile unsigned int*)(reg) = (data)
//#define readl(reg)		(*(volatile unsigned int*)(reg))

struct i2c_bus {
	u32	addr;
	int	bStart;
};

#define i2c_tx_fifo_size 8
#define i2c_rx_fifo_empty 0

#define i2c_tx_full_threshold 6
#define i2c_tx_empty_threshold 2
#define i2c_rx_full_threshold 6
#define i2c_rx_empty_threshold 2

#define READ_FLAG	1
#define WRITE_FLAG	0

/* DMA Interface Enable Register */
#define I2C_DMA_DISABLE			0x0000
//#define I2C_TX_DMA_ENABLE		0x0001
//#define I2C_RX_DMA_ENABLE		0x0002

/* Command Register */
#define I2C_START_CMD			0x0001
#define I2C_RE_START_CMD		0x0002
#define I2C_STOP_CMD			0x0004

/* I2C Enable Register */
#define I2C_ENABLE			0x0001

/* Interrupt Status */
#define I2C_RX_EARLY_STOP_INT		0x8000
#define I2C_TX_EARLY_STOP_INT		0x4000
#define I2C_RX_FIFO_UNDERFLOW_INT	0x2000
#define I2C_RX_FIFO_EMPTY_INT		0x1000
#define I2C_RX_FIFO_ALMOST_EMPTY_INT	0x0800
#define I2C_RX_FIFO_ALMOST_FULL_INT	0x0400
#define I2C_RX_FIFO_FULL_INT		0x0200
#define I2C_TX_FIFO_EMPTY_INT		0x0100
#define I2C_TX_FIFO_ALMOST_EMPTY_INT	0x0080
#define I2C_TX_FIFO_ALMOST_FULL_INT	0x0040
#define I2C_TX_FIFO_FULL_INT		0x0020
#define I2C_TX_FIFO_OVERFLOW_INT	0x0010
#define I2C_SLAVE_NACK_INT		0x0008
#define I2C_STOP_INT			0x0004
#define I2C_REPEATED_START_INT		0x0002
#define I2C_START_INT			0x0001


#define IC_CON_MASTER			0x1
#define IC_CON_SPEED_STD		0x2
#define IC_CON_SPEED_FAST		0x4
#define IC_CON_10BITADDR_MASTER		0x10
#define IC_CON_RESTART_EN		0x20
#define IC_CON_SLAVE_DISABLE		0x40



//DMA Interface Enable Register
#define  DMA_DISABLE     0x00000000

/*
 * status codes
 */
#define STATUS_IDLE			0x0
#define STATUS_WRITE_IN_PROGRESS	0x1
#define STATUS_READ_IN_PROGRESS		0x2

#define IC_INTR_DEFAULT_MASK		(I2C_RX_FIFO_ALMOST_FULL_INT | I2C_STOP_INT)

struct guc_i2c_hs{
	struct device *dev;
	void __iomem		*base;
	struct i2c_adapter	adapter;
	int irq;
	unsigned int clk;
	struct clk *ipg_clk;
	struct i2c_msg *msg;
	int index;
	struct mutex		lock;
	spinlock_t          dev_lock;
	u32 clk_freq;
	struct i2c_msg          *msgs;
        int                     msgs_num;
        int                     msg_write_idx;
        u32                     tx_buf_len;
        u8                      *tx_buf;
        int                     msg_read_idx;
        u32                     rx_buf_len;
        u8                      *rx_buf;
        int                     msg_err;
        unsigned int            status;
	unsigned int		tx_fifo_depth;
	unsigned int		rx_fifo_depth;
	struct completion	cmd_complete;
	int			cmd_err;
	u32			read_flag;
	int			rx_outstanding;
	u32			first_read_flag;
	int			(*acquire_lock)(struct guc_i2c_hs *dev);
	void			(*release_lock)(struct guc_i2c_hs *dev);
} ;

struct gucasic_i2c {
	u32	i2c_rev;	/* 0x00 */
	u32	i2c_dma_en;
	u32	i2c_hold_scl;
	u32	i2c_scl_lo;
	u32	i2c_scl_hi;	/* 0x10 */
	u32	i2c_restart_setup;
	u32	i2c_start_hold;
	u32	i2c_stop_setup;
	u32	i2c_data_hold;	/* 0x20 */
	u32	i2c_spike;
	u32	i2c_tx_full;
	u32	i2c_tx_empty;
	u32	i2c_rx_full;	/* 0x30 */
	u32	i2c_rx_empty;
	u32	i2c_data_cnt;
	u32	i2c_tx_data;
	u32	i2c_rx_data;	/* 0x40 */
	u32	i2c_tar;
	u32	i2c_dir;
	u32	i2c_cmd;
	u32	i2c_en;		/* 0x50 */
	u32	i2c_reset_fifo;
	u32	i2c_tx_cnt;
	u32	i2c_rx_cnt;
	u32	i2c_tx_valid_cnt; /* 0x60 */
	u32	i2c_rx_valid_cnt;
	u32	i2c_intr;
	u32	i2c_intr_mask;
	u32	i2c_raw_intr;	/* 0x70 */
	u32	i2c_intr_clr;
};
#endif //_I2C_GUC_H
