/*
**
*Copyright 2018 Sony Imaging Products & Solutions Inc
*Copyright 2018 Sony Corporation
**
*/

#include "dt_node_en_ctrl.h"

#define DEBUG_ENABLE
#ifdef DEBUG_ENABLE
#define DBG printk
#else
#define DBG(fmt, args...) do {} while (0)
#endif

static LIST_HEAD(dt_node);

static struct property props_status_ok =
{
	.name = "status",
	.value = "ok",
	.length = 3
};

static struct property props_status_disabled =
{
	.name = "status",
	.value = "disabled",
	.length = 9
};

//static dt_node_modify_t stNode[PCIE_RC_CNT] ;

static int dt_node_set_enable(dt_node_modify_t* ptr , bool enabled)
{
	struct device_node * ptr_dn = ptr->ptr_dn;
	struct of_changeset* ptr_ocs  =  &ptr->ocs;
    struct property * prop = NULL;

	int ret;

	if((enabled && of_device_is_available(ptr_dn)) ||\
	   ((!enabled) && (!of_device_is_available(ptr_dn))))
	{
		if(enabled)
			DBG("The node(%s) had been enabled already !\n", ptr->name);
	        else
	                DBG("The node(%s) had been disabled already !\n", ptr->name);

		return 0;
	}

        if(ptr->b1stSet)
        {
		if(enabled)
		{
			ptr->bOri_On= false;
            prop = __of_prop_dup(&props_status_ok, GFP_KERNEL);
		}
		else
		{
			ptr->bOri_On= true;
            prop = __of_prop_dup(&props_status_disabled, GFP_KERNEL);
        }

        if(prop == NULL)
            goto err;

        of_changeset_update_property(ptr_ocs, ptr_dn, prop);
		of_node_put(ptr_dn);
		ret = of_changeset_apply(ptr_ocs);

		if (ret)
			goto err;

		ptr->b1stSet = false;
        }
        else
	{
		if(((!enabled) && ptr->bOri_On) ||(enabled && (!ptr->bOri_On)))
			ret = of_changeset_apply(ptr_ocs);
		else
			ret = of_changeset_revert(ptr_ocs);

		if (ret)
			goto err;
	}

        return 0;
err:
        return -1;
}

/*
 * sysfs
 */
static ssize_t dt_node_get_value(struct device *dev, struct device_attribute *attr,
				 const char *buf, size_t count)
{
	unsigned int setval;
	char name[20];
	bool enabled = false;
	int cnt, err;

	cnt = sscanf(buf, "%19s %u", name, &setval);
	if (cnt != 2)
		return -EINVAL;

	if(setval != 0)
		enabled = true;

	err = dt_node_en_ctrl(name, enabled);
	if (err)
		return err;
	return count;
}

int dt_node_en_ctrl(char *name, bool enabled)
{
	bool found = false;
	int err;
	struct list_head *pos;
	struct device_node *ptr_dn;
	dt_node_modify_t * ptr  = NULL;

	ptr_dn = of_find_node_by_name(NULL, name);
	if (ptr_dn == NULL) {
		DBG("The node(%s) didn't exist!\n", name);
		return -EINVAL;
	}

	list_for_each(pos, &dt_node)
	{
		ptr =  list_entry(pos, dt_node_modify_t, list);
	        if(ptr == NULL)
			continue;

	        //DBG(" %s is checking..\n", ptr->name);
		if(!strcmp(ptr->name, name))
		{
			DBG("found %s in the list\n", ptr->name);
			found = true;
			break;
		}
	}

	if(!found)
	{
		DBG("creat modification for %s \n", name);
	        ptr = kzalloc(sizeof(*ptr), GFP_KERNEL);
	        if (!ptr)
	                return -ENOMEM;

		strlcpy(ptr->name, name, sizeof ptr->name);
		ptr->ptr_dn = ptr_dn;
		of_changeset_init(&ptr->ocs);
		ptr->b1stSet = true;
		list_add_tail(&ptr->list, &dt_node);
	}

	err = dt_node_set_enable(ptr, enabled);
	if (err)
		return err;

	return 0;
}

static DEVICE_ATTR(dn_enabled, S_IWUSR, NULL, dt_node_get_value);

static void dt_node_ctrl_remove_sysfs(struct device *dev)
{
	device_remove_file(dev, &dev_attr_dn_enabled);
}

static void dt_node_ctrl_create_sysfs(struct device *dev)
{
	device_create_file(dev, &dev_attr_dn_enabled);
}

static int dt_node_en_ctrl_probe(struct platform_device *p_dev)
{
	dt_node_ctrl_create_sysfs(&p_dev->dev);
	return 0;
}

static int dt_node_en_ctrl_remove(struct platform_device *p_dev)
{
	dt_node_ctrl_remove_sysfs(&p_dev->dev);
	return 0;
}

static struct platform_driver dt_node_en_ctrl_driver = {
	.probe = dt_node_en_ctrl_probe,
	.remove = dt_node_en_ctrl_remove,
	.driver	= {
		.name = "dt_node_en_ctrl",
	},
};
static struct platform_device *ptr_dt_node_en_ctrl_device;
static int __init dt_node_en_ctrl_init (void)
{
        int ret ;

	ptr_dt_node_en_ctrl_device = platform_device_alloc("dt_node_en_ctrl", 0);
	if (ptr_dt_node_en_ctrl_device) {
		ret = platform_device_add(ptr_dt_node_en_ctrl_device);
		if(ret != 0)
			return -1;
	}
	ret = platform_driver_register(&dt_node_en_ctrl_driver);
	if(ret != 0)
		return -1;

        return 0;
}

static void __exit dt_node_en_ctrl_exit (void)
{
        platform_device_del(ptr_dt_node_en_ctrl_device);
        platform_driver_unregister(&dt_node_en_ctrl_driver);
}

module_init (dt_node_en_ctrl_init);
module_exit (dt_node_en_ctrl_exit);
MODULE_LICENSE("GPL");
