/*
 * Copyright 2018 Sony Imaging Products & Solutions Inc.
 * Copyright 2018 Sony Corporation.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef __DT_BINDINGS_CXD_900XX_CLK_H
#define __DT_BINDINGS_CXD_900XX_CLK_H

/*
 *  Clock source
 */

#define CXD_CLK_FIX_SYS_IN              0
#define CXD_CLK_FIX_PLL0_OUT            1
#define CXD_CLK_FIX_PLL0_CK396          2
#define CXD_CLK_FIX_PLL0_CK198          3
#define CXD_CLK_FIX_PLL0_CK99           4
#define CXD_CLK_FIX_PLL0_CK49P5         5
#define CXD_CLK_FIX_PLL0_CK24P75        6
#define CXD_CLK_FIX_PLL4_OUT            7
#define CXD_CLK_FIX_PLL4_CK_192         8
#define CXD_CLK_FIX_PLL4_CK_96          9
#define CXD_CLK_FIX_PLL4_CK_48          10
#define CXD_CLK_FIX_PLL4_CK_12          11
#define CXD_CLK_FIX_PLL4_CK_1           12
#define CXD_CLK_FIX_PLL4_CK_2           13
#define CXD_CLK_FIX_PLL4_CK_400K        14
#define CXD_CLK_FIX_PLL4_CK_33K         15

/*
 *  Gates
 */

#define CXD_CLK_GATE_USB_REF_CLK        16
#define CXD_CLK_GATE_USB_PCLK           17
#define CXD_CLK_GATE_USB_ACLK           18
#define CXD_CLK_GATE_USB_SUS_CLK        19

#define CXD_CLK_GATE_MS                 20

#define CXD_CLK_GATE_DMA0               21
#define CXD_CLK_GATE_DMA1               22

#define CXD_CLK_GATE_DMAPERI0           23
#define CXD_CLK_GATE_DMAPERI1           24

#define CXD_CLK_GATE_CRYPT_SPACC        25
#define CXD_CLK_GATE_CRYPT_BOOT         26

#define CXD_CLK_GATE_GIC_MAIN			27
#define CXD_CLK_GATE_GIC_SUB    		28
#define CXD_CLK_GATE_X2V_PCEI0			29
#define CXD_CLK_GATE_X2V_PCEI1			30
#define CXD_CLK_GATE_X2V_MEDIA			31
#define CXD_CLK_GATE_X2V_DMAC0			32

#define CXD_CLK_GATE_TIMER0             33
#define CXD_CLK_GATE_TIMER1             34
#define CXD_CLK_GATE_TIMER2             35
#define CXD_CLK_GATE_TIMER3             36
#define CXD_CLK_GATE_TIMER4             37
#define CXD_CLK_GATE_TIMER5             38
#define CXD_CLK_GATE_TIMER6             39
#define CXD_CLK_GATE_TIMER7             40
#define CXD_CLK_GATE_TIMER8             41
#define CXD_CLK_GATE_TIMER9             42
#define CXD_CLK_GATE_TIMER10            43
#define CXD_CLK_GATE_TIMER11            44
#define CXD_CLK_GATE_TIMER12            45
#define CXD_CLK_GATE_TIMER13            46
#define CXD_CLK_GATE_TIMER14            47
#define CXD_CLK_GATE_TIMER15            48

#define CXD_CLK_GATE_WDT                49

#define CXD_CLK_GATE_UART0             	50
#define CXD_CLK_GATE_UART1             	51
#define CXD_CLK_GATE_UART2             	52
#define CXD_CLK_GATE_UART3             	53
#define CXD_CLK_GATE_UART4             	54

#define CXD_CLK_GATE_SPI0              	55
#define CXD_CLK_GATE_SPI1              	56
#define CXD_CLK_GATE_SPI2              	57
#define CXD_CLK_GATE_SPI3              	58
#define CXD_CLK_GATE_SPI4              	59

#define CXD_CLK_GATE_I2C0              	60
#define CXD_CLK_GATE_I2C1              	61

#define CXD_CLK_GATE_PCIE_I_PCLK        62
#define CXD_CLK_GATE_PCIE_I_DBI_CLK    	63
#define CXD_CLK_GATE_PCIE_I_SLV_CLK    	64
#define CXD_CLK_GATE_PCIE_I_MST_CLK     65
#define CXD_CLK_GATE_PCIE_I_AUX_CLK     66

#define CXD_CLK_GATE_PCIE_M0_PCLK       67
#define CXD_CLK_GATE_PCIE_M0_DBI_CLK   	68
#define CXD_CLK_GATE_PCIE_M0_SLV_CLK   	69
#define CXD_CLK_GATE_PCIE_M0_MST_CLK    70
#define CXD_CLK_GATE_PCIE_M0_AUX_CLK    71

#define CXD_CLK_GATE_PCIE_M1_PCLK       72
#define CXD_CLK_GATE_PCIE_M1_DBI_CLK   	73
#define CXD_CLK_GATE_PCIE_M1_SLV_CLK   	74
#define CXD_CLK_GATE_PCIE_M1_MST_CLK    75
#define CXD_CLK_GATE_PCIE_M1_AUX_CLK    76

#define CXD_CLK_GATE_PCIE_C_PCLK        77
#define CXD_CLK_GATE_PCIE_C_DBI_CLK    	78
#define CXD_CLK_GATE_PCIE_C_SLV_CLK    	79
#define CXD_CLK_GATE_PCIE_C_MST_CLK     80
#define CXD_CLK_GATE_PCIE_C_AUX_CLK     81

#define CXD_CLK_GATE_PCIE_N_PCLK        82
#define CXD_CLK_GATE_PCIE_N_DBI_CLK    	83
#define CXD_CLK_GATE_PCIE_N_SLV_CLK    	84
#define CXD_CLK_GATE_PCIE_N_MST_CLK   	85
#define CXD_CLK_GATE_PCIE_N_AUX_CLK     86

/*
 *  Multiplexers
 */

#define CXD_CLK_SEL_UART0              	87
#define CXD_CLK_SEL_UART1              	88
#define CXD_CLK_SEL_UART2              	89
#define CXD_CLK_SEL_UART3              	90
#define CXD_CLK_SEL_UART4              	91

#define CXD_CLK_SEL_SDIO                92

#define CXD_CLK_SEL_EMMC                93

#define CXD_CLK_SEL_SDIF0               94
#define CXD_CLK_SEL_SDIF1              	95

#define CXD_CLK_SEL_MS                  96

#define CXD_CLK_SEL_SPI0               	97
#define CXD_CLK_SEL_SPI1               	98
#define CXD_CLK_SEL_SPI2               	99
#define CXD_CLK_SEL_SPI3               	100
#define CXD_CLK_SEL_SPI4               	101

/*
 *  Dividers
 */

#define CXD_CLK_DIV_SDIO                102

#define CXD_CLK_DIV_EMMC                103

#define CXD_CLK_DIV_SDIF0              	104

#define CXD_CLK_DIV_SDIF1               105

#define CXD_CLK_DIV_MS                  106

#define CXD_CLK_END                     107

#endif
