/*
 * cxd900x0_cpuid.h
 *
 * CPUID definitions
 *
 * Copyright 2015 Sony Corporation
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 */

#ifndef __PLAT_CXD900X0_INCLUDE_MACH_CXD900X0_CPUID_H
#define __PLAT_CXD900X0_INCLUDE_MACH_CXD900X0_CPUID_H

#define CXD900X0_CPUID_UNDEF	0xffffffffUL

#ifndef __ASSEMBLY__
extern unsigned long cxd900x0_cpuid;

#define IS_CXD900X0_CPUID_UNDEF() (CXD900X0_CPUID_UNDEF == cxd900x0_cpuid)

extern int cxd900x0_pcie_exists(void);
extern void cxd900x0_update_cpuid(void);
extern void cxd900x0_read_cpuid(void);
#endif /* !__ASSEMBLY__ */

#endif /* __PLAT_CXD900X0_INCLUDE_MACH_CXD900X0_CPUID_H */
