/*
 * arch/arm/mach-cxd900x0/include/mach/pcie_export.h
 *
 * PCIE API
 *
 * Copyright 2012,2013 Sony Corporation
 *
 * ALL RIGHTS RESERVED, COPYRIGHT (C) SOCIONEXT INC. 2015
 * LICENSED MATERIAL - PROGRAM PROPERTY OF SOCIONEXT INC.
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 */
#ifndef __ARCH_CXD900X0_PCIE_EXPORT_H
#define __ARCH_CXD900X0_PCIE_EXPORT_H

struct pcie_hook {
	void (*perst)(struct pci_dev *bridge, int assert, int changed);
	void (*remove)(struct pci_dev *bridge);
};

struct pcie_device;
extern int pcie_root_port_max_busnr(struct pci_dev *bridge);
extern int pcie_root_port_prsnt(struct pcie_device *dev);
extern int pcie_root_port_pdc(struct pcie_device *dev);
extern int pcie_port_perst(struct pci_dev *bridge, int assert);
extern void pcie_root_ctrl(int ch, int enable);
extern int pcie_slot_ctrl(int id, int enable);
extern void set_pcie_hook(struct pcie_hook *);
#ifdef CONFIG_HOTPLUG_PCI_SELECT_NOTIFICATION
extern bool pcie_use_notification(u32 psn);
#endif /* CONFIG_HOTPLUG_PCI_SELECT_NOTIFICATION */
extern int pcie_wait_datalink(int busnr, unsigned int msec);
extern int pcie_hot_add(int busnr);
extern int pcie_hot_remove(int busnr);

extern int arch_pcie_service_irqs(struct pci_dev *dev, int *irqs, int mask);
extern void pcibios_configure_slot(struct pci_dev *dev);
extern int pcibios_assign_resource(struct pci_dev *dev, int resno, int size, resource_size_t min_align);

#ifdef CONFIG_PM
extern void f_pcie2_dme_suspend(void);
extern void f_pcie2_dme_resume(void);
#endif /* CONFIG_PM */

#endif /* __ARCH_CXD900X0_PCIE_EXPORT_H */
