/*
 * arch/arm/mach-cxd900x0/pm_macro.S
 *
 * sleep macro
 *
 * Copyright 2016 Sony Corporation
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 */
#include <mach/hardware.h>
#include <mach/bootram.h>
#include <mach/regs-ddrc.h>
#include <mach/regs-octrl.h>

	.macro	pm_workarea_va,rx
	ldr	\rx, =VA_BOOTRAM+CXD900X0_SUSPEND_WORKAREA
	.endm

	.macro	pm_workarea_phys,rx
	ldr	\rx, =CXD900X0_ESRAM_BASE+CXD900X0_SUSPEND_WORKAREA
	.endm

	.macro	pm_stack_phys,rx
	ldr	\rx, =CXD900X0_ESRAM_BASE+CXD900X0_SUSPEND_WORKAREA
	.endm

	.macro	pm_outer_cache
#if defined(CONFIG_CACHE_PL310)
	bl	pl310_shutdown		@ r0-r2 corrupted
#endif
	.endm

	.macro	pm_memory
	@ DDR_A
	ldr	r0, =CXD900X0_DDRC_A
	ldr	r1, cxd900x0_ddrA_ctrl	@ PC relative
	bl	ddr_ctrl
	@ DDR_B
	ldr	r0, =CXD900X0_DDRC_B
	ldr	r1, cxd900x0_ddrB_ctrl	@ PC relative
	bl	ddr_ctrl
	.endm

	.macro	pm_functions
ddr_ctrl:
	@ DDR control
	@  input: r0=DDRC address
	@ 	  r1=command(bit0=DPD CS0,bit1=DPD CS1,bit2=SRef)
	@  output: none.
	@  destruct: none.
	@
	stmdb	sp!, {r2, lr}
	tst	r1, #DDRC_DPD_CS0
	beq	1f
	@ DPD CS0
	mov	r2, #DDR_CS0
	bl	exec_dpd
1:
	tst	r1, #DDRC_DPD_CS1
	beq	1f
	@ DPD CS1
	mov	r2, #DDR_CS1
	bl	exec_dpd
1:
	tst	r1, #DDRC_SREF
	beq	1f
	@ SRef
	bl	exec_sref
1:
	ldmia	sp!, {r2, pc}

exec_dpd:
	@ Let CS# to enter Deep Power Down
	@  input: r0=DDRC address, r2=CS#
	@  output: none.
	@  destruct: none.
	@
	stmdb	sp!, {r3-r5,lr}
	bl	ddr_idle
	bl	clear_pcpcs_cs_map		@ r5=int_status
	tst	r5, #INTSTAT_PCPCS_ERR_BIT	@ error?
	bne	1f
	bl	set_lp_cs
	ldr	r3, =LPCMD_DPD_CMD
	bl	issue_lp_cmd
1:
	ldmia	sp!, {r3-r5,pc}

exec_sref:
	@ Enter Self Refresh
	@  input: r0=DDRC address
	@  output: none.
	@  destruct: none.
	@
	stmdb	sp!, {r3-r5,lr}
	@ wait for !controller_busy
1:
	ldr	r5, [r0, #CTRLBUSY_REG]
	tst	r5, #CTRLBUSY_BIT
	bne	1b
	@ Self Refresh
	ldr	r3, =LPCMD_SREF_CMD
	bl	issue_lp_cmd
	ldmia	sp!, {r3-r5,pc}

issue_lp_cmd:
	@ Issue lp_cmd and wait for completion
	@  input: r0=DDRC address, r3=lp_cmd
	@  output: none
	@  destruct: r4,r5
	@
	@ clear int_status
	mov	r4, #INTSTAT_LPCMD_DONE_BIT
	str	r4, [r0, #INTACK_REG]
	@ issue lp_cmd
	str	r3, [r0, #LPCMD_REG]
	@ wait for completion
1:
	ldr	r5, [r0, #INTSTAT_REG]
	tst	r5, #INTSTAT_LPCMD_DONE_BIT
	beq	1b
	mov	pc, lr

set_lp_cs:
	@ set CS# in lp_cs
	@  input: r0=DDRC address, r2=CS#
	@  output: none
	@  destruct: r4,r5
	@
	sel_lp_cs r2, r4		@ r4=bitmask
	ldr	r5, [r0, #LP_CS_REG]
	bic	r5, r5, #LP_CS_MASK	@ clear CS0 and CS1
	orr	r5, r5, r4		@ set CS#
	str	r5, [r0, #LP_CS_REG]
	mov	pc, lr

clear_pcpcs_cs_map:
	@ Clear CS# in pcpcs_cs_map and wait for completion
	@  input: r0=DDRC address, r2=CS#
	@  output: r5=int_status
	@  destruct: r4,r5
	@
	@ clear int_status
	mov	r4, #INTACK_PCPCS_BITMASK
	str	r4, [r0, #INTACK_REG]

	@ clear pcpcs_cs_map
	sel_pcpcs r2, r4		@ r4=bitmask
	ldr	r5, [r0, #PCPCS_CSMAP_REG]
	bic	r5, r5, r4
	str	r5, [r0, #PCPCS_CSMAP_REG]

	@ wait for completion
1:
	ldr	r5, [r0, #INTSTAT_REG]
	tst	r5, #INTSTAT_PCPCS_DONE_BIT
	beq	1b
	mov	pc, lr

ddr_idle:
	@ wait for csX_idle
	@  input: r0=DDRC address, r2=CS#
	@  output: none.
	@  destruct: r3,r4,r5
	@
	sel_cs_idle r2, r3, r4		@ r3=reg, r4=bitmask

	@ wait for csX_idle
1:
	ldr	r5, [r0, r3]
	tst	r5, r4
	beq	1b
	mov	pc, lr

	.endm
