/*
 * arch/arm/mach-cxd90014/pci_platform.h
 *
 * Copyright (C) 2011-2012 FUJITSU SEMICONDUCTOR LIMITED
 *
 * ALL RIGHTS RESERVED, COPYRIGHT (C) SOCIONEXT INC. 2015
 * LICENSED MATERIAL - PROGRAM PROPERTY OF SOCIONEXT INC.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef __PCI_PLATFORM_H__
#define __PCI_PLATFORM_H__


#ifdef __cplusplus
extern "C" {
#endif

/* PCIe Channel */
#define PCIE_CHANNEL_MAX        2 /* Number of PCIe Channel */

#define PCIE_MODE_ENDPOINT      0
#define PCIE_MODE_ROOT          1

/* select_pcie_mode(0:endpoint / 1:rootcomplex */
#define PCIE_MODE_SELECT      PCIE_MODE_ROOT

/* PCI space */
#define PCIE0_MEM_IO                CXD900X0_PCIE0_IO_PHYS_BASE /* PCIe0 IO space base address */
#define PCIE0_MEM_NONPREF           CXD900X0_PCIE0_MEM_NONPREF /* PCIe0 memory space base address */

#define PCIE1_MEM_IO                CXD900X0_PCIE1_IO_PHYS_BASE /* PCIe1 IO space base address */
#define PCIE1_MEM_NONPREF           CXD900X0_PCIE1_MEM_NONPREF /* PCIe1 Memory space base address */

/* Sizes of above maps */
#define PCIE0_MEM_IO_SIZE           CXD900X0_PCIE0_IO_SIZE
#define PCIE0_MEM_NONPREF_SIZE      CXD900X0_PCIE0_MEM_NONPREF_SIZE

#define PCIE1_MEM_IO_SIZE           CXD900X0_PCIE1_IO_SIZE
#define PCIE1_MEM_NONPREF_SIZE      CXD900X0_PCIE1_MEM_NONPREF_SIZE

/* Config offset */
#define PCIE0_MAP_CONFIG_OFFSET     ( PCIE0_MEM_IO + 0x00200000U ) /* 2MB */
#define PCIE1_MAP_CONFIG_OFFSET     ( PCIE1_MEM_IO + 0x00200000U ) /* 2MB */

#define PCIE_CONFIG_SIZE            0x1000U
#define PCIE0_CONFIG_0              ( PCIE0_MAP_CONFIG_OFFSET + (PCIE_CONFIG_SIZE * 0 ))
#define PCIE1_CONFIG_0              ( PCIE1_MAP_CONFIG_OFFSET + (PCIE_CONFIG_SIZE * 0 ))

#define PCIE0_LINK_REG_BASE         ((void*)0xF0140000U)    /* PCIe0 Link REG(F_PCIE_DME) */
#define PCIE0_LINK_REG_SIZE         0x10000U                /* 64KB */
#define PCIE0_PHY_REG_BASE          ((void*)0xF0150000U)    /* PCIe0 PHY REG(F_PCIE_DME) */
#define PCIE0_PHY_REG_SIZE          0x10000U                /* 64KB */
#define WPCIE0_REG_BASE             ((void*)0xF0160000U)    /* PCIe0 REG(IK_PCIE_REG Area) */
#define WPCIE0_REG_SIZE             0x1000U                 /* 4KB */

#define PCIE1_LINK_REG_BASE         ((void*)0xF0180000U)    /* PCIe1 Link REG(F_PCIE_DME) */
#define PCIE1_LINK_REG_SIZE         0x10000U                /* 64KB */
#define PCIE1_PHY_REG_BASE          ((void*)0xF0190000U)    /* PCIe1 PHY REG(F_PCIE_DME) */
#define PCIE1_PHY_REG_SIZE          0x10000U                /* 64KB */
#define WPCIE1_REG_BASE             ((void*)0xF01A0000U)    /* PCIe1 REG(IK_PCIE_REG Area) */
#define WPCIE1_REG_SIZE             0x1000U                 /* 4KB */

#define PCIE_T0CSH_INT_O            1UL
#define PCIE_T0CSH_ILIPMGML_IP      (PCIE_T0CSH_INT_O << 8U)

#define PCIE_WAIT_MAX               1000000U

/* Root Port Physical Slot Number */
#define PCIE0_ROOT_PSN              1U
#define PCIE1_ROOT_PSN              2U

#ifdef __cplusplus
}
#endif /* #ifdef __cplusplus */
#endif /* #ifndef __PCI_PLATFORM_H__ */

/*---------------------------------------------------------------------------
  END
---------------------------------------------------------------------------*/
