/*
 * arch/arm/mach-cxd90014/reg_PCIE.h
 *
 * Copyright (C) 2011-2012 FUJITSU SEMICONDUCTOR LIMITED
 *
 * ALL RIGHTS RESERVED, COPYRIGHT (C) SOCIONEXT INC. 2015
 * LICENSED MATERIAL - PROGRAM PROPERTY OF SOCIONEXT INC.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef     __REG_PCIE_H__
#define     __REG_PCIE_H__

#ifdef __cplusplus
extern "C" {
#endif

/*----------------------------------------------------------------------------------------------*/
/* Vender ID (Offset 000h) -EP-                                                                 */
/*----------------------------------------------------------------------------------------------*/
typedef     uint16_t      PCIE_EP_TD_T0CSH_VID;

/*----------------------------------------------------------------------------------------------*/
/* Device ID (Offset 002h) -EP-                                                                 */
/*----------------------------------------------------------------------------------------------*/
typedef     uint16_t      PCIE_EP_TD_T0CSH_DID;

/*----------------------------------------------------------------------------------------------*/
/* Command Register (Offset 004h) -EP-                                                          */
/* Status Register (Offset 006h) -EP-                                                           */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       IOS     : 1;
        uint32_t       MS      : 1;
        uint32_t       BME     : 1;
        uint32_t               : 3;
        uint32_t       PER     : 1;
        uint32_t               : 1;
        uint32_t       SERRE   : 1;
        uint32_t               : 1;
        uint32_t       ID      : 1;
        uint32_t               : 5;

        uint32_t               : 3;
        uint32_t       IS      : 1;
        uint32_t       CL      : 1;
        uint32_t               : 3;
        uint32_t       MDPE    : 1;
        uint32_t               : 2;
        uint32_t       STA     : 1;
        uint32_t       RTA     : 1;
        uint32_t       RMA     : 1;
        uint32_t       SSE     : 1;
        uint32_t       DPE     : 1;
    }   bit;
}   PCIE_EP_UN_T0CSH_CRSR;

/*----------------------------------------------------------------------------------------------*/
/* Revision ID (Offset 008h) -EP-                                                               */
/*----------------------------------------------------------------------------------------------*/
typedef     uint8_t       PCIE_EP_TD_T0CSH_RID;

/*----------------------------------------------------------------------------------------------*/
/* Class Code (Offset 009h) -EP-                                                                */
/*----------------------------------------------------------------------------------------------*/
typedef     uint8_t       PCIE_EP_TD_T0CSH_CC;

/*----------------------------------------------------------------------------------------------*/
/* Cache Line Size (Offset 00Ch) -EP-                                                           */
/*----------------------------------------------------------------------------------------------*/
typedef     uint8_t       PCIE_EP_TD_T0CSH_CLS;

/*----------------------------------------------------------------------------------------------*/
/* Leytency Timer (Offset 00Dh) -EP-                                                            */
/*----------------------------------------------------------------------------------------------*/
typedef     uint8_t       PCIE_EP_TD_T0CSH_LT;

/*----------------------------------------------------------------------------------------------*/
/* Header Type (Offset 00Eh) -EP-                                                               */
/*----------------------------------------------------------------------------------------------*/
typedef     uint8_t       PCIE_EP_TD_T0CSH_HT;

/*----------------------------------------------------------------------------------------------*/
/* BIST (Offset 00Fh) -EP-                                                                      */
/*----------------------------------------------------------------------------------------------*/
typedef     uint8_t       PCIE_EP_TD_T0CSH_BIST;

/*----------------------------------------------------------------------------------------------*/
/* Base Address Register 0 (Offset 010h) -EP-                                                   */
/* Base Address Register 1 (Offset 014h) -EP-                                                   */
/* Base Address Register 2 (Offset 018h) -EP-                                                   */
/* Base Address Register 3 (Offset 01Ch) -EP-                                                   */
/* Base Address Register 4 (Offset 020h) -EP-                                                   */
/* Base Address Register 5 (Offset 024h) -EP-                                                   */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       MIOSI   : 1;
        uint32_t       MT      : 2;
        uint32_t       PF      : 1;
        uint32_t               : 3;
        uint32_t       BA      : 25;
    }   bit;
}   PCIE_EP_UN_T0CSH_BAR;

/*----------------------------------------------------------------------------------------------*/
/* Card Bus CIS Pointer (Offset 028h) -EP-                                                      */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       ASI     : 3;
        uint32_t       ASO     : 29;
    }   bit;
}   PCIE_EP_UN_T0CSH_CBCISP;

/*----------------------------------------------------------------------------------------------*/
/* Subsystem Vender ID (Offset 02Ch) -EP-                                                       */
/*----------------------------------------------------------------------------------------------*/
typedef     uint16_t      PCIE_EP_TD_T0CSH_SVID;

/*----------------------------------------------------------------------------------------------*/
/* Subsystem ID (Offset 02Eh) -EP-                                                              */
/*----------------------------------------------------------------------------------------------*/
typedef     uint16_t      PCIE_EP_TD_T0CSH_SID;

/*----------------------------------------------------------------------------------------------*/
/* Expansion ROM Base Address Register (Offset 030h) -EP-                                       */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       EROME   : 1;
        uint32_t               : 9;
        uint32_t       BA      : 22;
    }   bit;
}   PCIE_EP_UN_T0CSH_EROMBAR;

/*----------------------------------------------------------------------------------------------*/
/* Capabilities Pointer (Offset 034h) -EP-                                                      */
/*----------------------------------------------------------------------------------------------*/
typedef     uint32_t       PCIE_EP_TD_T0CSH_CP;

/*----------------------------------------------------------------------------------------------*/
/* Interrupt Line (Offset 03Ch) -EP-                                                            */
/* Interrupt Pin (Offset 03Dh) -EP-                                                             */
/* Min_Gnt/Max_Lat (Offset 03Eh) -EP-                                                           */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       IL      : 8;
        uint32_t       IP      : 8;
        uint32_t       MINGNT  : 8;
        uint32_t       MAXLAT  : 8;
    }   bit;
}   PCIE_EP_UN_T0CSH_ILIPMGML;

/*----------------------------------------------------------------------------------------------*/
/* Vender ID (Offset 000h) -ROOT-                                                               */
/*----------------------------------------------------------------------------------------------*/
typedef     uint16_t      PCIE_RC_TD_T1CSH_VID;

/*----------------------------------------------------------------------------------------------*/
/* Device ID (Offset 002h) -ROOT-                                                               */
/*----------------------------------------------------------------------------------------------*/
typedef     uint16_t      PCIE_RC_TD_T1CSH_DID;

/*----------------------------------------------------------------------------------------------*/
/* Command Register (Offset 004h) -ROOT-                                                        */
/* Status Register (Offset 006h) -ROOT-                                                         */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       IOS     : 1;
        uint32_t       MS      : 1;
        uint32_t       BME     : 1;
        uint32_t               : 3;
        uint32_t       PER     : 1;
        uint32_t               : 1;
        uint32_t       SERRE   : 1;
        uint32_t               : 1;
        uint32_t       ID      : 1;
        uint32_t               : 5;

        uint32_t               : 3;
        uint32_t       IS      : 1;
        uint32_t       CL      : 1;
        uint32_t               : 3;
        uint32_t       MDPE    : 1;
        uint32_t               : 2;
        uint32_t       STA     : 1;
        uint32_t       RTA     : 1;
        uint32_t       RMA     : 1;
        uint32_t       SSE     : 1;
        uint32_t       DPE     : 1;
    }   bit;
}   PCIE_RC_UN_T1CSH_CRSR;

/*----------------------------------------------------------------------------------------------*/
/* Revision ID (Offset 008h) -ROOT-                                                             */
/*----------------------------------------------------------------------------------------------*/
typedef     uint8_t       PCIE_RC_TD_T1CSH_RID;

/*----------------------------------------------------------------------------------------------*/
/* Class Code (Offset 009h) -ROOT-                                                              */
/*----------------------------------------------------------------------------------------------*/
typedef     uint8_t       PCIE_RC_TD_T1CSH_CC;

/*----------------------------------------------------------------------------------------------*/
/* Cache Line Size (Offset 00Ch) -ROOT-                                                         */
/*----------------------------------------------------------------------------------------------*/
typedef     uint8_t       PCIE_RC_TD_T1CSH_CLS;

/*----------------------------------------------------------------------------------------------*/
/* Leytency Timer (Offset 00Dh) -ROOT-                                                          */
/*----------------------------------------------------------------------------------------------*/
typedef     uint8_t       PCIE_RC_TD_T1CSH_LT;

/*----------------------------------------------------------------------------------------------*/
/* Header Type (Offset 00Eh) -ROOT-                                                             */
/*----------------------------------------------------------------------------------------------*/
typedef     uint8_t       PCIE_RC_TD_T1CSH_HT;

/*----------------------------------------------------------------------------------------------*/
/* BIST (Offset 00Fh) -ROOT-                                                                    */
/*----------------------------------------------------------------------------------------------*/
typedef     uint8_t       PCIE_RC_TD_T1CSH_BIST;

/*----------------------------------------------------------------------------------------------*/
/* Base Address Register 0 (Offset 010h) -ROOT-                                                 */
/* Base Address Register 1 (Offset 014h) -ROOT-                                                 */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       MIOSI   : 1;
        uint32_t       MT      : 2;
        uint32_t       PF      : 1;
        uint32_t               : 3;
        uint32_t       BA      : 25;
    }   bit;
}   PCIE_RC_UN_T1CSH_BAR;

/*----------------------------------------------------------------------------------------------*/
/* Primary Bus Number (Offset 018h) -ROOT-                                                      */
/*----------------------------------------------------------------------------------------------*/
typedef     uint8_t       PCIE_RC_TD_T1CSH_PBN;

/*----------------------------------------------------------------------------------------------*/
/* Secondary Bus Number (Offset 019h) -ROOT-                                                    */
/*----------------------------------------------------------------------------------------------*/
typedef     uint8_t       PCIE_RC_TD_T1CSH_SBN;

/*----------------------------------------------------------------------------------------------*/
/* Subordinate Bus Number (Offset 01Ah) -ROOT-                                                  */
/*----------------------------------------------------------------------------------------------*/
typedef     uint8_t       PCIE_RC_TD_T1CSH_SUBN;

/*----------------------------------------------------------------------------------------------*/
/* Secondary Leytency Timer (Offset 01Bh) -ROOT-                                                */
/*----------------------------------------------------------------------------------------------*/
typedef     uint8_t       PCIE_RC_TD_T1CSH_SLT;

/*----------------------------------------------------------------------------------------------*/
/* I/O Base (Offset 01Ch) -ROOT-                                                                */
/*----------------------------------------------------------------------------------------------*/
typedef     uint8_t       PCIE_RC_TD_T1CSH_IOB;

/*----------------------------------------------------------------------------------------------*/
/* I/O Limit (Offset 01Dh) -ROOT-                                                               */
/*----------------------------------------------------------------------------------------------*/
typedef     uint8_t       PCIE_RC_TD_T1CSH_IOL;

/*----------------------------------------------------------------------------------------------*/
/* Secondary Status (Offset 01Dh) -ROOT-                                                        */
/*----------------------------------------------------------------------------------------------*/
typedef     uint16_t      PCIE_RC_TD_T1CSH_SS;

/*----------------------------------------------------------------------------------------------*/
/* Memory Base (Offset 020h) -ROOT-                                                             */
/*----------------------------------------------------------------------------------------------*/
typedef     uint16_t      PCIE_RC_TD_T1CSH_MB;

/*----------------------------------------------------------------------------------------------*/
/* Memory Limit (Offset 022h) -ROOT-                                                            */
/*----------------------------------------------------------------------------------------------*/
typedef     uint16_t      PCIE_RC_TD_T1CSH_ML;

/*----------------------------------------------------------------------------------------------*/
/* Prefetchable Memory Base (Offset 024h) -ROOT-                                                */
/*----------------------------------------------------------------------------------------------*/
typedef     uint16_t      PCIE_RC_TD_T1CSH_PMB;

/*----------------------------------------------------------------------------------------------*/
/* PrefetchableMemory Limit (Offset 026h) -ROOT-                                                */
/*----------------------------------------------------------------------------------------------*/
typedef     uint16_t      PCIE_RC_TD_T1CSH_PML;

/*----------------------------------------------------------------------------------------------*/
/* Prefetchable Base Upper 32bit (Offset 028h) -ROOT-                                           */
/*----------------------------------------------------------------------------------------------*/
typedef     uint32_t       PCIE_RC_TD_T1CSH_PBU32;

/*----------------------------------------------------------------------------------------------*/
/* Prefetchable Limit Upper 32bit (Offset 02Ch) -ROOT-                                          */
/*----------------------------------------------------------------------------------------------*/
typedef     uint32_t       PCIE_RC_TD_T1CSH_PLU32;

/*----------------------------------------------------------------------------------------------*/
/* I/O Base Upper 16bit (Offset 030h) -ROOT-                                                    */
/*----------------------------------------------------------------------------------------------*/
typedef     uint16_t      PCIE_RC_TD_T1CSH_IOBU16;

/*----------------------------------------------------------------------------------------------*/
/* I/O Limit Upper 16bit (Offset 032h) -ROOT-                                                   */
/*----------------------------------------------------------------------------------------------*/
typedef     uint16_t      PCIE_RC_TD_T1CSH_IOLU16;

/*----------------------------------------------------------------------------------------------*/
/* Capabilities Pointer (Offset 034h) -ROOT-                                                    */
/*----------------------------------------------------------------------------------------------*/
typedef     uint32_t       PCIE_RC_TD_T1CSH_CP;

/*----------------------------------------------------------------------------------------------*/
/* Expansion ROM Base Address Register (Offset 038h) -ROOT-                                     */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       EROME   : 1;
        uint32_t               : 9;
        uint32_t       BA      : 22;
    }   bit;
}   PCIE_RC_UN_T1CSH_EROMBAR;

/*----------------------------------------------------------------------------------------------*/
/* Interrupt Line (Offset 03Ch) -ROOT-                                                          */
/*----------------------------------------------------------------------------------------------*/
typedef     uint8_t       PCIE_RC_TD_T1CSH_IL;

/*----------------------------------------------------------------------------------------------*/
/* Interrupt Pin (Offset 03Dh) -ROOT-                                                           */
/*----------------------------------------------------------------------------------------------*/
typedef     uint8_t       PCIE_RC_TD_T1CSH_IP;

/*----------------------------------------------------------------------------------------------*/
/* Brisge Control (Offset 03Eh) -ROOT-                                                          */
/*----------------------------------------------------------------------------------------------*/
typedef     uint16_t      PCIE_RC_TD_T1CSH_BC;



/*-------------------------------------- --------------------------------------------------------*/
/* Cap ID / Next Item (Offset 040h) -Root-                                                      */
/* Power Management Capabilities (Offset 042h) -Root-                                           */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       CID     : 8;    /* [07:00]  */
        uint32_t       NI      : 8;    /* [15:08]  */

        uint32_t       VER     : 3;    /* [02:00]  */
        uint32_t               : 1;    /* [03] */
        uint32_t               : 1;    /* [04] */
        uint32_t       DSI     : 1;    /* [05] */
        uint32_t       AC      : 3;    /* [08:06]  */
        uint32_t       D1S     : 1;    /* [09] */
        uint32_t       D2S     : 1;    /* [10] */
        uint32_t       PMES    : 5;    /* [15:11]  */
    }   bit;
}   PCIE_RC_UN_PMCR_PMC;

/*----------------------------------------------------------------------------------------------*/
/* Power Management Control / Status (Offset 044h) -Root-                                       */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       PS      : 2;    /* [01:00]  */
        uint32_t               : 1;    /* [02] */
        uint32_t       NSR     : 1;    /* [03] */
        uint32_t               : 4;    /* [07:04]  */
        uint32_t       PMEEN   : 1;    /* [08] */
        uint32_t       DSEL    : 4;    /* [12:09]  */
        uint32_t       DS      : 2;    /* [14:13]  */
        uint32_t       PMES    : 1;    /* [15] */
        uint32_t               : 6;    /* [21:16]  */
        uint32_t               : 1;    /* [22] */
        uint32_t               : 1;    /* [23] */
        uint32_t       DATA    : 8;    /* [31:24]  */
    }   bit;
}   PCIE_RC_UN_PMCR_PMCS;


/*----------------------------------------------------------------------------------------------*/
/* Cap ID / Next Item (Offset 050h) -EP/RC-                                                     */
/* Message Control (Offset 052h) -EP/RC-                                                        */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       CID     : 8;
        uint32_t       NI      : 8;

        uint32_t       MSIE    : 1;
        uint32_t       MMC     : 3;
        uint32_t       MME     : 3;
        uint32_t       AC64    : 1;
        uint32_t       PVMC    : 1;
        uint32_t               : 7;
    }   bit;
}   PCIE_EPRC_UN_MSICR_MC;

typedef     enum        {
    PCIE_EPRC_EN_MSICR_MC_TYPE_1    = 0,
    PCIE_EPRC_EN_MSICR_MC_TYPE_2    = 1,
    PCIE_EPRC_EN_MSICR_MC_TYPE_4    = 2,
    PCIE_EPRC_EN_MSICR_MC_TYPE_8    = 3,
    PCIE_EPRC_EN_MSICR_MC_TYPE_16   = 4,
    PCIE_EPRC_EN_MSICR_MC_TYPE_32   = 5
}   PCIE_EPRC_EN_MSICR_MC_TYPE;

/*----------------------------------------------------------------------------------------------*/
/* Message Address (Offset 054h) -EP/RC-                                                        */
/*----------------------------------------------------------------------------------------------*/
typedef     uint32_t       PCIE_EPRC_TD_MSICR_MA;

/*----------------------------------------------------------------------------------------------*/
/* Message Upper Address (Offset 058h) -EP/RC-                                                  */
/*----------------------------------------------------------------------------------------------*/
typedef     uint32_t       PCIE_EPRC_TD_MSICR_MUA;

/*----------------------------------------------------------------------------------------------*/
/* Message Data (Offset 05Ch) -EP/RC-                                                           */
/*----------------------------------------------------------------------------------------------*/
typedef     uint32_t       PCIE_EPRC_TD_MSICR_MD;

/*----------------------------------------------------------------------------------------------*/
/* Mask Bits (Offset 060h) -EP/RC-                                                              */
/*----------------------------------------------------------------------------------------------*/
typedef     uint32_t       PCIE_EPRC_TD_MSICR_MB;

/*----------------------------------------------------------------------------------------------*/
/* Pending Bits (Offset 064h) -EP/RC-                                                           */
/*----------------------------------------------------------------------------------------------*/
typedef     uint32_t       PCIE_EPRC_TD_MSICR_PB;



/*----------------------------------------------------------------------------------------------*/
/* Cap ID / Next Item (Offset 070h) -EP/RC-                                                     */
/* Message Control (Offset 072h) -EP/RC-                                                        */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       CID     : 8;
        uint32_t       NI      : 8;

        uint32_t       TS      : 11;
        uint32_t               : 3;
        uint32_t       FM      : 1;
        uint32_t       MSIXE   : 1;
    }   bit;
}   PCIE_EPRC_UN_MSIXCR_MC;

/*----------------------------------------------------------------------------------------------*/
/* Table Offset (Offset 074h) -EP/RC-                                                           */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       TBIR    : 3;
        uint32_t       TO      : 29;
    }   bit;
}   PCIE_EPRC_UN_MSIXCR_TO;

/*----------------------------------------------------------------------------------------------*/
/* PBA Offset / PBA BIR (Offset 078h) -EP/RC-                                                   */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       PBABIR  : 3;
        uint32_t       PBAO    : 29;
    }   bit;
}   PCIE_EPRC_UN_MSIXCR_PBA;


/*----------------------------------------------------------------------------------------------*/
/* Cap ID / Next Item (Offset 080h) -EP/RC-                                                     */
/* PCI Express Capability Register (Offset 082h) -EP/RC-                                        */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       CID     : 8;
        uint32_t       NI      : 8;

        uint32_t       CV      : 4;
        uint32_t       DPT     : 4;
        uint32_t       SI      : 1;
        uint32_t       IMN     : 5;
        uint32_t               : 2;
    }   bit;
}   PCIE_EPRC_UN_PCIECR_CR;

/*----------------------------------------------------------------------------------------------*/
/* Device Capability Register (Offset 084h) -EP/RC-                                             */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       MPSS    : 3;
        uint32_t       PFS     : 2;
        uint32_t       ETFS    : 1;
        uint32_t       EL0AL   : 3;
        uint32_t       EL1AL   : 3;
        uint32_t               : 3;
        uint32_t       RBER    : 1;
        uint32_t               : 2;
        uint32_t       CSPLV   : 8;
        uint32_t       CSPLS   : 2;
        uint32_t       FLRC    : 1;
        uint32_t               : 3;
    }   bit;
}   PCIE_EPRC_UN_PCIECR_DCR;

/*----------------------------------------------------------------------------------------------*/
/* Device Control Register (Offset 088h) -EP/RC-                                                */
/* Device Status Register (Offset 08Ah) -EP/RC-                                                 */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       CERE    : 1;
        uint32_t       NFERE   : 1;
        uint32_t       FERE    : 1;
        uint32_t       URRE    : 1;
        uint32_t       ERO     : 1;
        uint32_t       MPS     : 3;
        uint32_t       ETFT    : 1;
        uint32_t       PFE     : 1;
        uint32_t       APPME   : 1;
        uint32_t       ENS     : 1;
        uint32_t       MRRS    : 3;
        uint32_t       IFLR    : 1;

        uint32_t       CED     : 1;
        uint32_t       NFED    : 1;
        uint32_t       FED     : 1;
        uint32_t       URD     : 1;
        uint32_t       AUXPD   : 1;
        uint32_t       TP      : 1;
        uint32_t               : 10;
    }   bit;
}   PCIE_EPRC_UN_PCIECR_DCSR;

/*----------------------------------------------------------------------------------------------*/
/* Link Capability Register (Offset 08Ch) -EP/RC-                                               */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       SLS     : 4;
        uint32_t       MLW     : 6;
        uint32_t       ASPMS   : 2;
        uint32_t       L0EL    : 3;
        uint32_t       L1EL    : 3;
        uint32_t       CPM     : 1;
        uint32_t       SDERC   : 1;
        uint32_t       DLLLARC : 1;
        uint32_t       LBNC    : 1;
        uint32_t               : 2;
        uint32_t       PN      : 8;
    }   bit;
}   PCIE_EPRC_UN_PCIECR_LCR;

/*----------------------------------------------------------------------------------------------*/
/* Link Control Register (Offset 090h) -EP/RC-                                                  */
/* Link Status Register (Offset 092h) -EP/RC-                                                   */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       ASPMC   : 2;        /* [01:00]  */
        uint32_t               : 1;        /* [02] */
        uint32_t       RCB     : 1;        /* [03] */
        uint32_t       LD      : 1;        /* [04] */
        uint32_t       RL      : 1;        /* [05] */
        uint32_t       CCC     : 1;        /* [06] */
        uint32_t       ES      : 1;        /* [07] */
        uint32_t       ECPM    : 1;        /* [08] */
        uint32_t       HAWD    : 1;        /* [09] */
        uint32_t       LBMIE   : 1;        /* [10] */
        uint32_t       LABIE   : 1;        /* [11] */
        uint32_t               : 4;        /* [15:12]  */

        uint32_t       CLS     : 4;        /* [03:00]  */
        uint32_t       NLW     : 6;        /* [09:00]  */
        uint32_t               : 1;        /* [10] */
        uint32_t       LT      : 1;        /* [11] */
        uint32_t       SCC     : 1;        /* [12] */
        uint32_t       DLLLA   : 1;        /* [13] */
        uint32_t       LBMS    : 1;        /* [14] */
        uint32_t       LABS    : 1;        /* [15] */
    }   bit;
}   PCIE_EPRC_UN_PCIECR_LCSR;

/*----------------------------------------------------------------------------------------------*/
/* Slot Capabilities Register (Offset 094h) -Root-                                              */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       ABP     : 1;    /* [00] */
        uint32_t       PCP     : 1;    /* [01] */
        uint32_t       MRLSP   : 1;    /* [02] */
        uint32_t       AIP     : 1;    /* [03] */
        uint32_t       PIP     : 1;    /* [04] */
        uint32_t       HPS     : 1;    /* [05] */
        uint32_t       HPC     : 1;    /* [06] */
        uint32_t       SPLV    : 8;    /* [14:07]  */
        uint32_t       SPLS    : 2;    /* [16:15]  */
        uint32_t       EIP     : 1;    /* [17] */
        uint32_t       NCCS    : 1;    /* [18] */
        uint32_t       PSN     : 13;   /* [31:19]  */
    }   bit;
}   PCIE_RC_UN_PCIECR_SCR;

/*----------------------------------------------------------------------------------------------*/
/* Slot Control Register (Offset 098h) -Root-                                                   */
/* Slot Status Register (Offset 09Ah) -Root-                                                    */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       ABPE    : 1;    /* [00] */
        uint32_t       PFDE    : 1;    /* [01] */
        uint32_t       MRLSCE  : 1;    /* [02] */
        uint32_t       PDCE    : 1;    /* [03] */
        uint32_t       CCIE    : 1;    /* [04] */
        uint32_t       HPIE    : 1;    /* [05] */
        uint32_t       AIC     : 2;    /* [07:06]  */
        uint32_t       PIC     : 2;    /* [09:08]  */
        uint32_t       PCC     : 1;    /* [10] */
        uint32_t       EIC     : 1;    /* [11] */
        uint32_t       DLLSCE  : 1;    /* [12] */
        uint32_t               : 3;    /* [15:13]  */

        uint32_t       ABP     : 1;    /* [00] */
        uint32_t       PFD     : 1;    /* [01] */
        uint32_t       MRLSC   : 1;    /* [02] */
        uint32_t       PDC     : 1;    /* [03] */
        uint32_t       CC      : 1;    /* [04] */
        uint32_t       MRLSS   : 1;    /* [05] */
        uint32_t       PDS     : 1;    /* [06] */
        uint32_t       EIS     : 1;    /* [07] */
        uint32_t       DLLSC   : 1;    /* [08] */
        uint32_t               : 7;    /* [15:09]  */
    }   bit;
}   PCIE_RC_UN_PCIECR_SCSR;

/*----------------------------------------------------------------------------------------------*/
/* Root Control Register (Offset 09Ch) -Root-                                                   */
/* Root Capability Register (Offset 09Eh) -Root-                                                */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       SECEE   : 1;    /* [00] */
        uint32_t       SENFEE  : 1;    /* [01] */
        uint32_t       SCFEE   : 1;    /* [02] */
        uint32_t       PMEIE   : 1;    /* [03] */
        uint32_t       CRSSWVE : 1;    /* [04] */
        uint32_t               : 11;   /* [15:05]  */

        uint32_t       CESSV   : 1;    /* [00] */
        uint32_t               : 15;   /* [15:01]  */
    }   bit;
}   PCIE_RC_UN_PCIECR_RCCR;

/*----------------------------------------------------------------------------------------------*/
/* Link Control2 Register (Offset 0B0h,0B2h) -EP/RC-                                            */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       TLS     : 4;        /* [03:00]  */
        uint32_t       EC      : 1;        /* [04] */
        uint32_t       HASD    : 1;        /* [05] */
        uint32_t       SDE     : 1;        /* [06] */
        uint32_t       TM      : 3;        /* [09:07]  */
        uint32_t       EMC     : 1;        /* [10] */
        uint32_t       CSOS    : 1;        /* [11] */
        uint32_t       CDE     : 1;        /* [12] */
        uint32_t               : 3;        /* [15:13]  */

        uint32_t       CDEL    : 1;        /* [00] */
        uint32_t               : 15;       /* [15:01]  */
    }   bit;
}   PCIE_EPRC_UN_PCIECR_LC2R;

typedef     enum        {
    PCIE_EPRC_UN_PCIECR_LC2R_TLS_2_5GT  = 1,
    PCIE_EPRC_UN_PCIECR_LC2R_TLS_5_0GT  = 2
}   PCIE_EPRC_UN_PCIECR_LC2R_TLS;


/*----------------------------------------------------------------------------------------------*/
/* Advanced Error Reporting Enhanced Capability Header (Offset 100h) -RC-                                            */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t        PCIEID : 16;       /* [15:00]  */
        uint32_t        CV     : 4;        /* [19:16]  */
        uint32_t        NCO    : 12;       /* [31:20]  */
    }   bit;
}   PCIE_RC_UN_AERC_AERECH;

/*----------------------------------------------------------------------------------------------*/
/* Uncorrectable Error Status Register (Offset 104h) -RC-                                            */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t               : 32;       /* [31:00]  */
    }   bit;
}   PCIE_RC_UN_AERC_UESTR;

/*----------------------------------------------------------------------------------------------*/
/* Uncorrectable Error Mask Register (Offset 108h) -RC-                                            */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t               : 32;       /* [31:00]  */
    }   bit;
}   PCIE_RC_UN_AERC_UEMR;

/*----------------------------------------------------------------------------------------------*/
/* Uncorrectable Error Severity Register (Offset 10Ch) -RC-                                            */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t               : 32;       /* [31:00]  */
    }   bit;
}   PCIE_RC_UN_AERC_UESVR;

/*----------------------------------------------------------------------------------------------*/
/* Correctable Error Status Register (Offset 110h) -RC-                                            */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t               : 32;       /* [31:00]  */
    }   bit;
}   PCIE_RC_UN_AERC_CESR;

/*----------------------------------------------------------------------------------------------*/
/* Correctable Error Mask Register (Offset 114h) -RC-                                            */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t               : 32;       /* [31:00]  */
    }   bit;
}   PCIE_RC_UN_AERC_CEMR;

/*----------------------------------------------------------------------------------------------*/
/* Root Error Command Register (Offset 12Ch) -RC-                                            */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       CERE    : 1;        /* [00]  */
        uint32_t       NFER    : 1;        /* [01] */
        uint32_t       FERE    : 1;        /* [02] */
        uint32_t               : 29;       /* [31:03]  */
    }   bit;
}   PCIE_RC_UN_AERC_RECR;

/*----------------------------------------------------------------------------------------------*/
/* Root Error Status Register (Offset 130h) -RC-                                            */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t               : 32;       /* [31:00]  */
    }   bit;
}   PCIE_RC_UN_AERC_RESR;


/*----------------------------------------------------------------------------------------------*/
/* Vender-Specific Enhanced Capability Header (Offset 400h) -RC/EP-                             */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       PCIEECID    : 16;
        uint32_t       CV      : 4;
        uint32_t       NCO     : 12;
    }   bit;
}   PCIE_EPRC_UN_ARB_VSECH;

/*----------------------------------------------------------------------------------------------*/
/* Vender-Specific Header (Offset 404h) -RC/EP-                                                 */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       VSECID  : 16;
        uint32_t       VSECR   : 4;
        uint32_t       VSECL   : 12;
    }   bit;
}   PCIE_EPRC_UN_ARB_VSH;

/*----------------------------------------------------------------------------------------------*/
/* Power Control/Status (Offset 408h) -RC-                                                  */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       PERST   : 1;
        uint32_t       PTOR    : 1;
        uint32_t       D3TOE   : 1;
        uint32_t       REFCLK  : 1;
        uint32_t               : 12;
        uint32_t       RPTOACK : 1;
        uint32_t               : 15;
    }   bit;
}   PCIE_EPRC_UN_ARB_PCS;

#define     PCIE_EPRC_UN_ARB_PCS_DATA   (0x80020340)

/*----------------------------------------------------------------------------------------------*/
/* Destination Configuration ID (Offset 600h) -ROOT-                                            */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       TFN     : 3;
        uint32_t       TDN     : 5;
        uint32_t       TBN     : 8;
        uint32_t               : 16;
    }   bit;
}   PCIE_RC_UN_CIOMTCR_DCID;

/*----------------------------------------------------------------------------------------------*/
/* Destination Configuration Register Number (Offset 604h) -ROOT-                               */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t               : 2;
        uint32_t       TRN     : 6;
        uint32_t       TERN    : 4;
        uint32_t               : 4;
        uint32_t               : 16;
    }   bit;
}   PCIE_RC_UN_CIOMTCR_DCRN;

/*----------------------------------------------------------------------------------------------*/
/* Destination I/O Address (Offset 608h) -ROOT-                                                 */
/*----------------------------------------------------------------------------------------------*/
typedef     uint32_t       PCIE_RC_TD_CIOMTCR_DIOA;

/*----------------------------------------------------------------------------------------------*/
/* Config/IO Transfer Byte Enable (Offset 60Ch) -ROOT-                                          */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       BE      : 4;
        uint32_t               : 12;
        uint32_t               : 16;
    }   bit;
}   PCIE_RC_UN_CIOMTCR_CIOTBE;

/*----------------------------------------------------------------------------------------------*/
/* Config/IO Transfer Write Data (Offset 610h) -ROOT-                                           */
/*----------------------------------------------------------------------------------------------*/
typedef     uint32_t       PCIE_RC_TD_CIOMTCR_CIOTWD;

/*----------------------------------------------------------------------------------------------*/
/* Config/IO Transfer Read Data (Offset 614h) -ROOT-                                            */
/*----------------------------------------------------------------------------------------------*/
typedef     uint32_t       PCIE_RC_TD_CIOMTCR_CIOTRD;

/*----------------------------------------------------------------------------------------------*/
/* Config/IO Transfer Status (Offset 618h) -ROOT-                                               */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       CS      : 3;
        uint32_t       PTLPD   : 1;
        uint32_t       RV      : 1;
        uint32_t       TB      : 1;
        uint32_t               : 2;
        uint32_t               : 8;
        uint32_t               : 16;
    }   bit;
}   PCIE_RC_UN_CIOMTCR_CIOTS;

/*----------------------------------------------------------------------------------------------*/
/* Config/IO Transfer Log (Offset 61Ch) -ROOT-                                                  */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       LIT0W   : 1;
        uint32_t       LIT0R   : 1;
        uint32_t       LIT1W   : 1;
        uint32_t       LIT1R   : 1;
        uint32_t       LIIOW   : 1;
        uint32_t       LIIOR   : 1;
        uint32_t               : 2;
        uint32_t               : 8;
        uint32_t               : 16;
    }   bit;
}   PCIE_RC_UN_CIOMTCR_CIOTL;

/*----------------------------------------------------------------------------------------------*/
/* Config Type0 Write Instruction (Offset 640h) -ROOT-                                          */
/*----------------------------------------------------------------------------------------------*/
typedef     uint32_t       PCIE_RC_TD_CIOMTCR_CT0WI;

/*----------------------------------------------------------------------------------------------*/
/* Config Type0 Read Instruction (Offset 644h) -ROOT-                                           */
/*----------------------------------------------------------------------------------------------*/
typedef     uint32_t       PCIE_RC_TD_CIOMTCR_CT0RI;

/*----------------------------------------------------------------------------------------------*/
/* Config Type1 Write Instruction (Offset 648h) -ROOT-                                          */
/*----------------------------------------------------------------------------------------------*/
typedef     uint32_t       PCIE_RC_TD_CIOMTCR_CT1WI;

/*----------------------------------------------------------------------------------------------*/
/* Config Type1 Read Instruction (Offset 64Ch) -ROOT-                                           */
/*----------------------------------------------------------------------------------------------*/
typedef     uint32_t       PCIE_RC_TD_CIOMTCR_CT1RI;

/*----------------------------------------------------------------------------------------------*/
/* I/O Write Instruction (Offset 650h) -ROOT-                                                   */
/*----------------------------------------------------------------------------------------------*/
typedef     uint32_t       PCIE_RC_TD_CIOMTCR_IOWI;

/*----------------------------------------------------------------------------------------------*/
/* I/O Read Instruction (Offset 654h) -ROOT-                                                    */
/*----------------------------------------------------------------------------------------------*/
typedef     uint32_t       PCIE_RC_TD_CIOMTCR_IORI;

/*----------------------------------------------------------------------------------------------*/
/* Config IO Transfer Interrupt Clear Instruction (Offset 658h) -ROOT-                          */
/*----------------------------------------------------------------------------------------------*/
typedef     uint32_t       PCIE_RC_TD_CIOMTCR_CIOTICI;

/*----------------------------------------------------------------------------------------------*/
/* Destination Memory Lower Address (Offset 680h) -EP/RC-                                       */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       DMLA    : 32;
    }   bit;
}   PCIE_EPRC_UN_MMTCR_DMLA;

/*----------------------------------------------------------------------------------------------*/
/* Destination Memory Upper Address (Offset 684h) -EP/RC-                                       */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       DMUA    : 32;
    }   bit;
}   PCIE_EPRC_UN_MMTCR_DMUA;

/*----------------------------------------------------------------------------------------------*/
/* Memory TLP Header Register (Offset 688h) -EP/RC-                                             */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       BE  : 4;
        uint32_t           : 4;
        uint32_t       TCN : 4;
        uint32_t       FN  : 4;
        uint32_t           : 16;
    }   bit;
}   PCIE_EPRC_UN_MMTCR_MTHR;

/*----------------------------------------------------------------------------------------------*/
/* Memory TLP Transfer Write Data (Offset 68Ch) -EP/RC-                                         */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       WD  : 32;
    }   bit;
}   PCIE_EPRC_UN_MMTCR_MTTWD;

/*----------------------------------------------------------------------------------------------*/
/* Memory TLP Transfer Read Data (Offset 690h) -EP/RC-                                          */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       RD  : 32;
    }   bit;
}   PCIE_EPRC_UN_MMTCR_MTTRD;

/*----------------------------------------------------------------------------------------------*/
/* Memory TLP Transfer Instruction (Offset 694h) -EP/RC-                                        */
/*----------------------------------------------------------------------------------------------*/
typedef     enum        {
    PCIE_EPRC_EN_MMTCR_MTTI_READ    = (0 << 0),
    PCIE_EPRC_EN_MMTCR_MTTI_WRITE   = (1 << 0)
}   PCIE_EPRC_EN_MMTCR_MTTI;

typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       TI  : 1;
        uint32_t           : 31;
    }   bit;
}   PCIE_EPRC_UN_MMTCR_MTTI;

/*----------------------------------------------------------------------------------------------*/
/* Memory TLP Transfer Interrupt Status  (Offset 698h) -EP/RC-                                  */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       MWNE    : 1;
        uint32_t       MWEE    : 1;
        uint32_t       MRNE    : 1;
        uint32_t       MREE    : 1;
        uint32_t       IA      : 1;
        uint32_t               : 27;
    }   bit;
}   PCIE_EPRC_UN_MMTCR_MTTIS;

/*----------------------------------------------------------------------------------------------*/
/* Memory TLP Transfer Interrupt Mask  (Offset 69Ch) -EP/RC-                                    */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       MWNEIM  : 1;
        uint32_t       MWEEIM  : 1;
        uint32_t       MRNEIM  : 1;
        uint32_t       MREEIM  : 1;
        uint32_t       IAIM    : 1;
        uint32_t               : 27;
    }   bit;
}   PCIE_EPRC_UN_MMTCR_MTTIM;

/*----------------------------------------------------------------------------------------------*/
/* Memory TLP Transfer Status  (Offset 6A0h) -EP/RC-                                            */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       CS      : 3;
        uint32_t       RDP     : 1;
        uint32_t       RDV     : 1;
        uint32_t       RTB     : 1;
        uint32_t       WTB     : 1;
        uint32_t       IA      : 1;
        uint32_t               : 24;
    }   bit;
}   PCIE_EPRC_UN_MMTCR_MTTS;


/*----------------------------------------------------------------------------------------------*/
/* MSI Tranfer Instruction  (Offset 7A0h) -EP-                                                  */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       MSIFN   : 3;
        uint32_t       MSIN    : 5;
        uint32_t               : 8;
        uint32_t               : 16;
    }   bit;
}   PCIE_EP_UN_MSITCR_MSITI;

/*----------------------------------------------------------------------------------------------*/
/* MSI Tranfer Interrupt Status  (Offset 7A4h) -EP-                                             */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       FN0     : 1;
        uint32_t       FN1     : 1;
        uint32_t       FN2     : 1;
        uint32_t       FN3     : 1;
        uint32_t       FN4     : 1;
        uint32_t       FN5     : 1;
        uint32_t       FN6     : 1;
        uint32_t       FN7     : 1;
        uint32_t               : 8;
        uint32_t               : 16;
    }   bit;
}   PCIE_EP_UN_MSITCR_MSITIS;

/*----------------------------------------------------------------------------------------------*/
/* MSI Tranfer Interrupt Mask  (Offset 7A8h) -EP-                                               */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       FN0     : 1;
        uint32_t       FN1     : 1;
        uint32_t       FN2     : 1;
        uint32_t       FN3     : 1;
        uint32_t       FN4     : 1;
        uint32_t       FN5     : 1;
        uint32_t       FN6     : 1;
        uint32_t       FN7     : 1;
        uint32_t               : 8;
        uint32_t               : 16;
    }   bit;
}   PCIE_EP_UN_MSITCR_MSITIM;

/*----------------------------------------------------------------------------------------------*/
/* MSI Tranfer Status (Offset 7ACh) -EP-                                                        */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       MSITB0  : 1;
        uint32_t       MSITB1  : 1;
        uint32_t       MSITB2  : 1;
        uint32_t       MSITB3  : 1;
        uint32_t       MSITB4  : 1;
        uint32_t       MSITB5  : 1;
        uint32_t       MSITB6  : 1;
        uint32_t       MSITB7  : 1;
        uint32_t       MSIM0   : 1;
        uint32_t       MSIM1   : 1;
        uint32_t       MSIM2   : 1;
        uint32_t       MSIM3   : 1;
        uint32_t       MSIM4   : 1;
        uint32_t       MSIM5   : 1;
        uint32_t       MSIM6   : 1;
        uint32_t       MSIM7   : 1;
        uint32_t               : 16;
    }   bit;
}   PCIE_EP_UN_MSITCR_MSITS;

/*----------------------------------------------------------------------------------------------*/
/* MSI Pending Status/Clear for Function 0 (Offset 7B0h) -EP-                                   */
/* MSI Pending Status/Clear for Function 1 (Offset 7B4h) -EP-                                   */
/* MSI Pending Status/Clear for Function 2 (Offset 7B8h) -EP-                                   */
/* MSI Pending Status/Clear for Function 3 (Offset 7BCh) -EP-                                   */
/* MSI Pending Status/Clear for Function 4 (Offset 7C0h) -EP-                                   */
/* MSI Pending Status/Clear for Function 5 (Offset 7C4h) -EP-                                   */
/* MSI Pending Status/Clear for Function 6 (Offset 7C8h) -EP-                                   */
/* MSI Pending Status/Clear for Function 7 (Offset 7CCh) -EP-                                   */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       MSIP0   : 1;
        uint32_t       MSIP1   : 1;
        uint32_t       MSIP2   : 1;
        uint32_t       MSIP3   : 1;
        uint32_t       MSIP4   : 1;
        uint32_t       MSIP5   : 1;
        uint32_t       MSIP6   : 1;
        uint32_t       MSIP7   : 1;
        uint32_t       MSIP8   : 1;
        uint32_t       MSIP9   : 1;
        uint32_t       MSIP10  : 1;
        uint32_t       MSIP11  : 1;
        uint32_t       MSIP12  : 1;
        uint32_t       MSIP13  : 1;
        uint32_t       MSIP14  : 1;
        uint32_t       MSIP15  : 1;
        uint32_t       MSIP16  : 1;
        uint32_t       MSIP17  : 1;
        uint32_t       MSIP18  : 1;
        uint32_t       MSIP19  : 1;
        uint32_t       MSIP20  : 1;
        uint32_t       MSIP21  : 1;
        uint32_t       MSIP22  : 1;
        uint32_t       MSIP23  : 1;
        uint32_t       MSIP24  : 1;
        uint32_t       MSIP25  : 1;
        uint32_t       MSIP26  : 1;
        uint32_t       MSIP27  : 1;
        uint32_t       MSIP28  : 1;
        uint32_t       MSIP29  : 1;
        uint32_t       MSIP30  : 1;
        uint32_t       MSIP31  : 1;
    }   bit;
}   PCIE_EP_UN_MSITCR_MSIPSC;

/*----------------------------------------------------------------------------------------------*/
/* Function Number Select for BAR Resource Setting (Offset 800h) -EP/RC-                        */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       BARFN   : 3;
        uint32_t               : 29;
    }   bit;
}   PCIE_EPRC_UN_FNSBAR_FNSBAR;

/*----------------------------------------------------------------------------------------------*/
/* Base Address 0 Resource Setting (Offset 804h) -EP/RC-                                        */
/*----------------------------------------------------------------------------------------------*/
typedef     uint32_t       PCIE_EPRC_TD_FNSBAR_BA0;

/*----------------------------------------------------------------------------------------------*/
/* Base Address 1 Resource Setting (Offset 808h) -EP/RC-                                        */
/*----------------------------------------------------------------------------------------------*/
typedef     uint32_t       PCIE_EPRC_TD_FNSBAR_BA1;

/*----------------------------------------------------------------------------------------------*/
/* Base Address 2 Resource Setting (Offset 80Ch) -EP/RC-                                        */
/*----------------------------------------------------------------------------------------------*/
typedef     uint32_t       PCIE_EPRC_TD_FNSBAR_BA2;

/*----------------------------------------------------------------------------------------------*/
/* Base Address 3 Resource Setting (Offset 810h) -EP/RC-                                        */
/*----------------------------------------------------------------------------------------------*/
typedef     uint32_t       PCIE_EPRC_TD_FNSBAR_BA3;

/*----------------------------------------------------------------------------------------------*/
/* Base Address 4 Resource Setting (Offset 814h) -EP/RC-                                        */
/*----------------------------------------------------------------------------------------------*/
typedef     uint32_t       PCIE_EPRC_TD_FNSBAR_BA4;

/*----------------------------------------------------------------------------------------------*/
/* Base Address 5 Resource Setting (Offset 818h) -EP/RC-                                        */
/*----------------------------------------------------------------------------------------------*/
typedef     uint32_t       PCIE_EPRC_TD_FNSBAR_BA5;

/*----------------------------------------------------------------------------------------------*/
/* Expansion ROM Resource Setting (Offset 81Ch) -EP/RC-                                         */
/*----------------------------------------------------------------------------------------------*/
typedef     uint32_t       PCIE_EPRC_TD_FNSBAR_EROM;

/*----------------------------------------------------------------------------------------------*/
/* BAR Enable Register (Offset 820h) -EP/RC-                                                    */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       BARE    : 6;
        uint32_t       EROME   : 1;
        uint32_t               : 1;
        uint32_t               : 24;
    }   bit;
}   PCIE_EPRC_UN_FNSBAR_BARE;

/*----------------------------------------------------------------------------------------------*/
/* Advisory Severity Register (Offset 824h) -EP/RC-                                             */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       CTA     : 1;
        uint32_t       PTLPA   : 1;
        uint32_t               : 30;
    }   bit;
}   PCIE_EPRC_UN_FNSBAR_AS;

/*----------------------------------------------------------------------------------------------*/
/* Requester ID Register (Offset 830h) -EP/RC-                                                  */
/*----------------------------------------------------------------------------------------------*/
typedef     uint32_t       PCIE_EPRC_TD_FNSBAR_RID;

/*----------------------------------------------------------------------------------------------*/
/* Other Settings Register (Offset 834h) -EP/RC-                                                */
/*----------------------------------------------------------------------------------------------*/
typedef     uint32_t       PCIE_EPRC_TD_FNSBAR_OS;

/*----------------------------------------------------------------------------------------------*/
/* Transfer Speed Change Request Register (Offset 840h) -EP/RC-                                 */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       RCS     : 4;
        uint32_t               : 28;
    }   bit;
}   PCIE_EPRC_UN_TSSR_TSCRR;

typedef     enum        {
    PCIE_EPRC_EN_TSSR_TSCRR_RCS_2_5GT   = 1,
    PCIE_EPRC_EN_TSSR_TSCRR_RCS_5_0GT   = 2
}   PCIE_EPRC_EN_TSSR_TSCRR_RCS;

/*----------------------------------------------------------------------------------------------*/
/* Transfer Speed Status Register (Offset 844h) -EP/RC-                                         */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       SCS     : 3;        /* [02:00]  */
        uint32_t       SCR     : 1;        /* [03] */
        uint32_t       SCM     : 1;        /* [04] */
        uint32_t       HWASD   : 1;        /* [05] */
        uint32_t       DLA     : 1;        /* [06] */
        uint32_t               : 1;        /* [07] */
        uint32_t       LTSSMMS : 4;        /* [11:08]  */
        uint32_t       RS      : 4;        /* [15:12]  */
        uint32_t       CS      : 4;        /* [19:16]  */
        uint32_t       PCS     : 4;        /* [23:20]  */
        uint32_t       ADSLS   : 4;        /* [27:24]  */
        uint32_t               : 4;        /* [31:28]  */
    }   bit;
}   PCIE_EPRC_UN_TSSR_TSSR;

typedef     enum        {
    PCIE_EPRC_EN_TSSR_TSSR_SCS_BUSY		= 1,
    PCIE_EPRC_EN_TSSR_TSSR_SCS_FAIL		= 2,
    PCIE_EPRC_EN_TSSR_TSSR_SCS_COMPLETED	= 4,
}   PCIE_EPRC_EN_TSSR_TSSR_SCS;

/*----------------------------------------------------------------------------------------------*/
/* Power Management Status Register (Offset 850h) -EP/RC-                                       */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       PMTOFFREQ   : 1;
        uint32_t                   : 1;
        uint32_t       PMAUXEN     : 1;
        uint32_t       PMPKTREMAIN : 1;
        uint32_t                   : 28;
    }   bit;
}   PCIE_EPRC_UN_TSSR_PMSR;

/*----------------------------------------------------------------------------------------------*/
/* Power Management Control Register (Offset 854h) -EP/RC-                                      */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       PMTOFFACK   : 1;
        uint32_t       PMPMEREQ    : 1;
        uint32_t                   : 30;
    }   bit;
}   PCIE_EPRC_UN_TSSR_PMCR;

/*----------------------------------------------------------------------------------------------*/
/* AXI Bridge Mode Register (Offset 880h) -EP/RC-                                               */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       AXIESM  : 1;
        uint32_t               : 1;
        uint32_t       PD      : 1;
        uint32_t       DLWM    : 1;
        uint32_t               : 4;
        uint32_t       PCITE0  : 1;
        uint32_t       PCITE1  : 1;
        uint32_t       PCITE2  : 1;
        uint32_t       PCITE3  : 1;
        uint32_t       PCITE4  : 1;
        uint32_t       PCITE5  : 1;
        uint32_t       PCITE6  : 1;
        uint32_t       PCITE7  : 1;
        uint32_t               : 16;
    }   bit;
}   PCIE_EPRC_UN_AXIBCSR_AXIBMR;

/*----------------------------------------------------------------------------------------------*/
/* AXI Slave Transfer Enable Register (Offset 884h) -EP/RC-                                               */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       TRSIFEN : 1;
        uint32_t               : 7;
        uint32_t       ICSIFEN : 1;
        uint32_t               : 23;
    }   bit;
}   PCIE_EPRC_UN_AXIBCSR_AXISTER;

/*----------------------------------------------------------------------------------------------*/
/* Completer Control Register (Offset 888h) -EP/RC-                                             */
/*----------------------------------------------------------------------------------------------*/
typedef     uint32_t       PCIE_EPRC_TD_AXIBCSR_CCR;

/*----------------------------------------------------------------------------------------------*/
/* Function Number Select for BAR Remap Setting (Offset 8A0h) -EP/RC-                           */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       RFN     : 3;
        uint32_t               : 29;
    }   bit;
}   PCIE_EPRC_UN_AXIBCSR_FNSBARRS;

/*----------------------------------------------------------------------------------------------*/
/* AXI Remap Address (BAR0) Register (Offset 8A4h) -EP/RC-                                      */
/* AXI Remap Address (BAR1) Register (Offset 8A8h) -EP/RC-                                      */
/* AXI Remap Address (BAR2) Register (Offset 8ACh) -EP/RC-                                      */
/* AXI Remap Address (BAR3) Register (Offset 8B0h) -EP/RC-                                      */
/* AXI Remap Address (BAR4) Register (Offset 8B4h) -EP/RC-                                      */
/* AXI Remap Address (BAR5) Register (Offset 8B8h) -EP/RC-                                      */
/*----------------------------------------------------------------------------------------------*/
typedef     uint32_t       PCIE_EPRC_TD_AXIBCSR_AXIRABAR;

/*----------------------------------------------------------------------------------------------*/
/* AXI Remap Address (Expansion ROM) Register (Offset 8BCh) -EP/RC-                             */
/*----------------------------------------------------------------------------------------------*/
typedef     uint32_t       PCIE_EPRC_TD_AXIBCSR_AXIRAEROM;

/*----------------------------------------------------------------------------------------------*/
/* AXI Remap Address (VGA Memory Space) Register (Offset 8C0h) -EP/RC-                          */
/*----------------------------------------------------------------------------------------------*/
typedef     uint32_t       PCIE_EPRC_TD_AXIBCSR_AXIRAVGAMS;

/*----------------------------------------------------------------------------------------------*/
/* AXI Remap Address (VGA I/O Space) Register (Offset 8C4h) -EP/RC-                             */
/*----------------------------------------------------------------------------------------------*/
typedef     uint32_t       PCIE_EPRC_TD_AXIBCSR_AXIRAVGAIOS;

/*----------------------------------------------------------------------------------------------*/
/* AXI Error Interrupt Status Register (Offset 900h) -ROOT-                                     */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       MCTFBP  : 8;
        uint32_t       IOCTFBP : 1;
        uint32_t               : 23;
    }   bit;
}   PCIE_EPRC_UN_AXIBCSR_AXIEISR;

/*----------------------------------------------------------------------------------------------*/
/* AXI Error Interrupt Mask Register (Offset 904h) -ROOT-                                       */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       MCTFBP  : 8;
        uint32_t       IOCTFBP : 1;
        uint32_t               : 23;
    }   bit;
}   PCIE_EPRC_UN_AXIBCSR_AXIEIMR;

/*----------------------------------------------------------------------------------------------*/
/* AXI Error Interrupt Status2 Register (Offset 908h) -ROOT-                                    */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       AXIRESFCA   : 8;
        uint32_t       AXIRESFRA   : 8;
        uint32_t       AXIBES      : 8;
        uint32_t                   : 8;
    }   bit;
}   PCIE_EPRC_UN_AXIBCSR_AXIEIS2R;

/*----------------------------------------------------------------------------------------------*/
/* AXI Error Interrupt Mask2 Register (Offset 90Ch) -ROOT-                                      */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       AXIRESIMFCA : 8;
        uint32_t       AXIRESIMFRA : 8;
        uint32_t       AXIBESIM    : 8;
        uint32_t                   : 8;
    }   bit;
}   PCIE_EPRC_UN_AXIBCSR_AXIEIM2R;

/*----------------------------------------------------------------------------------------------*/
/* DMAC Instruction (Offset C00h) -EP/RC-                                                       */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       IC      : 4;
        uint32_t       DMATI   : 2;
        uint32_t               : 26;
    }   bit;
}   PCIE_EPRC_UN_DMACSCR_DMACI;

typedef     enum        {
    PCIE_EPRC_EN_DMACSCR_DMACI_DMATI_STOP   = 0,
    PCIE_EPRC_EN_DMACSCR_DMACI_DMATI_START  = 1,
    PCIE_EPRC_EN_DMACSCR_DMACI_DMATI_INTCLR = 2
}   PCIE_EPRC_EN_DMACSCR_DMACI_DMATI;

/*----------------------------------------------------------------------------------------------*/
/* DMAC Mode Control (Offset C04h) -EP/RC-                                                      */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       CH0     : 1;
        uint32_t       CH1     : 1;
        uint32_t       CH2     : 1;
        uint32_t       CH3     : 1;
        uint32_t       CH4     : 1;
        uint32_t       CH5     : 1;
        uint32_t       CH6     : 1;
        uint32_t       CH7     : 1;
        uint32_t       CH8     : 1;
        uint32_t       CH9     : 1;
        uint32_t       CHA     : 1;
        uint32_t       CHB     : 1;
        uint32_t       CHC     : 1;
        uint32_t       CHD     : 1;
        uint32_t       CHE     : 1;
        uint32_t       CHF     : 1;
        uint32_t               : 16;
    }   bit;
}   PCIE_EPRC_UN_DMACSCR_DMACMC;

/*----------------------------------------------------------------------------------------------*/
/* DMAC Summary Status (Offset C08h) -EP/RC-                                                    */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       CH0     : 2;
        uint32_t       CH1     : 2;
        uint32_t       CH2     : 2;
        uint32_t       CH3     : 2;
        uint32_t       CH4     : 2;
        uint32_t       CH5     : 2;
        uint32_t       CH6     : 2;
        uint32_t       CH7     : 2;
        uint32_t       CH8     : 2;
        uint32_t       CH9     : 2;
        uint32_t       CHA     : 2;
        uint32_t       CHB     : 2;
        uint32_t       CHC     : 2;
        uint32_t       CHD     : 2;
        uint32_t       CHE     : 2;
        uint32_t       CHF     : 2;
    }   bit;
}   PCIE_EPRC_UN_DMACSCR_DMACSS;

/*----------------------------------------------------------------------------------------------*/
/* DMAC Interrupt Mask (Offset C0Ch) -EP/RC-                                                    */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       TC          : 1;
        uint32_t       AXI_ED      : 1;
        uint32_t       PCIE_CTD    : 1;
        uint32_t       PCIE_URD    : 1;
        uint32_t       PCIE_CAD    : 1;
        uint32_t       PCIE_PTLPD  : 1;
        uint32_t       PCIE_RD     : 1;
        uint32_t       TABUO       : 1;
        uint32_t                   : 24;
    }   bit;
}   PCIE_EPRC_UN_DMACSCR_DMACIM;

/*----------------------------------------------------------------------------------------------*/
/* DMAC Equip Information 0 (Offset C10h) -EP/RC-                                               */
/*----------------------------------------------------------------------------------------------*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       CH0     : 4;
        uint32_t       CH1     : 4;
        uint32_t       CH2     : 4;
        uint32_t       CH3     : 4;
        uint32_t       CH4     : 4;
        uint32_t       CH5     : 4;
        uint32_t       CH6     : 4;
        uint32_t       CH7     : 4;
    }   bit;
}   PCIE_EPRC_UN_DMACSCR_DMACEI0;

/**
 * @brief DMAC Equip Information 1 (Offset C14h) -EP/RC-
*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       CH8     : 4;
        uint32_t       CH9     : 4;
        uint32_t       CHA     : 4;
        uint32_t       CHB     : 4;
        uint32_t       CHC     : 4;
        uint32_t       CHD     : 4;
        uint32_t       CHE     : 4;
        uint32_t       CHF     : 4;
    }   bit;
}   PCIE_EPRC_UN_DMACSCR_DMACEI1;

/**
 * @brief Demand DMA Transfer PCIe Lower Address (Offset E00h) -EP/RC-
*/
typedef     uint32_t       PCIE_EPRC_TD_DDMATR_DDTPLA;

/**
 * @brief Demand DMA Transfer PCIe Upper Address (Offset E04h) -EP/RC-
*/
typedef     uint32_t       PCIE_EPRC_TD_DDMATR_DDTPUA;

/**
 * @brief Demand DMA Transfer AXI Address (Offset E08h) -EP/RC-
*/
typedef     uint32_t       PCIE_EPRC_TD_DDMATR_DDTAA;

/**
 * @brief Demand DMA Transfer AXI Size (Offset E0Ch) -EP/RC-
*/
typedef     uint32_t       PCIE_EPRC_TD_DDMATR_DDTAS;

/**
 * @brief Demand DMA Transfer Setting Register (Offset E10h) -EP/RC-
*/
typedef     union       {
    uint32_t       DATA;
    struct      {
        uint32_t       DMATSP  : 13;
        uint32_t       FN      : 3;
        uint32_t       TC      : 3;
        uint32_t       DIR     : 1;
        uint32_t       MRR     : 2;
        uint32_t               : 10;
    }   bit;
}   PCIE_EPRC_UN_DDMATR_DDTSE;

typedef     enum        {
    PCIE_EPRC_EN_DDMATR_DDTSE_DIR_PCIe2AXI  = (0),
    PCIE_EPRC_EN_DDMATR_DDTSE_DIR_AXI2PCIe  = (1)
}   PCIE_EPRC_EN_DDMATR_DDTSE_DIR;

/**
 * @brief Demand DMA Transfer Table Address (Offset E14h) -EP/RC-
*/
typedef     uint32_t       PCIE_EPRC_TD_DDMATR_DDTTA;

/**
 * @brief Demand DMA Transfer Status Register 1 (Offset E18h) -EP/RC-
*/
typedef     union       {
    uint32_t       DATA;                /**< DATA */
    struct      {
        uint32_t       TC      : 1;     /**< B00  */
        uint32_t       AXI_ED  : 1;     /**< B01  */
        uint32_t       PCIE_ED : 3;     /**< B04-B02  */
        uint32_t       PTLPD   : 1;     /**< B05  */
        uint32_t               : 1;     /**< B06  */
        uint32_t       TABUO   : 1;     /**< B07  */
        uint32_t       DS_DES  : 1;     /**< B08  */
        uint32_t       DS_DEM  : 1;     /**< B09  */
        uint32_t               : 22;    /**< reserved */
    }   bit;
}   PCIE_EPRC_UN_DDMATR_DDTST1;

/**
 * @brief Demand DMA Transfer Status Register 2 (Offset E1Ch) -EP/RC-
*/
typedef     uint32_t       PCIE_EPRC_TD_DDMATR_DDTST2;

/**
 * @brief Type0 Configuration Space Header(@0x000-0x03F)
*/
typedef     struct      {
    PCIE_EP_TD_T0CSH_VID        VID;        /**< +000H    */
    PCIE_EP_TD_T0CSH_DID        DID;        /**< +002H    */
    PCIE_EP_UN_T0CSH_CRSR       CRSR;       /**< +004H,+006H  */
    PCIE_EP_TD_T0CSH_RID        RID;        /**< +008H    */
    PCIE_EP_TD_T0CSH_CC         CC;         /**< +009H    */
    uint8_t                  __res1[2];     /**< reserved */
    PCIE_EP_TD_T0CSH_CLS        CLS;        /**< +00CH    */
    PCIE_EP_TD_T0CSH_LT         LT;         /**< +00DH    */
    PCIE_EP_TD_T0CSH_HT         HT;         /**< +00EH    */
    PCIE_EP_TD_T0CSH_BIST       BIST;       /**< +00FH    */
    PCIE_EP_UN_T0CSH_BAR        BAR[6];     /**< +010H-024H   */
    PCIE_EP_UN_T0CSH_CBCISP     CBCISP;     /**< +028H    */
    PCIE_EP_TD_T0CSH_SVID       SVID;       /**< +02CH    */
    PCIE_EP_TD_T0CSH_SID        SID;        /**< +02EH    */
    PCIE_EP_UN_T0CSH_EROMBAR    EROMBAR;    /**< +030H    */
    PCIE_EP_TD_T0CSH_CP         CP;         /**< +034H    */
    uint8_t                  __res2[4];     /**< reserved */
    PCIE_EP_UN_T0CSH_ILIPMGML   ILIPMGML;   /**< +03CH    */
}   PCIE_EP_T0CSH;

/**
 * @brief Type1 Configuration Space Header(@0x000-0x03F)
*/
typedef     struct      {
    PCIE_RC_TD_T1CSH_VID        VID;        /**< +000H    */
    PCIE_RC_TD_T1CSH_DID        DID;        /**< +002H    */
    PCIE_RC_UN_T1CSH_CRSR       CRSR;       /**< +004H,+006H  */
    PCIE_RC_TD_T1CSH_RID        RID;        /**< +008H    */
    PCIE_RC_TD_T1CSH_CC         CC;         /**< +009H    */
    uint8_t                  __res1[2];     /**< reserved */
    PCIE_RC_TD_T1CSH_CLS        CLS;        /**< +00CH    */
    PCIE_RC_TD_T1CSH_LT         LT;         /**< +00DH    */
    PCIE_RC_TD_T1CSH_HT         HT;         /**< +00EH    */
    PCIE_RC_TD_T1CSH_BIST       BIST;       /**< +00FH    */
    PCIE_RC_UN_T1CSH_BAR        BAR0;       /**< +010H    */
    PCIE_RC_UN_T1CSH_BAR        BAR1;       /**< +014H    */
    PCIE_RC_TD_T1CSH_PBN        PBN;        /**< +018H    */
    PCIE_RC_TD_T1CSH_SBN        SBN;        /**< +019H    */
    PCIE_RC_TD_T1CSH_SUBN       SUBN;       /**< +01AH    */
    PCIE_RC_TD_T1CSH_SLT        SLT;        /**< +01BH    */
    PCIE_RC_TD_T1CSH_IOB        IOB;        /**< +01CH    */
    PCIE_RC_TD_T1CSH_IOL        IOL;        /**< +01DH    */
    PCIE_RC_TD_T1CSH_SS         SS;         /**< +01EH    */
    PCIE_RC_TD_T1CSH_MB         MB;         /**< +020H    */
    PCIE_RC_TD_T1CSH_ML         ML;         /**< +022H    */
    PCIE_RC_TD_T1CSH_PMB        PMB;        /**< +024H    */
    PCIE_RC_TD_T1CSH_PML        PML;        /**< +026H    */
    PCIE_RC_TD_T1CSH_PBU32      PBU32;      /**< +028H    */
    PCIE_RC_TD_T1CSH_PLU32      PLU32;      /**< +02CH    */
    PCIE_RC_TD_T1CSH_IOBU16     IOBU16;     /**< +030H    */
    PCIE_RC_TD_T1CSH_IOLU16     IOLU16;     /**< +032H    */
    PCIE_RC_TD_T1CSH_CP         CP;         /**< +034H    */
    PCIE_RC_UN_T1CSH_EROMBAR    EROMBAR;    /**< +038H    */
    PCIE_RC_TD_T1CSH_IL         IL;         /**< +03CH    */
    PCIE_RC_TD_T1CSH_IP         IP;         /**< +03DH    */
    PCIE_RC_TD_T1CSH_BC         BC;         /**< +03EH    */
}   PCIE_RC_T1CSH;

/**
 * @brief PCI Power Management Capability (@0x040-0x04F)
*/
typedef     struct      {
    PCIE_RC_UN_PMCR_PMC         PMC;        /**< +040H    */
    PCIE_RC_UN_PMCR_PMCS        PMCS;       /**< +044H    */
    uint32_t                    __res1[2];  /**< +048,04Freserved */
}   PCIE_RC_PCIEPMCS;

/**
 * @brief MSI Capability Register(@0x050-0x06F)
*/
typedef     struct      {
    PCIE_EPRC_UN_MSICR_MC       MC;         /**< +050H,+052H  */
    PCIE_EPRC_TD_MSICR_MA       MA;         /**< +054H    */
    PCIE_EPRC_TD_MSICR_MUA      MUA;        /**< +058H    */
    PCIE_EPRC_TD_MSICR_MD       MD;         /**< +05CH    */
    PCIE_EPRC_TD_MSICR_MB       MB;         /**< +060H    */
    PCIE_EPRC_TD_MSICR_PB       PB;         /**< +064H    */
    uint32_t                    __res1[2];  /**< +068,06Freserved */
}   PCIE_RCEP_MSICR;

/**
 * @brief MSIX Capability Register(@0x070-0x07F)
*/
typedef     struct      {
    PCIE_EPRC_UN_MSIXCR_MC      MC;         /**< +070H,+072H  */
    PCIE_EPRC_UN_MSIXCR_TO      TO;         /**< +074H    */
    PCIE_EPRC_UN_MSIXCR_PBA     PBA;        /**< +078H    */
    uint32_t                    __res1[1];  /**< +07C,07Freserved */
}   PCIE_RCEP_MSIXCR;

/**
 * @brief PCI Express Capability Register(@0x080-0x0FF)
*/
typedef     struct      {
    PCIE_EPRC_UN_PCIECR_CR      CR;         /**< +080H    */
    PCIE_EPRC_UN_PCIECR_DCR     DCR;        /**< +084H    */
    PCIE_EPRC_UN_PCIECR_DCSR    DCSR;       /**< +088H    */
    PCIE_EPRC_UN_PCIECR_LCR     LCR;        /**< +08CH    */
    PCIE_EPRC_UN_PCIECR_LCSR    LCSR;       /**< +090H    */
    PCIE_RC_UN_PCIECR_SCR       SCR;        /**< +094H    */
    PCIE_RC_UN_PCIECR_SCSR      SCSR;       /**< +098H    */
    PCIE_RC_UN_PCIECR_RCCR      RCCR;       /**< +09CH    */
    uint32_t                    RSR;        /**< +0A0H    */
    uint32_t                    DCAP2R;     /**< +0A4H    */
    uint16_t                    DC2R;       /**< +0A8H    */
    uint16_t                    DS2R;       /**< +0AAH    */
    uint32_t                    LCAP2R;     /**< +0ACH    */
    PCIE_EPRC_UN_PCIECR_LC2R    LC2R;       /**< +0B0H    */
    uint32_t                    __res2[((0x100-0xB4)/4)]; /**< +0B4,0FFreserved */
}   PCIE_RCEP_PCIECR;
/* static assertion */
extern char __ASSERTION_FAIL__size_of_PCIE_RCEP_PCIECR_is_not_128[(sizeof(PCIE_RCEP_PCIECR) == 128) ? 0:-1];

/* Device Control2: Completion Timeout */
#define PCIECR_DC2R_TMO_DEFAULT	0x0 /* 20ms - 30ms */
#define PCIECR_DC2R_TMO_50US	0x1 /* 60us - 90us */
#define PCIECR_DC2R_TMO_1MS	0x2 /* 4ms - 6ms */
#define PCIECR_DC2R_TMO_16MS	0x5 /* 30ms - 45ms */
#define PCIECR_DC2R_TMO_65MS	0x6 /* 100ms - 150ms */
#define PCIECR_DC2R_TMO_260MS	0x9 /* 500ms - 750ms */
#define PCIECR_DC2R_TMO_1SEC	0xA /* 2sec - 3sec */
#define PCIECR_DC2R_TMO_4SEC	0xD /* 8sec - 12sec */
#define PCIECR_DC2R_TMO_17SEC	0xE /* 30sec - 45sec */
#define PCIECR_DC2R_NO_TMO	0x10

/**
 * @brief Advanced Error Reporting Capability(@0x100-0x0FF)
*/
#define PCIE_RC_AER_OFFSET	0x100
typedef     struct      {
    PCIE_RC_UN_AERC_AERECH      AERECH;     /**< +100H */
    PCIE_RC_UN_AERC_UESTR       UESTR;      /**< +104H */
    PCIE_RC_UN_AERC_UEMR        UEMR;       /**< +108H */
    PCIE_RC_UN_AERC_UESVR       UESVR;      /**< +10CH */
    PCIE_RC_UN_AERC_CESR        CESR;       /**< +110H */
    PCIE_RC_UN_AERC_CEMR        CEMR;       /**< +114H */
    uint32_t                    __res1[5];  /**< +118,12Breserved */
    PCIE_RC_UN_AERC_RECR        RECR;       /**< +12CH    */
    PCIE_RC_UN_AERC_RESR        RESR;       /**< +130H    */
    uint32_t                    __res2[((0x200-0x134)/4)]; /**< +134,1FFreserved */
}   PCIE_RCEP_AERC;

#define PCIE_RC_AER_SRC_COR(x)	((x) & 0xffff)
#define PCIE_RC_AER_SRC_UNC(x)	((x) >> 16)

/**
 * @brief Application Register Block(@0x400-0x43F)
*/
typedef     struct      {
    PCIE_EPRC_UN_ARB_VSECH      VSECH;      /**< +400H    */
    PCIE_EPRC_UN_ARB_VSH        VSH;        /**< +404H    */
    PCIE_EPRC_UN_ARB_PCS        PCS;        /**< +408H    */
    uint32_t                    __res1[((0x440-0x40C)/4)]; /**< +40C,43Freserved */
}   PCIE_RCEP_ARB;

/**
 * @brief Config I/O Master Transfer Control Register(@0x600-0x67F)
*/
typedef     struct      {
    PCIE_RC_UN_CIOMTCR_DCID     DCID;       /**< +600H    */
    PCIE_RC_UN_CIOMTCR_DCRN     DCRN;       /**< +604H    */
    PCIE_RC_TD_CIOMTCR_DIOA     DIOA;       /**< +608H    */
    PCIE_RC_UN_CIOMTCR_CIOTBE   CIOTBE;     /**< +60CH    */
    PCIE_RC_TD_CIOMTCR_CIOTWD   CIOTWD;     /**< +610H    */
    PCIE_RC_TD_CIOMTCR_CIOTRD   CIOTRD;     /**< +614H    */
    PCIE_RC_UN_CIOMTCR_CIOTS    CIOTS;      /**< +618H    */
    PCIE_RC_UN_CIOMTCR_CIOTL    CIOTL;      /**< +61CH    */
    uint32_t                    __res1[8];  /**< +620,63Freserved */
    PCIE_RC_TD_CIOMTCR_CT0WI    CT0WI;      /**< +640H    */
    PCIE_RC_TD_CIOMTCR_CT0RI    CT0RI;      /**< +644H    */
    PCIE_RC_TD_CIOMTCR_CT1WI    CT1WI;      /**< +648H    */
    PCIE_RC_TD_CIOMTCR_CT1RI    CT1RI;      /**< +64CH    */
    PCIE_RC_TD_CIOMTCR_IOWI     IOWI;       /**< +650H    */
    PCIE_RC_TD_CIOMTCR_IORI     IORI;       /**< +654H    */
    PCIE_RC_TD_CIOMTCR_CIOTICI  CIOTICI;    /**< +658H    */
    uint32_t                    __res2[9];  /**< +65C,67Freserved */
}   PCIE_RC_CIOMTCR;

/**
 * @brief Memory Master Transfer Control Register(@0x680-0x6FF)
*/
typedef     struct      {
    PCIE_EPRC_UN_MMTCR_DMLA     DMLA;       /**< +680H    */
    PCIE_EPRC_UN_MMTCR_DMUA     DMUA;       /**< +684H    */
    PCIE_EPRC_UN_MMTCR_MTHR     MTHR;       /**< +688H    */
    PCIE_EPRC_UN_MMTCR_MTTWD    MTTWD;      /**< +68CH    */
    PCIE_EPRC_UN_MMTCR_MTTRD    MTTRD;      /**< +690H    */
    PCIE_EPRC_UN_MMTCR_MTTI     MTTI;       /**< +694H    */
    PCIE_EPRC_UN_MMTCR_MTTIS    MTTIS;      /**< +698H    */
    PCIE_EPRC_UN_MMTCR_MTTIM    MTTIM;      /**< +69CH    */
    PCIE_EPRC_UN_MMTCR_MTTS     MTTS;       /**< +6A0H    */
    uint32_t                    __res1[((0x700-0x6A4)/4)]; /**< +6A4,6FFreserved */
}   PCIE_RCEP_MMTCR;

/**
 * @brief MSI Transfer Control Register(@0x7A0-0x7FF)
*/
typedef     struct      {
    PCIE_EP_UN_MSITCR_MSITI     MSITI;      /**< +7A0H    */
    PCIE_EP_UN_MSITCR_MSITIS    MSITIS;     /**< +7A4H    */
    PCIE_EP_UN_MSITCR_MSITIM    MSITIM;     /**< +7A8H    */
    PCIE_EP_UN_MSITCR_MSITS     MSITS;      /**< +7ACH    */
    PCIE_EP_UN_MSITCR_MSIPSC    MSIPSC[8];  /**< +7B0H-7CFH  */
    uint32_t                    __res1[((0x800-0x7D0)/4)]; /**< +7D0,7FFreserved */
}   PCIE_EP_MSITCR;

/**
 * @brief PCIe Provision Register(@0x800-0x83F)
*/
typedef     struct      {
    PCIE_EPRC_UN_FNSBAR_FNSBAR  FNSBAR;     /**< +800H    */
    PCIE_EPRC_TD_FNSBAR_BA0     BA0;        /**< +804H    */
    PCIE_EPRC_TD_FNSBAR_BA1     BA1;        /**< +808H    */
    PCIE_EPRC_TD_FNSBAR_BA2     BA2;        /**< +80CH    */
    PCIE_EPRC_TD_FNSBAR_BA3     BA3;        /**< +810H    */
    PCIE_EPRC_TD_FNSBAR_BA4     BA4;        /**< +814H    */
    PCIE_EPRC_TD_FNSBAR_BA5     BA5;        /**< +818H    */
    PCIE_EPRC_TD_FNSBAR_EROM    EROM;       /**< +81CH    */
    PCIE_EPRC_UN_FNSBAR_BARE    BARE;       /**< +820H    */
    PCIE_EPRC_UN_FNSBAR_AS      AS;         /**< +824H    */
    uint32_t                    __res1[2];  /**< +828,82Freserved */
    PCIE_EPRC_TD_FNSBAR_RID     RID;        /**< +830H    */
    PCIE_EPRC_TD_FNSBAR_OS      OS;         /**< +834H    */
    uint32_t                    __res2[2];  /**< +838,83Freserved */
}   PCIE_RCEP_PCIEPR;

/**
 * @brief PCIe Transfer Setting/Status Register(@0x840-0x87F)
*/
typedef     struct      {
    PCIE_EPRC_UN_TSSR_TSCRR     TSCRR;      /**< +840H    */
    PCIE_EPRC_UN_TSSR_TSSR      TSSR;       /**< +844H    */
    uint32_t                    __res1[2];  /**< +848,84Freserved */
    PCIE_EPRC_UN_TSSR_PMSR      PMSR;       /**< +850H    */
    PCIE_EPRC_UN_TSSR_PMCR      PMCR;       /**< +854H    */
    uint32_t                    __res2[((0x880-0x858)/4)]; /**< +858,87Freserved */
}   PCIE_RCEP_TSSR;

/**
 * @brief AXI Bridge Mode Register(@0x880-0x9FF)
*/
typedef     struct      {
    PCIE_EPRC_UN_AXIBCSR_AXIBMR         AXIBMR;         /**< +880H    */
    PCIE_EPRC_UN_AXIBCSR_AXISTER        AXISTER;        /**< +884H    */
    PCIE_EPRC_TD_AXIBCSR_CCR            CCR;            /**< +888H    */
    uint32_t                            __res1[5];      /**< +888,89Freserved */
    PCIE_EPRC_UN_AXIBCSR_FNSBARRS       FNSBARRS;       /**< +8A0H    */
    PCIE_EPRC_TD_AXIBCSR_AXIRABAR       AXIRABAR[6];    /**< +8A4H-8B8H   */
    PCIE_EPRC_TD_AXIBCSR_AXIRAEROM      AXIRAEROM;      /**< +8BCH    */
    PCIE_EPRC_TD_AXIBCSR_AXIRAVGAMS     AXIRAVGAMS;     /**< +8C0H    */
    PCIE_EPRC_TD_AXIBCSR_AXIRAVGAIOS    AXIRAVGAIOS;    /**< +8C4H    */
    uint32_t                            __res2[((0x900-0x8C8)/4)];     /**< +8C8,8FFreserved */
    PCIE_EPRC_UN_AXIBCSR_AXIEISR        AXIEISR;        /**< +900H    */
    PCIE_EPRC_UN_AXIBCSR_AXIEIMR        AXIEIMR;        /**< +904H    */
    PCIE_EPRC_UN_AXIBCSR_AXIEIS2R       AXIEIS2R;       /**< +908H    */
    PCIE_EPRC_UN_AXIBCSR_AXIEIM2R       AXIEIM2R;       /**< +90CH    */
    uint32_t                            __res3[((0xA00-0x910)/4)];     /**< +910,9FFreserved */
}   PCIE_RCEP_AXIBCSR;

/**
 * @brief DMA Control/Status Common Register(@0xC00-0xC1F)
*/
typedef     struct      {
    PCIE_EPRC_UN_DMACSCR_DMACI      DMACI;              /**< +C00H    */
    PCIE_EPRC_UN_DMACSCR_DMACMC     DMACMC;             /**< +C04H    */
    PCIE_EPRC_UN_DMACSCR_DMACSS     DMACSS;             /**< +C08H    */
    PCIE_EPRC_UN_DMACSCR_DMACIM     DMACIM;             /**< +C0CH    */
    PCIE_EPRC_UN_DMACSCR_DMACEI0    DMACEI0;            /**< +C10H    */
    PCIE_EPRC_UN_DMACSCR_DMACEI1    DMACEI1;            /**< +C14H    */
    uint32_t                        __res1[2];          /**< +C18,C1Freserved */
}   PCIE_RCEP_DMACSCR;

/**
 * @brief Demand DMA Transfer Register(@0xE00-0xE1F)
*/
typedef     struct      {
    PCIE_EPRC_TD_DDMATR_DDTPLA  DDTPLA;                 /**< +E00H    */
    PCIE_EPRC_TD_DDMATR_DDTPUA  DDTPUA;                 /**< +E04H    */
    PCIE_EPRC_TD_DDMATR_DDTAA   DDTAA;                  /**< +E08H    */
    PCIE_EPRC_TD_DDMATR_DDTAS   DDTAS;                  /**< +E0CH    */
    PCIE_EPRC_UN_DDMATR_DDTSE   DDTSE;                  /**< +E10H    */
    PCIE_EPRC_TD_DDMATR_DDTTA   DDTTA;                  /**< +E14H    */
    PCIE_EPRC_UN_DDMATR_DDTST1  DDTST1;                 /**< +E18H    */
    PCIE_EPRC_TD_DDMATR_DDTST2  DDTST2;                 /**< +E1CH    */
}   PCIE_RCEP_DDMATR;

/* ==================================================================== */
#define __I     volatile const                              /**< read only */
#define __O     volatile                                    /**< write only */
#define __IO    volatile                                    /**< read / write */

/* ==================================================================== */

#pragma pack(push,4)
/**
 * @brief EP (@0x0-0xFFF)
*/
typedef     struct      {
    __IO     PCIE_EP_T0CSH          T0CSH;      /**< +000H-03FH  */
    uint32_t                        __res1[4];  /**< +040,04Freserved */
    __IO     PCIE_RCEP_MSICR        MSICR;      /**< +050H-06FH  */
    __IO     PCIE_RCEP_MSIXCR       MSIXCR;     /**< +070H-07FH  */
    __IO     PCIE_RCEP_PCIECR       PCIECR;     /**< +080H-0FFH  */
    uint32_t                        __res2[((0x400-0x100)/4)];/**< +100,3FFreserved */
    __IO     PCIE_RCEP_ARB          ARB;        /**< +400H-43FH  */
    uint32_t                        __res3[((0x680-0x440)/4)];/**< +440,67Freserved */
    __IO     PCIE_RCEP_MMTCR        MMTCR;      /**< +680H-6FFH  */
    uint32_t                        __res4[((0x7A0-0x700)/4)]; /**< +700,79Freserved */
    __IO     PCIE_EP_MSITCR         MSITCR;     /**< +7A0H-7FFH  */
    __IO     PCIE_RCEP_PCIEPR       PCIEPR;     /**< +800H-83FH  */
    __IO     PCIE_RCEP_TSSR         TSSR;       /**< +840H-87FH  */
    __IO     PCIE_RCEP_AXIBCSR      AXIBCSR;    /**< +880H-9FFH  */
    uint32_t                        __res5[((0xC00-0xA00)/4)];/**< +A00,BFFreserved */
    __IO     PCIE_RCEP_DMACSCR      DMACSCR;    /**< +C00H-C1FH  */
    uint32_t                        __res6[((0xE00-0xC20)/4)];/**< +C20,DFFreserved */
    __IO     PCIE_RCEP_DDMATR       DDMATR[16]; /**< +E00H-E1FH...+FF0H-FFFH    */
}reg_pcie_epxh_t;

/**
 * @brief RC (@0x0-0xFFF)
*/
typedef     struct      {
    __IO     PCIE_RC_T1CSH          T1CSH;      /**< +000H-03FH  */
    __IO     PCIE_RC_PCIEPMCS       PCIEPMCS;   /**< +040H-04FH  */
    __IO     PCIE_RCEP_MSICR        MSICR;      /**< +050H-06FH  */
    __IO     PCIE_RCEP_MSIXCR       MSIXCR;     /**< +070H-07FH  */
    __IO     PCIE_RCEP_PCIECR       PCIECR;     /**< +080H-0FFH  */
    __IO     PCIE_RCEP_AERC         AERC;       /**< +100H-1FFH  */
    uint32_t                        __res1[((0x400-0x200)/4)];/**< +200,3FFreserved */
    __IO     PCIE_RCEP_ARB          ARB;        /**< +400H-43FH  */
    uint32_t                        __res2[((0x600-0x440)/4)];/**< +440,5FFreserved */
    __IO     PCIE_RC_CIOMTCR        CIOMTCR;    /**< +600H-67FH  */
    __IO     PCIE_RCEP_MMTCR        MMTCR;      /**< +680H-6FFH  */
    uint32_t                        __res3[((0x800-0x700)/4)]; /**< +700,7FFreserved */
    __IO     PCIE_RCEP_PCIEPR       PCIEPR;     /**< +800H-83FH  */
    __IO     PCIE_RCEP_TSSR         TSSR;       /**< +840H-87FH  */
    __IO     PCIE_RCEP_AXIBCSR      AXIBCSR;    /**< +880H-9FFH  */
    uint32_t                        __res4[((0xC00-0xA00)/4)];/**< +A00,BFFreserved */
    __IO     PCIE_RCEP_DMACSCR      DMACSCR;    /**< +C00H-C1FH  */
    uint32_t                        __res5[((0xE00-0xC20)/4)];/**< +C20,DFFreserved */
    __IO     PCIE_RCEP_DDMATR       DDMATR[16]; /**< +E00H-E1FH...+FF0H-FFFH    */
}reg_pcie_rcxh_t;

#pragma pack(pop)

/**
 * @brief AXI Slave Transfer Register
 */
#define PCIE_AXISTR_AXISIOIS 0x1000 /**< AXI Slave IO/Config Interrupt Status */
#define PCIE_AXISTR_AXISIOIM 0x1004 /**< AXI Slave IO/Config Interrupt Mask */
#define PCIE_AXISTR_AXISIOS  0x1008 /**< AXI Slave IO/Config Status */
#define PCIE_AXISTR_AXISIOC  0x100C /**< AXI Slave IO/Config Control */
#define PCIE_AXISTR_AXISCBA  0x1100 /**< AXI Slave Config Base Address */
#define PCIE_AXISTR_AXISCRS  0x1104 /**< AXI Slave Config Remap Size */
#define PCIE_AXISTR_AXISCTID 0x1110 /**< AXI Slave Config Target ID(Area0) */

#define PCIE_AXISTR_AXISIBA  0x1200 /**< AXI Slave I/O Base Address(Area0) */
#define PCIE_AXISTR_AXISIRS  0x1204 /**< AXI Slave I/O Remap Size(Aread0) */
#define PCIE_AXISTR_AXISIRA  0x1208 /**< AXI Slave I/O Remap Address(Aread0) */

#define PCIE_AXISTR_AXISMIS  0x1800 /**< AXI Slave Memory Interrupt Status */
#define PCIE_AXISTR_AXISMIM  0x1804 /**< AXI Slave Memory Interrupt Mask */
#define PCIE_AXISTR_AXISMS   0x1808 /**< AXI Slave Memory Status */
#define PCIE_AXISTR_AXISMC   0x180C /**< AXI Slave Memory Control */

#define PCIE_AXISTR_AXISMBA  0x1820 /**< AXI Slave Memory Base Address(Area0) */
#define PCIE_AXISTR_AXISMRS  0x1824 /**< AXI Slave Memory Remap Size(Aread0) */
#define PCIE_AXISTR_AXISMRA  0x1828 /**< AXI Slave Memory Remap Address(Aread0) */


#ifdef __cplusplus
}
#endif
#endif      /* __REG_PCIE_H__ */
/*---------------------------------------------------------------------------
  END
---------------------------------------------------------------------------*/
