#ifndef _LINUX_COREDUMP_H
#define _LINUX_COREDUMP_H

#include <linux/types.h>
#include <linux/mm.h>
#include <linux/fs.h>

/*
 * These are the only things you should do on a core-file: use only these
 * functions to write out all the necessary info.
 */
extern int dump_write(struct file *file, const void *addr, int nr);
extern int dump_seek(struct file *file, loff_t off);

struct corewriter {
	const char *name;
	int (*write)(struct file *file, const void *addr, int nr);
	int (*seek)(struct file *file, loff_t off);
};

#define COREWRITER_RAW 0
extern struct corewriter core_raw;
extern struct corewriter core_lz77;

#endif /* _LINUX_COREDUMP_H */
