/* 2024-05-13: File changed by Sony Group Corporation */
/* rwsem-spinlock.h: fallback C implementation
 *
 * Copyright (c) 2001   David Howells (dhowells@redhat.com).
 * - Derived partially from ideas by Andrea Arcangeli <andrea@suse.de>
 * - Derived also from comments by Linus
 */

#ifndef _LINUX_RWSEM_SPINLOCK_H
#define _LINUX_RWSEM_SPINLOCK_H

#ifndef _LINUX_RWSEM_H
#error "please don't include linux/rwsem-spinlock.h directly, use linux/rwsem.h instead"
#endif

#ifdef __KERNEL__
/*
 * the rw-semaphore definition
 * - if activity is 0 then there are no active readers or writers
 * - if activity is +ve then that is the number of active readers
 * - if activity is -1 then there is one active writer
 * - if wait_list is not empty, then there are processes waiting for the semaphore
 */
struct rw_anon_semaphore {
	__s32			activity;
	raw_spinlock_t		wait_lock;
	struct list_head	wait_list;
#ifdef CONFIG_DEBUG_LOCK_ALLOC
	struct lockdep_map dep_map;
#endif
};

#if !defined(CONFIG_PREEMPT_RT_FULL) && !defined(CONFIG_EJ_COMPAT_RW_SEMAPHORE)
/*
 * Non preempt-rt implementation of rw_semaphore. Same as above, but
 * restricted vs. ownership. i.e. ownerless locked state and non owner
 * release not allowed.
 */
struct rw_semaphore {
	__s32			activity;
	raw_spinlock_t		wait_lock;
	struct list_head	wait_list;
#ifdef CONFIG_DEBUG_LOCK_ALLOC
	struct lockdep_map dep_map;
#endif
};
#endif /* PREEMPT_RT_FULL and EJ_COMPAT_RW_SEMAPHORE */

#define RWSEM_UNLOCKED_VALUE		0x00000000

extern void __down_read(struct rw_anon_semaphore *sem);
extern int __down_read_trylock(struct rw_anon_semaphore *sem);
extern void __down_write(struct rw_anon_semaphore *sem);
extern void __down_write_nested(struct rw_anon_semaphore *sem, int subclass);
extern int __down_write_trylock(struct rw_anon_semaphore *sem);
extern void __up_read(struct rw_anon_semaphore *sem);
extern void __up_write(struct rw_anon_semaphore *sem);
extern void __downgrade_write(struct rw_anon_semaphore *sem);
extern int anon_rwsem_is_locked(struct rw_anon_semaphore *sem);

#endif /* __KERNEL__ */
#endif /* _LINUX_RWSEM_SPINLOCK_H */
