#include <linux/highmem.h>
#include <linux/socket.h>

static inline void *kmap_skb_frag(const skb_frag_t *frag)
{
#ifdef CONFIG_EJ_CURL_EXTENTION
	if ( frag->flags & MSG_PHY_ADDR ) {
		return phys_to_virt(page_to_phys(frag->page));
	}
#endif
#ifdef CONFIG_HIGHMEM
	BUG_ON(in_irq());

	local_bh_disable();
#endif
	return kmap_atomic(frag->page, KM_SKB_DATA_SOFTIRQ);
}

static inline void kunmap_skb_frag(void *vaddr)
{
	kunmap_atomic(vaddr, KM_SKB_DATA_SOFTIRQ);
#ifdef CONFIG_HIGHMEM
	local_bh_enable();
#endif
}

#ifdef CONFIG_EJ_CURL_EXTENTION
static inline void kunmap_skb_frag_ext(void *vaddr, const skb_frag_t *frag)
{
	if (frag && (frag->flags & MSG_PHY_ADDR)) return ;
	kunmap_skb_frag(vaddr);
}
#else
# define kunmap_skb_frag_ext(vaddr, unused) kunmap_skb_frag((vaddr))
#endif
