/*
 * Based on arch/arm/include/asm/setup.h
 *
 * Copyright (C) 1997-1999 Russell King
 * Copyright (C) 2012 ARM Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef __ASM_SETUP_H
#define __ASM_SETUP_H

#include <linux/types.h>

#ifdef __KERNEL__
#ifdef CONFIG_SNSC_4K_KERNEL_COMMAND_LINE
#define COMMAND_LINE_SIZE 4096
#else
#define COMMAND_LINE_SIZE	2048
#endif /* CONFIG_SNSC_4K_KERNEL_COMMAND_LINE */
#ifdef CONFIG_CMDLINE_PHYS_OFFSET_ENABLE
extern void setup_kemco(void);
#endif /* CONFIG_CMDLINE_PHYS_OFFSET_ENABLE */
#else
/*
 * No kernel config option should be left in kernel header files that are
 * to be released to userland. So make the userland verion's size fixed.
 */
#define COMMAND_LINE_SIZE 4096
#endif /* __KERNEL__ */

#endif
