/**
 * trace.h - DesignWare PCIe Controller Trace Support
 *
 * Copyright (C) 2014 Texas Instruments Incorporated - http://www.ti.com
 *
 * Author: Felipe Balbi <balbi@ti.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2  of
 * the License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#undef TRACE_SYSTEM
#define TRACE_SYSTEM dw_pcie

#if !defined(__DW_PCIe_TRACE_H) || defined(TRACE_HEADER_MULTI_READ)
#define __DW_PCIe_TRACE_H

#include <linux/types.h>
#include <linux/tracepoint.h>
#include <asm/byteorder.h>

#define TRACE_EP 0
#define TRACE_RC 1
#define TRACE_READ 0
#define TRACE_WRITE 1
#define TRACE_IATU(x) (x & (0x03UL << 20))
#define TRACE_DBI2(x) ((x>>20) & 0x01UL)

DECLARE_EVENT_CLASS(dwpcie_log_cfg,
	TP_PROTO(const char* dev_name, u8 own_config, u8 dirc,  u32 bdf, u32 offset, u32 value),
	TP_ARGS(dev_name,own_config, dirc, bdf, offset, value),
	TP_STRUCT__entry(
        __field(const char*, dev_name)
		__field(u8, own_config)
		__field(u8, dirc)
		__field(u32, bdf)
		__field(u32, offset)
		__field(u32, value)
	),
	TP_fast_assign(
        __entry->dev_name = dev_name;
		__entry->own_config = own_config;
		__entry->dirc = dirc;
		__entry->bdf = bdf;
		__entry->offset = offset;
		__entry->value = value;
	),
	TP_printk("(%s) %s %s (0x%04lx) cfg[0x%03lx] = 0x%08lx", __entry->dev_name, (__entry->dirc == TRACE_WRITE)?"Set":"Get",
	(__entry->own_config == TRACE_RC)?"RC":"EP", (unsigned long)__entry->bdf, (unsigned long)__entry->offset,(unsigned long)__entry->value)
);

DEFINE_EVENT(dwpcie_log_cfg, dwpcie_cfg_access,
	TP_PROTO(const char* dev_name, u8 own_config, u8 dirc,  u32 bdf, u32 offset, u32 value),
	TP_ARGS(dev_name,own_config, dirc,bdf,offset, value)
);

DECLARE_EVENT_CLASS(dwpcie_log_dbi,
    TP_PROTO(const char* dev_name, u8 dirc, u8 size, u32 addr, u32 value),
	TP_ARGS(dev_name, dirc,size, addr, value),
	TP_STRUCT__entry(
		__field(const char*, dev_name)
		__field(u8, dirc)
		__field(u8, size)
		__field(u32, addr)
		__field(u32, value)
	),
	TP_fast_assign(
		__entry->dev_name = dev_name;
		__entry->dirc = dirc;
		__entry->size = size;
		__entry->addr = addr;
		__entry->value = value;
	),
	TP_printk("(%s) %s %x bytes dbi[0x%05lx] = 0x%08lx", __entry->dev_name,(__entry->dirc == TRACE_WRITE)?"Set":"Get", __entry->size,
	(unsigned long)__entry->addr,(unsigned long)__entry->value)
);

DEFINE_EVENT(dwpcie_log_dbi, dwpcie_dbi_access,
	TP_PROTO(const char* dev_name, u8 dirc, u8 size, u32 addr, u32 value),
	TP_ARGS(dev_name, dirc,size, addr, value)
);

DECLARE_EVENT_CLASS(dwpcie_log_iatu,
	TP_PROTO(const char* dev_name, u8 dirc, int win_no, u8 is_inbound,u8 addr, u32 value),
	TP_ARGS(dev_name, dirc,win_no, is_inbound,addr, value),
	TP_STRUCT__entry(
		__field(const char*, dev_name)
		__field(u8, dirc)
		__field(int, win_no)
		__field(u8, is_inbound)
		__field(u8, addr)
		__field(u32, value)
	),
	TP_fast_assign(
		__entry->dev_name = dev_name;
		__entry->dirc = dirc;
		__entry->win_no = win_no;
		__entry->is_inbound = is_inbound;
		__entry->addr = addr;
		__entry->value = value;
	),
	TP_printk("(%s) %s iATU %s %d -- [0x%02x] = 0x%08lx",   __entry->dev_name,(__entry->dirc == TRACE_WRITE)?"Set":"Get",
	(__entry->is_inbound == 1)?"inbound":"outbound ", __entry->win_no,__entry->addr,(unsigned long)__entry->value)
);

DEFINE_EVENT(dwpcie_log_iatu, dwpcie_iatu_config,
	TP_PROTO(const char* dev_name, u8 dirc, int win_no, u8 is_inbound,u8 addr, u32 value),
	TP_ARGS(dev_name, dirc,win_no, is_inbound,addr, value)
);

DECLARE_EVENT_CLASS(dwpcie_log_phy,
    TP_PROTO(const char* dev_name, u8 dirc, u32 addr, u32 value),
	TP_ARGS(dev_name, dirc, addr, value),
	TP_STRUCT__entry(
		__field(const char*, dev_name)
		__field(u8, dirc)
		__field(u32, addr)
		__field(u32, value)
	),
	TP_fast_assign(
		__entry->dev_name = dev_name;
		__entry->dirc = dirc;
		__entry->addr = addr;
		__entry->value = value;
	),
	TP_printk("(%s) %s phy[0x%05lx] = 0x%08lx", __entry->dev_name,(__entry->dirc == TRACE_WRITE)?"Set":"Get",
	(unsigned long)__entry->addr,(unsigned long)__entry->value)
);

DEFINE_EVENT(dwpcie_log_phy, dwpcie_phy_access,
    TP_PROTO(const char* dev_name, u8 dirc, u32 addr, u32 value),
	TP_ARGS(dev_name, dirc, addr, value)
);
#endif /* __DW_PCIe_TRACE_H */

/* this part has to be here */

#undef TRACE_INCLUDE_PATH
#define TRACE_INCLUDE_PATH .

#undef TRACE_INCLUDE_FILE
#define TRACE_INCLUDE_FILE trace

#include <trace/define_trace.h>
