/*
 * drivers/udif/mach-cxd900xx/entry.S
 *
 * Copyright 2022 Sony Corporation
 *
 * This code is based on arch/arm64/kernel/hyp-stub.S
 */
/*
 * Hypervisor stub
 *
 * Copyright (C) 2012 ARM Ltd.
 * Author:	Marc Zyngier <marc.zyngier@arm.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <linux/init.h>
#include <linux/linkage.h>
#include <asm/assembler.h>
#include <asm/esr.h>
#include <mach/regs-smc.h>

	.text
	.pushsection	.entry.text, "ax"

	.align 11
ENTRY(__el3_vectors)
	ventry	el3_sp0_sync
	ventry	el3_sp0_irq
	ventry	el3_sp0_fiq
	ventry	el3_sp0_serror

	ventry	el3_spx_sync
	ventry	el3_spx_irq
	ventry	el3_spx_fiq
	ventry	el3_spx_serror

	ventry	el1_64_sync
	ventry	el1_64_irq
	ventry	el1_64_fiq
	ventry	el1_64_serror

	ventry	el1_32_sync
	ventry	el1_32_irq
	ventry	el1_32_fiq
	ventry	el1_32_serror
ENDPROC(__el3_vectors)

	.align	6
el1_64_sync:
	mrs	x9, esr_el3
	lsr	x9, x9, #ESR_ELx_EC_SHIFT
	cmp	x9, #ESR_ELx_EC_SMC64
	b.ne	9f

	/* commands */
	cmp	w0, #CXD900XX_SMC_NIC_WR32
	b.ne	1f
	/* NIC write */
	and	x1, x1, #CXD900XX_NIC_MASK
	mov_q	x9, CXD900XX_NIC_BASE
	orr	x1, x1, x9
	str	w2, [x1]
	b	9f
1:
	cmp	w0, #CXD900XX_SMC_NIC_RD32
	b.ne	1f
	/* NIC read */
	and	x1, x1, #CXD900XX_NIC_MASK
	mov_q	x9, CXD900XX_NIC_BASE
	orr	x1, x1, x9
	ldr	w0, [x1]
	b	9f
1:
	cmp	w0, #CXD900XX_SMC_NIC_WR32N
	b.ne	1f
	/* save lr */
	mov	x15, x30
	/* a0: num (max 7) */
	lsr	x0, x0, #32
	mov	x9, #7
	cmp	x0, x9
	csel	x0, x0, x9, le
	mov_q   x9, CXD900XX_NIC_BASE
	/* a1: reg[0] */
	cbz	x0, 2f
	bl	3f
	/* a2: reg[1] */
	cbz	x0, 2f
	mov	x1, x2
	bl	3f
	/* a3: reg[2] */
	cbz	x0, 2f
	mov	x1, x3
	bl	3f
	/* a4: reg[3] */
	cbz	x0, 2f
	mov	x1, x4
	bl	3f
	/* a5: reg[4] */
	cbz	x0, 2f
	mov	x1, x5
	bl	3f
	/* a6: reg[5] */
	cbz	x0, 2f
	mov	x1, x6
	bl	3f
	/* a7: reg[6] */
	cbz	x0, 2f
	mov	x1, x7
	bl	3f
2:
	/* restore lr */
	mov	x30, x15
	b	9f
3:
	/* NIC write */
	lsr	x10, x1, #32
	mov	w1, w1
	and	x1, x1, #CXD900XX_NIC_MASK
	orr	x1, x1, x9
	str	w10, [x1]
	/* num-- */
	sub	x0, x0, #1
	ret
1:
9:	eret
ENDPROC(el1_64_sync)

	.macro invalid_vector	label
\label:
	b \label
ENDPROC(\label)
	.endm

	invalid_vector	el3_sp0_sync
	invalid_vector	el3_sp0_irq
	invalid_vector	el3_sp0_fiq
	invalid_vector	el3_sp0_serror
	invalid_vector	el3_spx_sync
	invalid_vector	el3_spx_irq
	invalid_vector	el3_spx_fiq
	invalid_vector	el3_spx_serror
	invalid_vector	el1_64_irq
	invalid_vector	el1_64_fiq
	invalid_vector	el1_64_serror
	invalid_vector	el1_32_sync
	invalid_vector	el1_32_irq
	invalid_vector	el1_32_fiq
	invalid_vector	el1_32_serror
