/*
 * drivers/udif/mach-cxd900xx/include/mach/pcie_export.h
 *
 * Copyright 2019 Sony Corporation
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 */
#ifndef __MACH_CXD900XX_INCLUDE_MACH_PCIE_EXPORT_H
#define __MACH_CXD900XX_INCLUDE_MACH_PCIE_EXPORT_H

extern void pcie_root_ctrl(int ch, int enable);
extern int pcie_slot_ctrl(int id, int enable);
extern int pcie_wait_datalink(int busnr, unsigned int msec);
extern int pcie_hot_add(int busnr);
extern int pcie_hot_remove(int busnr);
extern int pcie_get_link_width(int ch);
extern int pcie_set_link_width(int ch, unsigned int target_link_width);
extern int pcie_link_width_check_dev_state_ch0(void);
typedef enum PCIE_LINK_SPEED {
	PCIE_LINK_SPEED_GEN1 = 1,
	PCIE_LINK_SPEED_GEN2 = 2,
	PCIE_LINK_SPEED_GEN3 = 3,
} PCIE_LINK_SPEED;
extern int pcie_get_link_speed(int ch);
extern int pcie_set_link_speed(int ch, PCIE_LINK_SPEED target_link_speed);
extern int pcie_link_speed_check_dev_state_ch0(void);

/* internal use only */
extern int pcie_dwc_vboost(int ch);
extern int pcie_dwc_tmo(int ch);
extern int pcie_dwc_axi_tmo(int ch);
extern int pcie_aspm_policy(int ch);
extern int pcie_aspm_ctrl_trylock(int ch);
extern int pcie_aspm_ctrl_lock(int ch);
extern int pcie_aspm_ctrl_unlock(int ch);
extern void pci_lock_irqsave(struct pci_bus *bus, unsigned long *flags);
extern void pci_unlock_irqrestore(struct pci_bus *bus, unsigned long flags);
extern void pci_lock_irq(struct pci_bus *bus);
extern void pci_unlock_irq(struct pci_bus *bus);
extern int pci_aer_disable(int ch);

extern void pcie_host_register_cb(void (*func)(int ch, int state));
extern void pcie_host_unregister_cb(void);
extern void pcie_dwc_host_notify(int ch, int state);
extern int pcie_dwc_write_config(struct pci_dev *dev, int pos, int size,
				 unsigned int val);
extern int pcie_has_prsnt(int ch);
extern int pcie_prsnt(int ch);
extern int pcie_prsnt_irq(int ch);
extern int pcie_prsnt_tmo(int ch);
extern int pcie_prsnt_high(int ch);
extern int pcie_prsnt_low1(int ch);
extern int pcie_prsnt_low2(int ch);
extern void pcie_set_perst(int ch, int assert);
extern void pcie_perst_delay(int ch);
extern int pcie_get_perst(int ch);

#endif /* __MACH_CXD900XX_INCLUDE_MACH_PCIE_EXPORT_H */
