/*
 * Copyright 2005,2006 Sony Corporation
 * Copyright 2018, 2019 Sony Imaging Products and Solutions Incorporated.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __USBG_SEN_MAIN_H__
#define __USBG_SEN_MAIN_H__

#include "usbg_sen_conf.h"

#ifdef CONFIG_OSAL_UDIF
#include <linux/udif/cdev.h>
#include <linux/udif/wait.h>
#endif

#ifdef USBG_SEN_SEMAPHORE
 #ifdef CONFIG_OSAL_UDIF
  #include <linux/udif/mutex.h>
 #else
  #error
 #endif
#else
 #ifdef USBG_SEN_SPINLOCK
  #include <linux/spinlock.h>
 #else
  #error
 #endif
#endif

#define	USBG_SEN_DIR_TX	0x80
#define	USBG_SEN_DIR_RX	0

#define	USBG_SE_FLAG_USING	0
#define	USBG_SE_FLAG_XFER_COMP	1
#define	USBG_SE_FLAG_XFER_INTR	2
#define	USBG_SE_FLAG_XFER_REQ	3

#ifdef __USBG_SEN_MAIN_PVT__

/**
  * pre defs
  */
struct usbg_se_user;

/**
  *	file operations - senser
  */
static UDIF_ERR fops_se_open(UDIF_FILE *filp);
static UDIF_ERR fops_te_open(UDIF_FILE *filp);
static UDIF_ERR fops_se_release(UDIF_FILE *filp);
static UDIF_ERR fops_te_release(UDIF_FILE *filp);
static UDIF_ERR fops_ioctl(UDIF_FILE *filp, UDIF_IOCTL *param);

static int fops_cmn_ioctl(struct inode *inode, struct file *file,
			     unsigned int cmd, unsigned long arg);
static int fops_se_ioctl(struct inode *inode, struct file *file,
			     unsigned int cmd, unsigned long arg);

static int fops_cmn_ioctl_probe(struct inode *inode,
			       struct file *file, void *p_arg);

static int fops_cmn_ioctl_remove(struct inode *inode, struct file *file,
				void *p_arg);

static int fops_se_ioctl_send(struct inode *inode, struct file *file,
			      void *p_arg);
static void comp_se_ioctl_send(struct usb_ep *ep, struct usb_request *req);

static int fops_se_ioctl_receive(struct inode *inode,
				 struct file *file, void *p_arg);
static void comp_se_ioctl_receive(struct usb_ep *ep, struct usb_request *req);

/**
 *	Gadget Core event call back
 */
static void core_start(struct usb_gadget_func_driver* p_drv,
		       unsigned char alt,
		       struct usb_gadget_ep_list list );
static void core_stop( struct usb_gadget_func_driver* p_drv );
static int core_vendor(struct usb_gadget_func_driver* p_drv,
		       const struct usb_ctrlrequest* request, struct usb_ep* ep);

/**
  *	private functions
  */

static int alloc_usbg_se_user(struct usbg_se_user* p_user);
static void cleanup_usbg_se_user(struct usbg_se_user* p_user);
static void cleanup_ep_data( struct usb_ep *ep );
#endif  // __USBG_SEN_MAIN_PVT__

struct usbg_sen_ep_data {
	struct usb_request* usb_req;
	struct usb_request comp_usb_req;
	wait_queue_head_t wait_que;
	unsigned long wait_flag;
	unsigned char dir;
	void* pvt;
};

struct usbg_se_ep_data {
	struct usbg_se_data* user_req;
};

struct usbg_te_ep_data {
	void* ldisc;
	UDIF_UINT   queue_cnt;
	UDIF_MUTEX  queue_cnt_lock;
	UDIF_WAIT   wait_dequeue;
};

struct usbg_se_user {
	struct usbg_sen_cmd* p_cmd;
};

struct usbg_te_user {
	void* reserved;
};

struct usb_ep* usbg_sen_get_ep( struct func_data* p_this, int num );

#define USBG_SEN_GET_EP(p_this,num)  usbg_sen_get_ep(p_this,num)

#ifndef FNAME
#define FNAME "usbg_sen"
#endif

#ifdef  USBG_SEN_DEBUG_ERR
#define USBG_SEN_ERR(fmt, args...) { printk("%s(%d): [E]" fmt, FNAME, __LINE__, ##args); }
#else
#define USBG_SEN_ERR(fmt, args...) { }
#endif

#ifdef  USBG_SEN_DEBUG_INF
#define USBG_SEN_INF(fmt, args...) { printk("%s(%d): [I]" fmt, FNAME, __LINE__, ##args);   }
#else
#define USBG_SEN_INF(fmt, args...) { }
#endif

#ifdef  USBG_SEN_DEBUG_API
#define USBG_SEN_API()             { printk("%s(%d): [A]%s()\n", FNAME, __LINE__, __FUNCTION__); }
#else
#define USBG_SEN_API()             { }
#endif

#ifdef USBG_SEN_DEBUG_API_DETAIL
#define USBG_SEN_API_DETAIL(fmt, args...) { printk("%s(%d):" fmt, __FUNCTION__, __LINE__, ##args);   }
#else
#define USBG_SEN_API_DETAIL(fmt, args...)        { }
#endif

#ifdef  USBG_SEN_DEBUG_FNC
#define USBG_SEN_FNC()             { printk("%s(%d): [F]%s()\n", FNAME, __LINE__, __FUNCTION__); }
#else
#define USBG_SEN_FNC()             { }
#endif


#endif  // __USBG_SEN_MAIN_H__
