/**
 *	@file	usbg_still_data.c
 *	@brief	USB SICD(Still Image Capture Device class) - ioctl
 *	
 *		Copyright 2005,2006 Sony Corporation
 * Copyright 2018 Sony Imaging Products and Solutions Incorporated.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
#ifndef __UAPI_USBG_IOCTL_STILL_H__
#define __UAPI_USBG_IOCTL_STILL_H__


#include <asm/ioctl.h>
#include <linux/ioctl.h>

#include "usb_ioctl.h"
#include "usbg_still.h"

#define USBG_IOC_ERR_NONE		0
#define USBG_IOC_ERR_SEND		0x01
#define USBG_IOC_ERR_RECV		0x02

/*
 *	@brief	IOCTL arguments
 */
struct usbg_still_status {
	unsigned short	status;
	unsigned short	error;
};

struct usbg_still_ext_buff_info {
	uint32_t	id;
	uint32_t	size;
	uint64_t	phyaddr;
};

struct usbg_still_ee_info {
  unsigned int  ee_phase;    /* EE]tO         */
  unsigned int  ee_imgsize;  /* EEf[^TCY         */
  void         *ext_addr;    /* g̃AhX              */
  unsigned int  ext_size;    /* g̃TCY                */
  void         *ee_addr;     /* addr̂܂ܐݒ */
  unsigned int  ee_size;     /* sizê܂ܐݒ */
  unsigned int  ee_jpgnum;   /* 擾JPG̐              */
  unsigned int  total_size;  /* EE, g̍vTCY      */
  unsigned int  packet_size; /* EP̃pPbgTCY       */
  unsigned int  is_last;     /* f[^̍ŏIǂ */
};

enum {
	PTPT_EE_STATE_NONE,			/* EEȂ                        */
    PTPT_EE_STATE_HEAD,         /* EEPTPwb_M             */
    PTPT_EE_STATE_EEDATA,       /* EEf[^M                */
    PTPT_EE_STATE_EEDATA_DIRECT,       /* EEf[^M                */
    PTPT_EE_STATE_EXTINFO,      /* EEg񑗐M              */
    PTPT_EE_STATE_EXTINFO_DIRECT,      /* EEg񑗐M              */
    PTPT_EE_STATE_RES,          /* X|XtF[Y              */
    PTPT_EE_STATE_TERM,         /* I                        */
    PTPT_EE_STATE_PREPARE,      /* ]                        */
    PTPT_EE_STATE_MAX			/* ȍ~R}hȂ                */
};

/*
 *	@brief	IOCTL detail
 */
#define USBG_IOC_STILL_SET_STATUS	_IOW(USB_IOC_SICD_CORE, 0, struct usbg_still_status)
#define USBG_IOC_STILL_SET_ERROR	_IOW(USB_IOC_SICD_CORE, 1, struct usbg_still_status)

#define USBG_IOC_STILL_DELIVER_BUF_INFO			_IOWR(USB_IOC_SICD_DATA, 2, struct usbg_still_ext_buff_info)
#define USBG_IOC_STILL_CLEAR_CURRENT_BUF		_IO(USB_IOC_SICD_DATA, 3)
#define USBG_IOC_STILL_EE_OPEN					_IOWR(USB_IOC_SICD_DATA, 4, struct usbg_still_ee_info) /* EEJn */
#define USBG_IOC_STILL_EE_PICTURE				_IOWR(USB_IOC_SICD_DATA, 5, struct usbg_still_ee_info) /* EE] */
#define USBG_IOC_STILL_EE_CLOSE					_IOWR(USB_IOC_SICD_DATA, 6, struct usbg_still_ee_info) /* EEI */

#define USBG_IOC_STILL_NBROF		7


#endif /// __UAPI_USBG_IOCTL_STILL_H__
