/*
 * Copyright 2005,2006,2008 Sony Corporation
 * Copyright 2018 Sony Imaging Products and Solutions Incorporated.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __UAPI_USB_NODE_INFO_H__
#define __UAPI_USB_NODE_INFO_H__

/* Minor base number for usb drivers */
#define USB_MINOR_BASE		151

/* Minor number				*/
#define USB_MINOR_EVENT		(USB_MINOR_BASE + 0)	/* Event	*/
#define USB_MINOR_GADGETCORE	(USB_MINOR_BASE + 1)	/* Gadget Core Driver*/
#define USB_MINOR_OTGCORE	(USB_MINOR_BASE + 2)	/* OTG Core Driver*/
#define USB_MINOR_MASSSTORAGE	(USB_MINOR_BASE + 3)	/* Gadget Mass Storage*/
#define USB_MINOR_SICD_CORE	(USB_MINOR_BASE + 4)	/* Gadget Still Image*/
#define USB_MINOR_SICD_DATA	(USB_MINOR_BASE + 5)	/* Gadget Still Image*/
#define USB_MINOR_SICD_EVENT	(USB_MINOR_BASE + 6)	/* Gadget Still Image*/
#define USB_MINOR_SE		(USB_MINOR_BASE + 7)	/* Gadget Senser*/
#define USB_MINOR_TE		(USB_MINOR_BASE + 8)	/* Gadget Terminal*/
#define USB_MINOR_VSPE		(USB_MINOR_BASE + 9)	/* Gadget Vendor*/
#define USB_MINOR_EXT_CMD	(USB_MINOR_BASE + 10)	/* Gadget Ext Cmd	*/
#define USB_MINOR_USBCORE	(USB_MINOR_BASE + 11)	/* USB Core(Host Core)	*/
#define USB_MINOR_SCSI		(USB_MINOR_BASE + 12)	/* SCSI	*/
#define USB_MINOR_CURRENT	(USB_MINOR_BASE + 13)	/* Current Driver	*/
#define USB_MINOR_STD		(USB_MINOR_BASE + 14)	/* test	*/

/* Node name				*/
#define USB_NODE_EVENT		"/dev/usb/event"	/* Event	*/
#define USB_NODE_GADGETCORE	"/dev/usb/gadgetcore"	/* Gadget Core Driver*/
#define USB_NODE_OTGCORE	"/dev/usb/otgcore"	/* OTG Core Driver*/
#define USB_NODE_MASSSTORAGE	"/dev/usb/massstorage"	/* Gadget Mass Storage*/
#define USB_NODE_SICD_CORE	"/dev/usb/sicd_core"	/* Gadget Still Image*/
#define USB_NODE_SICD_DATA	"/dev/usb/sicd_data"	/* Gadget Still Image*/
#define USB_NODE_SICD_EVENT	"/dev/usb/sicd_event"	/* Gadget Still Image*/
#define USB_NODE_SE		"/dev/usb/sen"		/* Gadget Senser*/
#define USB_NODE_TE		"/dev/usb/ter"		/* Gadget Terminal*/
#define USB_NODE_VSPE		"/dev/usb/vspe"		/* Gadget Vendor*/
#define USB_NODE_EXT_CMD	"/dev/usb/usb_extcmd"		/* extcmd */
#define USB_NODE_USBCORE	"/dev/usb/usbcore"	/* USB Core(Host Core)	*/
#define USB_NODE_SCSI		"/dev/usb/scsi"		/* SCSI	*/
#define USB_NODE_CURRENT	"/dev/usb/cur"		/* Current Driver	*/
#define USB_NODE_STD		"/dev/usb/std"		/* test */
#define USB_NODE_ADB		"/dev/usb/adb"		/* adb */
#endif
