#!/bin/sh

# Exit immediately on errors.
set -e

function chmod_x () {
    for f in "$@"; do
	test -f "$f" && chmod ug+x "$f"
    done
    return 0 # Discard result of last test, which may fail.
}

# For SS related works.
chmod_x setup-*
chmod_x scripts/setup_common.py
chmod_x scripts/config-modifiers/*

# For git to properly work with .pc/ files.
chmod -R ug+rw .pc/

# This script itself
chmod_x scripts/fix-filemodes.sh

# migration trace
chmod_x scripts/migrate_extract
chmod_x scripts/migrate_stats

# Kernel header scripts
chmod_x scripts/*.sh

# LTTng
chmod_x drivers/staging/lttng/*.sh

# setconfig scripts
chmod_x scripts/setconfig.py

#ubuntu
chmod_x debian/rules
chmod_x debian/scripts/config-check
chmod_x debian/scripts/misc/find-obsolete-firmware
chmod_x debian/scripts/misc/get-firmware
chmod_x debian/scripts/misc/getabis

# Exception Monitor scripts
chmod_x scripts/em/emlogconv

# stack size scripts
chmod_x tools/stack_size/checkstack-all.pl
chmod_x tools/stack_size/check_static_stack_usage.sh
chmod_x tools/stack_size/columnize.py
chmod_x tools/stack_size/joinlines.py
chmod_x tools/stack_size/stack_size


# ssboot scripts
chmod_x tools/ssboot/ssboot_analyze.py
chmod_x tools/ssboot/ssboot_analyze_filecounter.py
chmod_x tools/ssboot/ssboot_analyze_pidcounter.py
chmod_x tools/ssboot/ssboot_analyze_typecounter.py

# Looks at the current index and checks to see if merges or updates
# are needed by checking stat() information.
# This is needed for errornous cg-commit log listing all files
# modified by this file.
#
# git-update-index returns non-zero (indicating some files are changed).
# Ignore it by `|| true', so that the entire script exits with zero.
git update-index --refresh > /dev/null || true
