#ifndef INC_DMM_MGR_H
#define INC_DMM_MGR_H

#include "srt.h"
#include "common.h"

class dmm_mgr {
public:
    ~dmm_mgr();

public:
    static dmm_mgr *GetInstance();
    bool Set(void *dmmPtr, uint64_t dmmSz);
    void Reset();

    void *DmmMalloc(size_t size);
    void *DmmNew(size_t size);

private:
    dmm_mgr();
    dmm_mgr(const dmm_mgr &) = delete;
    dmm_mgr(dmm_mgr &&) = delete;

private:
    uint8_t *dmmPtr_;
    uint64_t dmmSz_;
    size_t curOffs_;
};

#endif
