/*
 * arch/arm64/kernel/uart.S
 *
 * UART initialize for ARCH_CXD900XX
 *
 * Copyright 2018 Sony Corporation
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 */
#include <linux/linkage.h>
#include <asm/assembler.h>
#include <linux/amba/serial.h>
#include <mach/uart.h>

	.text
	.pushsection ".idmap.text", "ax"
ENTRY(uart_init)
	uart_portconfig
	mov	x5, #UARTPA
	// Interrupt mask
	str	wzr, [x5, #UART011_IMSC]
	// 8N1
	mov	w6, #__UART_BAUD_F
	str	w6, [x5, #UART011_FBRD]
	mov	w6, #__UART_BAUD_I
	str	w6, [x5, #UART011_IBRD]
	mov	w6, #__UART_8N1_NO_FIFO
	str	w6, [x5, #UART011_LCRH]
	// clear error
	str	wzr, [x5, #UART01x_ECR]
	// TX enable
	mov	w6, #UART011_CR_TXE
	orr	w6, w6, #UART01x_CR_UARTEN
	str	w6, [x5, #UART011_CR]
	ret
ENDPROC(uart_init)
