/*
 * Copyright 2018 Sony Imaging Products & Solutions Inc.
 * Copyright 2018 Sony Corporation.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <linux/regmap.h>
#include "cxd-clk-debugfs.h"

static struct cxd_clk_debugfs_regset cxd_regset;

static int debugfs_show_regset32(struct seq_file *s, void *data)
{
        struct cxd_clk_debugfs_regset *regset = s->private;

        const struct debugfs_reg32 *regs = regset->regs;
        struct regmap *map = regset->regmap;
        int nregs = regset->nregs;
        unsigned int reg_val, i;

        for (i = 0; i < nregs; i++, regs++) {
                regmap_read(map, regs->offset, &reg_val);
                seq_printf(s, "%s = 0x%08x\n", regs->name, reg_val);
                if (seq_has_overflowed(s))
                        break;
        }

        return 0;
}

static int debugfs_open_regset32(struct inode *inode, struct file *file)
{
        return single_open(file, debugfs_show_regset32, inode->i_private);
}

static const struct file_operations cxd_clk_regset_fops = {
        .open = debugfs_open_regset32,
        .read = seq_read,
        .llseek = seq_lseek,
        .release = single_release,
};

void cxd_clk_debugfs_regset_set(struct regmap *clk_regmap, struct debugfs_reg32 *dbg_reg, int reg_num)
{
        cxd_regset.regs = dbg_reg;
        cxd_regset.nregs = reg_num;
        cxd_regset.regmap = clk_regmap;
}

static int cxd_clk_debugfs_register(void)
{
        struct dentry *rootdir;

        rootdir = debugfs_create_dir("cxd-clk", NULL);
        if (!rootdir)
                return -ENOMEM;

        if (!debugfs_create_file("clk_reg_dump", 0444, rootdir, &cxd_regset, &cxd_clk_regset_fops))
                printk("%s debugfs_create_file fail\n", __func__);

        return 0;
}
late_initcall(cxd_clk_debugfs_register);

