/*
 * mach-cxd900xx/include/mach/head_init.h
 *
 * CXD90057 head_init macros
 *
 * Copyright 2019 Sony Imaging Products & Solutions Inc
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 */
#ifndef __CXD90057_MACH_HEAD_INIT_H
#define __CXD90057_MACH_HEAD_INIT_H

/*---------------- FDT --------------------*/
#define FDT_OFFSET	0x7E000	/* FDT at (_text - FDT_OFFSET) */

/*------------ GenericTimer ---------------*/
#define GT_FRQ		2000000			// 2MHz

/*----------- GIC address map -------------*/
#if defined(CONFIG_ARCH_CXD900XX_FVP)
# define GICD_BASE	0x2c001000
# define GICC_BASE	0x2c002000
#elif defined(CONFIG_ARCH_CXD900XX_QEMU)
# define GICD_BASE	0x08000000
# define GICC_BASE	0x08010000
#elif defined(CONFIG_ARCH_CXD900XX_FPGA_V1_5)
# define GICD_BASE	0xf1251000
# define GICC_BASE	0xf1252000
#else
# define GICD_BASE	0xf13a1000
# define GICC_BASE	0xf13a2000
#endif
#define GICD_NSPI	448

	.macro	bootcpu_enter
	bl	cxd900xx_init
	.endm

	.macro	bootcpu_leave
	bl	cxd900xx_smp_init
#if !defined(CONFIG_ARCH_CXD900XX_QEMU)
	adr	x0, _text
	sub	x0, x0, #FDT_OFFSET		// x0=FDT
	mov	x1, xzr
	mov	x2, xzr
	mov	x3, xzr
#endif /* !CONFIG_ARCH_CXD900XX_QEMU */
	.endm

	.macro	secondary_enter
	.endm

	.macro	secondary_leave
	bl	cxd900xx_secondary_init
	.endm

#endif /* __CXD90057_MACH_HEAD_INIT_H */
