/*
 * mach-cxd900xx/resume.S
 *
 * resume entry for cxd90057
 *
 * Copyright 2015 Sony Corporation
 * Copyright 2019 Sony Imaging Products & Solutions Inc
 *
 * This code is based on arch/arm/mach-sa1100/sleep.S
 */
/*
 * SA11x0 Assembler Sleep/WakeUp Management Routines
 *
 * Copyright (c) 2001 Cliff Brake <cbrake@accelent.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License.
 *
 * History:
 *
 * 2001-02-06: Cliff Brake         Initial code
 *
 * 2001-08-29:	Nicolas Pitre	Simplified.
 *
 * 2002-05-27:	Nicolas Pitre	Revisited, more cleanup and simplification.
 *				Storage is on the stack now.
 */

#include <linux/linkage.h>
#include <asm/assembler.h>
#ifdef CONFIG_SNSC_SSBOOT
#include <linux/ssboot_stat.h>
#endif

/*
 * cxd90057_resume()
 *
 * entry point from bootloader into kernel during resume
 *   Redboot does not have resume vector.
 *   Please jump to this vector by "go" command of RedBoot.
 */
/*
 * Execute only CPU#0.
 * Because, other CPUs are offline before sleep.
 * CPU should be EL3.
 */
#ifdef CONFIG_SNSC_SSBOOT
	.pushsection ".data", "aw"
	.globl  cxd90057_ssboot_stat
	.align	2
cxd90057_ssboot_stat:	.long	SSBOOT_CREATE_MINSSBI
	.popsection
#endif /* CONFIG_SNSC_SSBOOT */

	.pushsection ".idmap.text", "ax"
#ifdef CONFIG_SNSC_SSBOOT
ENTRY(cxd90057_resume_profile)
	mov	w1, #SSBOOT_PROFILE
	b	1f
ENTRY(cxd90057_resume_optimize)
	mov	w1, #SSBOOT_CREATE_OPTSSBI
	b	1f
ENTRY(cxd90057_resume_ssboot_pre)
	mov	w1, #SSBOOT_SSBOOT_PRE
	b	1f
ENTRY(cxd90057_resume_ssboot)
	mov	w1, #SSBOOT_SSBOOT
1:
	bl	cxd900xx_init	// x10 corrupted
	adr_l	x0, cxd90057_ssboot_stat
	str	w1, [x0]
	b	1f
#endif /* CONFIG_SNSC_SSBOOT */
ENTRY(cxd90057_resume)
	bl	cxd900xx_init
1:
#if defined(CONFIG_DEBUG_EARLY) || defined(CONFIG_CXD900XX_UART_IO_INIT)
	bl	uart_init
#endif
#ifdef CONFIG_DEBUG_EARLY
	mov	w0, #'R'
	bl	printch			// x1-x3 corrupted
#endif /* CONFIG_DEBUG_EARLY */

	bl	v8_boot
	bl	cxd900xx_smp_init
	b	cpu_resume
ENDPROC(cxd90057_resume)
	.ltorg
	.popsection
