#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/slab.h>
#include <linux/platform_device.h>
#include <linux/dma-mapping.h>
#include <linux/io.h>
#include <linux/delay.h>
#include "core.h"

/* TCA Register Map*/
#define TCA_INTR_EN             0x4
#define TCA_INTR_STS            0x8
#define TCA_GCFG                0x10
#define TCA_TCPC                0x14
#define TCA_GEN_STATUS          0x34

#define TCA_INTR_STS_MASK       0xffffffff
#define TCA_FLD_ACK_EN          (1<<0)
#define TCA_FLD_TIMEOUT_EN      (1<<1)
#define TCA_GCFG_FLD_OP_SYSMOD  (1<<0)
#define TCA_GCFG_FLD_ROLE_HSTDEV        (1<<4)
#define TCA_GEN_PHY_DISABLE     (1<<3)
#define TCA_TCPC_MUX_CTL_USB31  1
#define TCA_TCPC_VALID          (1<<4)



int setup_cxd_uphy(void __iomem *phy_addr)
{
	u32	value;
	u32	retries=1000;

	//Clear TCA IRQ
	value = readl(phy_addr + TCA_INTR_STS) | TCA_INTR_STS_MASK;
	writel(value, (phy_addr + TCA_INTR_STS));

	//Enable TCA IRQ
	value = readl(phy_addr + TCA_INTR_EN) | (TCA_FLD_ACK_EN | TCA_FLD_TIMEOUT_EN);
	writel(value, (phy_addr + TCA_INTR_EN));

	//Setup TCA_GCFG register
	value = readl(phy_addr + TCA_GCFG) | TCA_GCFG_FLD_OP_SYSMOD;
	writel(value, (phy_addr + TCA_GCFG));

	value = readl(phy_addr + TCA_GCFG) | TCA_GCFG_FLD_ROLE_HSTDEV;
	writel(value, (phy_addr + TCA_GCFG));
	//Polling TCA_GEN_STATUS bit[3] register
	do{
		value = readl(phy_addr + TCA_GEN_STATUS);
		if((value & TCA_GEN_PHY_DISABLE))
			goto done;
		udelay(1);
	}while(--retries);

	return -ETIMEDOUT;
done:
	//Setup TCA_TCPC register
	value = readl(phy_addr + TCA_TCPC) | TCA_TCPC_MUX_CTL_USB31;
	writel(value, (phy_addr + TCA_TCPC));

	value = readl(phy_addr + TCA_TCPC) | TCA_TCPC_VALID;
	writel(value, (phy_addr + TCA_TCPC));
	return 0;
}


