/**
 *	@file	usbg_iap_main.c
 *	@brief	USB iAP(iAP Device Interface) - main
 *	
 *	Copyright 2024 Sony Group Corporation
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <linux/module.h>
#include <linux/moduleparam.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/fs.h>
#include <linux/version.h>

#include <linux/usb/ch9.h>

#include <linux/device.h>

#include <linux/usb/gadget.h>

#include <linux/usb/gcore/usb_event.h>
#include <linux/usb/gcore/usb_gadgetcore.h>

#include <linux/udif/cdev.h>
#include <mach/udif/devno.h>

#include <linux/usb/specific_gadget/usbg_cmn.h>
#include <linux/usb/specific_gadget/usbg_iap.h>
#include <linux/usb/specific_gadget/usbg_type.h>
#include <linux/usb/specific_gadget/usb_kdbg.h>

#define FNAME "usbg_iap_main.c"
#include "usbg_iap_conf.h"
#include "usbg_iap_pvt.h"

/*
 *	@brief	Licence
 */
MODULE_AUTHOR("Sony Corporation");								///< author
MODULE_DESCRIPTION(MY_DESC);									///< description
MODULE_VERSION(MY_VER);											///< version
MODULE_LICENSE("GPL");											///< license


/**
 *	@brief	File operations (/dev/iap_core)
 */
static struct UDIF_CDEV_OPS iap_core_fops = {
    .open  = iap_core_open,
    .close = iap_core_release,
    .ioctl = iap_core_ioctl,
    .write = iap_core_write,
    .read  = iap_core_read,
};

/**
 *	@brief	Core driver information for sonymisc
 */
static struct usbg_cdev iap_core_dev = {
    .node = udif_device_node(UDIF_NODE_USB_IAP),
    .fops = &iap_core_fops,
};

/*
 *	@brief	Driver load
 */
static int __init start_module(void)
{
	int err;

    IAP_API();
	// register core driver
	err = usbg_cmn_reg(&iap_core_dev);
	if(err){
		IAP_ERR( "register core driver %d\n", err );
		return err;
	}
	
	// create iap instance
	err = iap_create_this();
	
	IAP_LOCK_INI();
	iap_get_this_ex()->req_comp_waiting = false;
	init_completion(&(iap_get_this_ex()->req_wait_completion));
	iap_get_this_ex()->activated = false;
	iap_get_this_ex()->in_buffer = NULL;
	iap_get_this_ex()->out_buffer = NULL;
	
	IAP_INF("driver loaded!!\n");

	return err;
}

/*
 *	@brief	Driver unload
 */
static void __exit stop_module(void)
{
    IAP_API();

	// create iap instance
	iap_delete_this();

	usbg_cmn_dereg(&iap_core_dev);
	
    IAP_INF("driver unloaded!!\n");
}


// module_init/module_exit
module_init(start_module);
module_exit(stop_module);
