/*
 * include/linux/usb/f_usb/usb_otg_notify.h
 *
 * Copyright (C) 2011-2012 FUJITSU SEMICONDUCTOR LIMITED
 * Copyright 2018 Sony Imaging Products and Solutions Incorporated.
 *
 * ALL RIGHTS RESERVED, COPYRIGHT (C) SOCIONEXT INC. 2015
 * LICENSED MATERIAL - PROGRAM PROPERTY OF SOCIONEXT INC.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*--------------------------------------------------------------------------*
 * include/linux/usb/scd/usb_otg_control.h
 *
 * USB controller driver OTG API
 *
 * Copyright 2005,2006,2008,2011 Sony Corporation
 *
 * This file is part of the HS-OTG Controller Driver SCD.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *---------------------------------------------------------------------------*/

#ifndef _USB_OTG_NOTIFY_H_
#define _USB_OTG_NOTIFY_H_

#include<linux/udif/types.h>


enum usb_otg_vbus_stat {
	USB_OTG_VBUS_STAT_OFF = 0,	/**< OFF   = 0 */
	USB_OTG_VBUS_STAT_LOW,		/**< LOW   = 1 */
	USB_OTG_VBUS_STAT_SESS, 	/**< SESS  = 2 */
	USB_OTG_VBUS_STAT_VALID,	/**< VALID = 3 */
};

enum usb_otg_cid_stat {
	USB_OTG_CID_STAT_A = 0,		/**< A   = 0 */
	USB_OTG_CID_STAT_B,		/**< B   = 1 */
};

enum usb_otg_line_state_value {
	USB_OTG_LINE_STATE_LOW = 0,	/**< Low  */
	USB_OTG_LINE_STATE_HIGH = 1U,	/**< High */
};


enum usb_otg_event_type {
	USB_OTG_EVENT_TYPE_CID = 0,
	USB_OTG_EVENT_TYPE_VBUS,
	USB_OTG_EVENT_TYPE_VBUSERROR,
	USB_OTG_EVENT_TYPE_CON,
	USB_OTG_EVENT_TYPE_SRP,
	USB_OTG_EVENT_TYPE_RCHOST,
	USB_OTG_EVENT_TYPE_RCGADGET,
};


struct usb_otg_event_cid {
	enum usb_otg_event_type type;
	unsigned int value;
	unsigned int port;
};


struct usb_otg_event_vbus {
	enum usb_otg_event_type type;
	enum usb_otg_vbus_stat vbus_stat;
	unsigned int port;
};


struct usb_otg_event_vbuserror {
	enum usb_otg_event_type type;
};


struct usb_otg_event_con {
	enum usb_otg_event_type type;
	unsigned int value;
};


struct usb_otg_event_srp {
	enum usb_otg_event_type type;
};


struct usb_otg_event_rc {
	enum usb_otg_event_type type;
	unsigned int status;			/**< RoleChange status */
};

#define USB_OTG_SUCCESS 		0
#define USB_OTG_FAIL_T_B_ASE0_BRST	1U
#define USB_OTG_FAIL_T_A_AIDL_BDIS	2U

union usb_otg_event {
	enum usb_otg_event_type type;
	struct usb_otg_event_cid cid;
	struct usb_otg_event_vbus vbus;
	struct usb_otg_event_vbuserror vbuserror;
	struct usb_otg_event_con con;
	struct usb_otg_event_srp srp;
	struct usb_otg_event_rc rchost;
	struct usb_otg_event_rc rcgadget;
};

extern enum usb_otg_vbus_stat fusb_otg_get_vbus(void);
extern int fusb_otg_notify_vbuserror(void);
extern int fusb_otg_notify_connect(unsigned int con);
#define FUSB_EVENT_DISCONNECT		0
#define FUSB_EVENT_CONNECT		1U

extern int usb_otg_control_register_core_notify(int (*notify) (void * p));
extern int usb_otg_control_unregister_core_notify(int (*notify) (void * p));

static inline int
usb_otg_core_notify(int (*notify)(void *p), void *otg_event)
{
	if (NULL == notify) return -EINVAL;
	return notify(otg_event);
}

#endif  /* !_USB_OTG_NOTIFY_H_ */
