/*
 * Copyright (c) 2015 Elliptic Technologies Inc.
 */

#include <params.h>
// include spacc modes if we are in userspace
#ifndef _ELPSPACCMODES_H_
   #include "elpspaccmodes.h"
#endif

// no __user in userspace
#ifndef KERNEL
   #ifndef __user
      #define __user
   #endif
#endif

enum {
   ELP_SPACC_USR_INIT=100,       // set keys/mode
   ELP_SPACC_USR_PROCESS_IV,     // process packet and reset IV (not used with ivimport)
   ELP_SPACC_USR_PROCESS,        // process packet
   ELP_SPACC_USR_REGISTER,       // register a state key with this connection
   ELP_SPACC_USR_BIND,           // bind this connection to another
   ELP_SPACC_USR_FEATURES,       // get features out of the SPAcc config
   ELP_SPACC_USR_CANCEL,         // cancel a job
};

#define ELP_SPACC_USR_MAX_DDT 8  // max userspace segments per src/dst

struct elp_spacc_usr_ddt {
   void __user *ptr;
   int          len;
};

#define ELP_SPACC_SRC_DDT(fd, x, addr, len) do { (fd)->io.src[x] = (struct elp_spacc_usr_ddt){(addr),(len)}; } while (0);
#define ELP_SPACC_DST_DDT(fd, x, addr, len) do { (fd)->io.dst[x] = (struct elp_spacc_usr_ddt){(addr),(len)}; } while (0);
#define ELP_SPACC_SRC_TERM(fd, x) do { (fd)->io.src[x] = (struct elp_spacc_usr_ddt){NULL,0}; } while (0);
#define ELP_SPACC_DST_TERM(fd, x) do { (fd)->io.dst[x] = (struct elp_spacc_usr_ddt){NULL,0}; } while (0);

#define ELP_SPACC_SRCLEN_SET(fd, x) (fd)->io.srclen = x
#define ELP_SPACC_DSTLEN_SET(fd, x) (fd)->io.dstlen = x

#define ELP_SPACC_SRCLEN_RESET(fd) (fd)->io.srclen = -1
#define ELP_SPACC_DSTLEN_RESET(fd) (fd)->io.dstlen = -1

enum {
   SPACC_MAP_HINT_TEST=0,  // test internally if there is valid overlap
   SPACC_MAP_HINT_USESRC,  // there is overlap and use the source mapping (because the destination mapping is contained inside it)
   SPACC_MAP_HINT_USEDST,  // there is overlap and use the destination mapping
   SPACC_MAP_HINT_NOLAP    // there is no overlap so don't bother trying to test for it
};

// Message begin/end flags
#define ELP_SPACC_USR_MSG_BEGIN 1
#define ELP_SPACC_USR_MSG_END   2

typedef unsigned long           uintptr_t;
struct elp_spacc_ioctl {
   unsigned char
                cmd,           // ioctl command
                cipher_mode,   // cipher mode
                aad_copy,      // copy the AAD or not
                hash_mode,     // hash mode
                icv_len,       // ICV length (0 for default)
                icv_mode,      // how to handle the ICV
                encrypt,       // 1 to set encrypt mode
                ckeylen,       // cipher key length
                civlen,        // cipher IV length
                hkeylen,       // hash key length
                hivlen,        // hash IV length
		is_kapi;       // for alignment explicitly
   int
                err,
		pkt_size;
   struct timespec	timeout; //remained time to be expired

   struct cryptEngine_cryptParam cryptParam;
   struct cryptEngine_encParam *encParam;
   struct cryptEngine_decParam *decParam;
   struct cryptEngine_authParam *authParam;

   unsigned char civ[64];                    // order is important, civ must come before ckey
   unsigned char ckey[64], hkey[128], hiv[128];
}__attribute__((packed));

struct elp_spacc_usr {
   int fd;
   struct elp_spacc_ioctl io;
};

#ifdef __KERNEL__
struct kio_t     //for kapi
{
		struct elp_spacc_ioctl *io;
	        PDU_DMA_ADDR_T _cipherParam_dma;
		int unit_size;
};
#endif


#ifndef KERNEL

int spacc_dev_open(struct elp_spacc_usr *io,
                   int cipher_mode, int hash_mode,    // cipher and hash (see elpspaccmodes.h)
                   int encrypt,                       // non-zero for encrypt (sign) modes
                   int icvmode,                       // ICV mode (see elpspaccmodes.h)
                   int icvlen,                        // length of ICV, 0 for default length (algorithm dependent)
                   int aad_copy,                      // non-zero to copy AAD to dst buffer
                   unsigned char *ckey, int ckeylen, unsigned char *civ, int civlen,  // cipher key and IVs
                   unsigned char *hkey, int hkeylen, unsigned char *hiv, int hivlen); // hash key and IVs (if any)

// return values for timeout and canceled
//-ETIMEDOUT//timeout
//-ECANCELED; //Operation Canceled
int spacc_dev_process_packets(struct elp_spacc_usr *io);
int spacc_dev_process_cancel(struct elp_spacc_usr *io);
int spacc_dev_close(struct elp_spacc_usr *io);

#endif
long spacc_kapi_process (unsigned long arg_);
