/*
 *  aspmctrl.h
 *
 *  Copyright 2020 Sony Imaging Products & Solutions Inc
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 */
#ifndef __PCIEDMA_ASPMCTRL_H__
#define __PCIEDMA_ASPMCTRL_H__

#define ASPMD_PRIO 148

#define POLLING_START_DELAY 20 /*us*/
#define POLLING_PERIOD       1 /*us*/
#define POLLING_TIMEOUT  10000 /*us*/

#include <linux/udif/wait.h>

struct stlog_ent {
	unsigned long t1, t2;
	uint32_t state;
};
#define STLOG_SIZE 32
struct stlog {
	struct stlog_ent data[STLOG_SIZE];
	int put, cnt;
};

struct aspm_ctrl {
	int use_aspm;
	int req_count; /* Number of requests for CH1.. */
	int active;    /* during aspm-control */

	/* root complex */
	uint16_t save;

	/* downstream component */
	struct pci_dev *dev;
	int linkctl; /* Link Control reg. offset */

	/* aspmd */
	struct task_struct *aspmd;
	UDIF_WAIT aspmd_wait;
	int aspmd_req;
	UDIF_WAIT aspmd_wait2;
	int aspmd_done;

	/* LTSSM log */
	struct stlog ltssmlog;
};

struct dma_info_t;
extern void aspmctl_request(struct dma_info_t *chan);
extern void aspmctl_relinquish(struct dma_info_t *chan);
extern void aspmctl_chan_init(struct dma_info_t *chan);

struct pci_info_t;
extern int aspmctl_init(struct pci_info_t *p);
extern void aspmctl_exit(struct pci_info_t *p);
extern void aspmctl_connect(struct pci_info_t *p);
extern void aspmctl_shutdown(struct pci_info_t *p);

#endif /* __PCIEDMA_ASPMCTRL_H__ */
