/*
 * arch/arm64/kernel/boot.S
 *
 *
 * Copyright 2018,2019 Sony Corporation
 *
 * This code is based on arch/arm64/kernel/head.S.
 */
/*
 * Low-level CPU initialisation
 * Based on arch/arm/kernel/head.S
 *
 * Copyright (C) 1994-2002 Russell King
 * Copyright (C) 2003-2012 ARM Ltd.
 * Authors:	Catalin Marinas <catalin.marinas@arm.com>
 *		Will Deacon <will.deacon@arm.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <linux/linkage.h>
#include <linux/init.h>
#include <asm/assembler.h>
#include <asm/cputype.h>
#include <mach/head_init.h>

	__HEAD

ENTRY(ej_head_init)
	// preserve: x0-x3 (for QEMU and FVP)
	// destroy: x28, x27, x10
	mov	x28, lr			// save LR

	// SMP common entry
	mrs	x10, mpidr_el1
	ands	x10, x10, #MPIDR_LEVEL_MASK	// CPU#
	b.ne	ej_secondary_entry

	// CPU#0
	bootcpu_enter			// preserve x28

#if defined(CONFIG_DEBUG_EARLY) || defined(CONFIG_CXD900XX_UART_IO_INIT)
	bl	uart_init
#endif

	bl	v8_boot

	bootcpu_leave			// preserve x28

	ret	x28
ENDPROC(ej_head_init)

ENTRY(v8_boot)
	// This routine is called by CPU#0.
	// destroy: x27, x10
	mov	x27, lr
	mrs	x10, CurrentEL
	cmp	x10, CurrentEL_EL3
	b.ne	1f
	bl	gic_dist_init
	bl	gic_cpu_init
	bl	el3_setup
1:
	bl	__smp_init
	ret	x27
ENDPROC(v8_boot)

ENTRY(ej_secondary_entry)
	secondary_enter

	mrs	x10, CurrentEL
	cmp	x10, CurrentEL_EL3
	b.ne	1f
	bl	gic_cpu_init
	bl	el3_setup
1:
	bl	__smp_init

	secondary_leave

	mov	x0, xzr
	mov	x1, xzr
	mov	x2, xzr
	mov	x3, xzr
spin:
	wfe
	adr_l	x10, mach_cpu_release_addr
	ldr	x10, [x10]
	cbz	x10, spin
	b	secondary_holding_pen		// x10
ENDPROC(ej_secondary_entry)

	.pushsection ".data", "aw"
	.globl mach_cpu_release_addr
	.align 3
mach_cpu_release_addr:	.quad	0
	.popsection


#define CPUECTLR_EL1	S3_1_C15_C2_1
#define CPUECTLR_SMPEN	0x40

__smp_init:
#if !defined(CONFIG_ARCH_CXD900XX_FVP)
	mrs	x10, CPUECTLR_EL1
	orr	x10, x10, #CPUECTLR_SMPEN
	msr	CPUECTLR_EL1, x10
#endif /* !CONFIG_ARCH_CXD900XX_FVP */
	ret

/*------------- EL3 --------------*/
#define SCR_RW		0x400
#define SCR_SMD		0x080
#define SCR_RES1	0x030
#define SCR_NS		0x001
#define SPSR_D_MASK	0x200
#define SPSR_A_MASK	0x100
#define SPSR_I_MASK	0x080
#define SPSR_F_MASK	0x040
#define SPSR_ALL_MASK	(SPSR_D_MASK|SPSR_A_MASK|SPSR_I_MASK|SPSR_F_MASK)
#define SPSR_M_EL2H	0x009
#define SPSR_M_EL1H	0x005
#define ACTL_L2A	0x40
#define ACTL_L2E	0x20
#define ACTL_L2		0x10
#define ACTL_CPUE	0x02
#define ACTL_CPUA	0x01
#define ACTL_ALL_ACC	(ACTL_L2A|ACTL_L2E|ACTL_L2|ACTL_CPUE|ACTL_CPUA)

#ifdef CONFIG_ARM64_VHE
# define SPSR_VAL (SPSR_ALL_MASK|SPSR_M_EL2H)
#else
# define SPSR_VAL (SPSR_ALL_MASK|SPSR_M_EL1H)
#endif

/*------------- EL2 --------------*/
#define HCR_RW			0x80000000
#define CPTR_RES1		0x000033FF
#define CNTHCTL_EL1PCEN		0x00000002
#define CNTHCTL_EL1PCTEN	0x00000001

el3_setup:
	msr	elr_el3, lr			// save LR
	// EL3 registers
#ifdef CONFIG_EJ_USE_EL3
	adr	x10, __el3_vectors		// PA
	msr	vbar_el3, x10
	mov	x10, #(SCR_RW|SCR_RES1|SCR_NS)
#else
	mov	x10, #(SCR_RW|SCR_SMD|SCR_RES1|SCR_NS)
#endif
	msr	scr_el3, x10
	isb
	msr	cptr_el3, xzr			// no trap
	mov	x10, #ACTL_ALL_ACC
	msr	actlr_el3, x10
	ldr	x10, =GT_FRQ
	msr	cntfrq_el0, x10
#ifndef CONFIG_ARM64_VHE
	// EL2 registers
	msr	hstr_el2, xzr			// no trap
	mov	x10, #HCR_RW			// EL1 is AARCH64
	msr	hcr_el2, x10
	isb
	mov	x10, #CPTR_RES1			// no trap
	msr	cptr_el2, x10
	mov	x10, #ACTL_ALL_ACC
	msr	actlr_el2, x10
	isb
	mov	x10, #(CNTHCTL_EL1PCEN|CNTHCTL_EL1PCTEN)
	msr	cnthctl_el2, x10
	msr	cntvoff_el2, xzr
	// Populate ID registers */
	mrs	x10, midr_el1
	msr	vpidr_el2, x10
	mrs	x10, mpidr_el1
	msr	vmpidr_el2, x10
#endif /* !CONFIG_ARM64_VHEL */
	// EL transision
	ldr	x10, =SPSR_VAL
	msr	spsr_el3, x10
	eret

#include <linux/irqchip/arm-gic.h>

	/*----------- GIC v2 -------------*/
#define GICD_CTLR_ENGRP1	0x2
#define GICD_CTLR_ENGRP0	0x1
#define GICD_IGRP_GROUP1	0xffffffff
#define GICC_CTLR_EOIMODENS	0x400
#define GICC_CTLR_EOIMODES	0x200
#define GICC_CTLR_EOI		(GICC_CTLR_EOIMODENS|GICC_CTLR_EOIMODES)
#define GICC_CTLR_IRQNOBYPGRP1	0x100
#define GICC_CTLR_FIQNOBYPGRP1	0x080
#define GICC_CTLR_IRQNOBYPGRP0	0x040
#define GICC_CTLR_FIQNOBYPGRP0	0x020
#define GICC_CTLR_NOBYPASS	(GICC_CTLR_IRQNOBYPGRP1|GICC_CTLR_FIQNOBYPGRP1|GICC_CTLR_IRQNOBYPGRP0|GICC_CTLR_FIQNOBYPGRP0)
#define GICC_CTLR_CBPR		0x010
#define GICC_CTLR_FIQEN		0x008
#define GICC_CTLR_ACKCTL	0x004
#define GICC_CTLR_ENGRP1	0x002
#define GICC_CTLR_ENGRP0	0x001
#define GICC_PMR_NSMASK		0x80

gic_dist_init:
	ldr	x11, =GICD_BASE
#if defined(CONFIG_ARCH_CXD900XX_FPGA_GIC_WORKAROUND)
	mov	w10, #GICD_CTLR_ENGRP0
#else
	mov	w10, #GICD_CTLR_ENGRP1
#endif
	str	w10, [x11, #GIC_DIST_CTRL]
#if !defined(CONFIG_ARCH_CXD900XX_FPGA_GIC_WORKAROUND)
	// initialize GICD_IGROUPRn
	mov	w10, #GICD_IGRP_GROUP1
	add	x11, x11, #GIC_DIST_IGROUP+4	// IGROUP#1..IGROUP#N
	mov	w12, #(GICD_NSPI/32)
1:
	str	w10, [x11], #4
	subs	w12, w12, #1
	b.ne	1b
#endif
	ret

gic_cpu_init:
#if !defined(CONFIG_ARCH_CXD900XX_FPGA_GIC_WORKAROUND)
	ldr	x11, =GICD_BASE
	mov	w10, #GICD_IGRP_GROUP1
	str	w10, [x11, #GIC_DIST_IGROUP]
#endif
	ldr	x11, =GICC_BASE
#if defined(CONFIG_ARCH_CXD900XX_FPGA_GIC_WORKAROUND)
	mov	w10, #(GICC_CTLR_EOI|GICC_CTLR_NOBYPASS|GICC_CTLR_ENGRP0)
#else
	mov	w10, #(GICC_CTLR_EOI|GICC_CTLR_NOBYPASS|GICC_CTLR_ENGRP1)
#endif
	str	w10, [x11, #GIC_CPU_CTRL]
	mov	w10, #GICC_PMR_NSMASK
	str	w10, [x11, #GIC_CPU_PRIMASK]
	ret

gic_dump:
	mov	w0, #'\r'
	bl	printch
	mov	w0, #'\n'
	bl	printch
	ldr	x11, =GICD_BASE
	mov	w12, #1024
2:
	ldr	w0, [x11]
	bl	printhex32
	mov	w0, #' '
	bl	printch
	add	x11, x11, #4
	sub	w12, w12, #1
	ands	w0, w12, #0x7
	b.ne	1f
	mov	w0, #'\r'
	bl	printch
	mov	w0, #'\n'
	bl	printch
1:
	cbnz	w12, 2b
1:
	wfi
	b	1b
	.ltorg
