/*
 * mach-cxd900xx/ddr.c
 *
 * CXD90057 DDRC
 *
 * Copyright 2019 Sony Imaging Products & Solutions Inc
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 */

#include <linux/module.h>
#include <linux/moduleparam.h>
#include <mach/moduleparam.h>
#include <linux/udif/module.h>
#include <linux/udif/io.h>
#include <linux/udif/delay.h>
#include <mach/regs-ddrc.h>

#define PASR_FULL	0x00
#define TIMEOUT		100 /* usec */

/* LOW POWER control (SRef/DPD) */
extern unsigned long cxd90057_ddr_ctrl;  /* sleep.S */
module_param_named(ddr_ctrl, cxd90057_ddr_ctrl, ddrctrl, S_IRUSR|S_IWUSR);

/*
 * Partial Array Self Refresh
 */
static unsigned long cxd90057_ddr_pasr[N_DDR_CS];
module_param_named(pasr0, cxd90057_ddr_pasr[0], ulongH, S_IRUSR|S_IWUSR);
module_param_named(pasr1, cxd90057_ddr_pasr[1], ulongH, S_IRUSR|S_IWUSR);

#if 0
static unsigned int ddrc_csmap(int ch)
{
	return (readl(VA_DDRC(ch)+CSMAP_REG)>>CSMAP_SHIFT)&CSMAP_MASK;
}
#endif

static void ddrc_wrmodereg(const UDIF_DEVICE *dev, UDIF_CH ch, u8 cs, u8 reg, u8 data)
{
	UDIF_VA ddrc = udif_devio_virt(dev, ch);
	UDIF_U32 cmd, offs, shft, mask;
	UDIF_U32 tmp;
	int t;

	if (cs >= N_DDR_CS)
		return;
	if (!ddrc)
		return;
	cmd = WRMODE_EXEC|WRMODE_SINGLE|(cs << WRMODE_CS)|reg;
	/* clear int status */
	udif_iowrite32(INTSTAT_WRMODE, ddrc + INTACK_REG);
	if (!cs) {
		offs = MRSINGLE0_REG;
		shft = MRSINGLE0_SH;
		mask = MRSINGLE0_MASK;
	} else {
		offs = MRSINGLE1_REG;
		shft = MRSINGLE1_SH;
		mask = MRSINGLE1_MASK;
	}
	/* RMW */
	tmp = udif_ioread32(ddrc + offs);
	tmp &= ~mask;
	tmp |= data << shft;
	udif_iowrite32(tmp, ddrc + offs);

	udif_iowrite32(cmd, ddrc + WRMODE_REG);
	/* wait for completion */
	t = TIMEOUT;
	while (!(udif_ioread32(ddrc + INTSTAT_REG) & INTSTAT_WRMODE) && t--)
		udif_udelay(1);
	if (t < 0) {
		printk(KERN_ERR "ERROR:DDR%u:%u:%s:timeout\n", ch, cs, __func__);
	}
}

static void ddrc_set_pasr(const UDIF_DEVICE *dev, UDIF_CH ch, u8 cs, u8 pasr)
{
	if (!pasr)
		return;

	ddrc_wrmodereg(dev, ch, cs, MR17, pasr);
}

static void ddrc_set_full(const UDIF_DEVICE *dev, UDIF_CH ch)
{
	u8 cs;

	for (cs = 0; cs < N_DDR_CS; cs++) {
		ddrc_wrmodereg(dev, ch, cs, MR17, PASR_FULL);
	}
}

static UDIF_ERR ddrc_probe(const UDIF_DEVICE *dev, UDIF_CH ch, UDIF_VP data)
{
	ddrc_set_full(dev, ch);
	return UDIF_ERR_OK;
}

static UDIF_ERR ddrc_suspend(const UDIF_DEVICE *dev, UDIF_CH ch, UDIF_VP data)
{
	u8 cs;

	for (cs = 0; cs < N_DDR_CS; cs++) {
		ddrc_set_pasr(dev, ch, cs, cxd90057_ddr_pasr[cs]);
	}
	return UDIF_ERR_OK;
}

static UDIF_ERR ddrc_resume(const UDIF_DEVICE *dev, UDIF_CH ch, UDIF_VP data)
{
	ddrc_set_full(dev, ch);
	return UDIF_ERR_OK;
}

static UDIF_DRIVER_OPS ddrc_ops = {
	.probe		= ddrc_probe,
	.suspend	= ddrc_suspend,
	.resume		= ddrc_resume,
};

UDIF_IDS(ddrc_devs) = {
	UDIF_ID(UDIF_ID_DDR, UDIF_CH_MASK_DEFAULT),
};
UDIF_DEPS(ddrc_deps) = {};

static UDIF_MODULE(ddrc, "ddrc", "1.0", ddrc_ops, ddrc_devs, ddrc_deps, NULL);
