/**
 * Copyright 2019 Sony Imaging Products & Solutions Inc
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2  of
 * the License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#if !defined(__CXD_PHY_H__)
#define __CXD_PHY_H__

int teardown_cxd_u31phy(void);
int setup_cxd_u31phy(void);
int force_u31_gen1(void);
int force_u31_to_hs(void);

int enable_cr_para_sel(void __iomem *reg);
int disable_cr_para_sel(void __iomem *reg);
int check_cr_sram_init_done(void __iomem *reg);
int cr_para_sel_done(void __iomem *reg);

int u2phy_adjust(void __iomem *reg, const void *_data, const void *_port);
void cr_phy31_adjust_init(void);
int cr_phy31_adjust(void __iomem *reg, const void *data);
int cr_phy31_adjust_post_csftrst(void);

void snapshot_phy_param(void __iomem *u2reg, void __iomem *u31reg);
int read_snapshot_phy_param(char *buf);

void download_snps_u3_phy_fw(void);

#endif  /* __CXD_PHY_H__ */
