/*
 * arch/arm/mach-cxd900x0/adc.c
 *
 * Copyright 2014 Sony Corporation.
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 */

#include <linux/module.h>
#include <linux/moduleparam.h>
#include <asm/io.h>

#include <linux/delay.h>
#include <linux/em_export.h>
#include <mach/platform.h>
#include <mach/regs-adc.h>

/*----------------------------------------------------------------------------
 * External Function Definitions:
 *--------------------------------------------------------------------------*/
void adc_enable(int unit, int ch)
{
	writew_relaxed(VAL_ADC_STCCYC | VAL_ADCLK_6, VA_ADC(unit) + ADC_CLKCTRL);
	writew_relaxed(VAL_AIN_SEL(ch),              VA_ADC(unit) + AIN_SEL);
	writew_relaxed(VAL_ADC_WAIT,                 VA_ADC(unit) + ADC_WAIT);
	writew_relaxed(VAL_ADC_INT_DISABLE,          VA_ADC(unit) + ADC_INT);
	writew_relaxed(VAL_ADC_MODE_BOOT,            VA_ADC(unit) + ADC_MODE);
}

void adc_disable(int unit)
{
	writew_relaxed(VAL_ADC_MODE_OFF, VA_ADC(unit) + ADC_MODE);
}

void adc_start(int unit)
{
	writew_relaxed(VAL_ADC_START, VA_ADC(unit) + ADC_TRG);
	udelay(VAL_ADC_START_USEC);
}

/**
 * @brief Confirm state whether idle or not(in resumption)
 *
 * @return TRUE     in idle
 * @return FALSE    not in idle
 */
int adc_is_idle(int unit)
{
	return (!(readw_relaxed(VA_ADC(unit) + ADC_STATUS) & MASK_STATUS_SEQ));
}

/**
 * @brief Get Data of A/D translation
 *
 * @param n_ch      ADC CH
 * @warning  confirm the return value of adc_is_ready() is TRUE before calling thie API
 */
uint16_t adc_get_sample(int unit, int ch)
{
	return (readw_relaxed(VA_ADC(unit) + ADC_DATA(ch)) & MASK_ADC_DATA);
}

/**
 * @brief Confirm whether A/D translation was completed
 *
 * @return TRUE     A/D translation was completed
 * @return FALSE    A/D translation is moving
 */
int adc_is_ready(int unit)
{
        return (!(readw_relaxed(VA_ADC(unit) + ADC_STATUS) & MASK_STATUS_CNV));
}
