/*
 * include/asm-arm/arch-cxd900x0/regs-ddrc.h
 *
 * CXD900X0 DDRC
 *
 * Copyright 2015 Sony Corporation
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 */
#ifndef __CXD900X0_REGS_DDRC_H__
#define __CXD900X0_REGS_DDRC_H__

/* ddr_ctrl I/F */
#define DDRC_DPD_CS0	(1<<0)
#define DDRC_DPD_CS1	(1<<1)
#define DDRC_SREF	(1<<2)

#define DDR_A	(0)
#define DDR_B	(1)

#define DDR_CS0 (0)
#define DDR_CS1 (1)

#define DDR_CTL(x)	((x) << 2)
#define _BIT(x)		(1 << (x))

#define LPCMD_REG	DDR_CTL(36)
#define LPCMD_STATIC	_BIT(8)
#define LPCMD_LOCK	_BIT(7)
#define LPCMD_CCKG	_BIT(6)
#define LPCMD_MCKG	_BIT(5)
#define LPCMD_SREF	(0x2<<2)
#define LPCMD_DPD	(0x3<<2)
#define LPCMD_ENTER	_BIT(1)
#define LPCMD_DPD_CMD	(LPCMD_STATIC|LPCMD_LOCK|LPCMD_MCKG|LPCMD_DPD|LPCMD_ENTER)
#define LPCMD_SREF_CMD	(LPCMD_LOCK|LPCMD_CCKG|LPCMD_MCKG|LPCMD_SREF|LPCMD_ENTER)

#define CS0_IDLE_REG	DDR_CTL(40)
#define CS0_IDLE_BIT	_BIT(24)
#define CS1_IDLE_REG	DDR_CTL(41)
#define CS1_IDLE_BIT	_BIT(0)

#define LP_CS_REG	DDR_CTL(40)
#define LP_CS0_BIT	_BIT(16)
#define LP_CS1_BIT	_BIT(17)
#define LP_CS_MASK	(LP_CS0_BIT|LP_CS1_BIT)

#define PCPCS_CSMAP_REG	DDR_CTL(40)
#define PCPCS_CS0_BIT	_BIT(8)
#define PCPCS_CS1_BIT	_BIT(9)

#define WRMODE_REG	DDR_CTL(50)
#define WRMODE_EXEC	_BIT(25)
#define WRMODE_SINGLE	_BIT(23)
#define WRMODE_CS	8
#define MR17		17

#define MRSINGLE0_REG	DDR_CTL(56)
#define MRSINGLE1_REG	DDR_CTL(59)

#define CSMAP_REG	DDR_CTL(78)
#define CSMAP_SHIFT	16
#define CSMAP_MASK	0x3

#define CTRLBUSY_REG	DDR_CTL(80)
#define CTRLBUSY_BIT	_BIT(0)

#define INTSTAT_REG	DDR_CTL(82)
#define INTSTAT_PCPCS_DONE_BIT	_BIT(26)
#define INTSTAT_PCPCS_ERR_BIT	_BIT(27)
#define INTSTAT_WRMODE_BIT	_BIT(20)
#define INTSTAT_LPCMD_DONE_BIT	_BIT(4)

#define INTACK_REG	DDR_CTL(83)
#define INTACK_PCPCS_BITMASK (INTSTAT_PCPCS_DONE_BIT|INTSTAT_PCPCS_ERR_BIT)

#ifdef __ASSEMBLY__
	.macro	sel_cs_idle, cs, reg, mask
	@ input:  cs = chip select#
	@ output: reg = csX_idle register offset
	@         mask = csX_idle bitmask
	cmp	\cs, #DDR_CS0
	moveq	\reg, #CS0_IDLE_REG
	moveq	\mask, #CS0_IDLE_BIT
	movne	\reg, #CS1_IDLE_REG
	movne	\mask, #CS1_IDLE_BIT
	.endm

	.macro	sel_pcpcs, cs, mask
	@ input:  cs = chip select#
	@ output: mask = pcpcs_cs_map bitmask
	cmp	\cs, #DDR_CS0
	moveq	\mask, #PCPCS_CS0_BIT
	movne	\mask, #PCPCS_CS1_BIT
	.endm

	.macro	sel_lp_cs, cs, mask
	@ input:  cs = chip select#
	@ output: mask = lp_cs bitmask
	cmp	\cs, #DDR_CS0
	moveq	\mask, #LP_CS0_BIT
	movne	\mask, #LP_CS1_BIT
	.endm
#endif /* __ASSEMBLY__ */
#endif /* __CXD900X0_REGS_DDRC_H__ */
