/*
 *  linux/include/asm-arm/arch-realview/vmalloc.h
 *
 *  Copyright (C) 2003 ARM Limited
 *  Copyright (C) 2000 Russell King.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#define VMALLOC_OFFSET		(8*1024*1024)

#ifdef CONFIG_CXD900X0_IOREMAP_RESERVE

#define IORSV_SIZE(x)	((IOREMAP_RSV##x##_UNIT + SZ_1M)*IOREMAP_RSV##x##_NUM)

#define IOREMAP_RSV_START	((unsigned long)(PAGE_OFFSET + CONFIG_CXD900X0_SIZE_DDR0 + CONFIG_CXD900X0_SIZE_DDR1 + VMALLOC_OFFSET))

#define IOREMAP_RSV1_START	IOREMAP_RSV_START
#define IOREMAP_RSV1_UNIT	SZ_512M
#define IOREMAP_RSV1_NUM	1
#define IOREMAP_RSV1_END	(IOREMAP_RSV1_START + IORSV_SIZE(1))

#define IOREMAP_RSV2_START	IOREMAP_RSV1_END
#define IOREMAP_RSV2_UNIT	SZ_32M
#define IOREMAP_RSV2_NUM	2
#define IOREMAP_RSV2_END	(IOREMAP_RSV2_START + IORSV_SIZE(2))

#define IOREMAP_RSV_END		IOREMAP_RSV2_END

#define VMALLOC_START		IOREMAP_RSV_END

#else /* CONFIG_CXD900X0_IOREMAP_RESERVE */

/* prefer constant expression */
#define VMALLOC_START		((unsigned long)(PAGE_OFFSET + CONFIG_CXD900X0_SIZE_DDR0 + CONFIG_CXD900X0_SIZE_DDR1 + VMALLOC_OFFSET))

#endif /* CONFIG_CXD900X0_IOREMAP_RESERVE */

#define VMALLOC_END		((unsigned long)(0xf0000000 - VMALLOC_OFFSET))
