/*
 * arch/arm/mach-cxd900x0/pcie_setup.c
 *
 * PCIE setup
 *
 * Copyright 2012,2013 Sony Corporation
 *
 * ALL RIGHTS RESERVED, COPYRIGHT (C) SOCIONEXT INC. 2015
 * LICENSED MATERIAL - PROGRAM PROPERTY OF SOCIONEXT INC.
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 */
#include <linux/module.h>
#include <linux/moduleparam.h>
#include <mach/moduleparam.h>
#include <linux/kernel.h>
#include <linux/delay.h>
#include <asm/io.h>
#include <mach/hardware.h>
#include <mach/regs-clk.h>
#include <mach/cxd900x0_cpuid.h>
#include <mach/platform.h>
#include <linux/pci.h>
#include <linux/pcieport_if.h>
#include <mach/pcie_export.h>
#include "pci_platform.h"

/* PCIe IO */
#define CXD900X0_PCIEIO		(CXD900X0_MACRO_BASE + 0x4040)
#define VA_PCIEIO			IO_ADDRESSP(CXD900X0_PCIEIO)
#define PCIEIO_DATA	0x00
#define PCIEIO_SET	0x04
#define PCIEIO_CLR	0x08

#define PCIEIO_CLKEN0		(1<<0)
#define PCIEIO_CLKEN1		(1<<8)

#define XPS_ALL_PCIE (REG_XPS_CK_AXI01_PCIE0|REG_XPS_CK_AXI01_PCIE0_H|REG_XPS_CK_AXI01_PCIE1|REG_XPS_CK_AXI01_PCIE1_H)

void cxd900x0_pcie_powersave(int channel, int save)
{
	unsigned long flags;
	u32 status;

	local_irq_save(flags);
	if (save) {
		/* Disable clock. */
		if (channel == 0) {
			/* ACLK, HCLK */
			writel_relaxed(REG_XPS_CK_AXI01_PCIE0,   VA_CLKRST3(IPCLKEN1)+CLKRST_CLR);
			writel_relaxed(REG_XPS_CK_AXI01_PCIE0_H, VA_CLKRST3(IPCLKEN1)+CLKRST_CLR);
			/* PCIe Reference CLK IO Gating: Gating enable */
			writel_relaxed(PCIEIO_CLKEN0, VA_PCIEIO + PCIEIO_CLR);
		} else {
			/* ACLK, HCLK */
			writel_relaxed(REG_XPS_CK_AXI01_PCIE1,   VA_CLKRST3(IPCLKEN1)+CLKRST_CLR);
			writel_relaxed(REG_XPS_CK_AXI01_PCIE1_H, VA_CLKRST3(IPCLKEN1)+CLKRST_CLR);
			/* PCIe Reference CLK IO Gating: Gating enable */
			writel_relaxed(PCIEIO_CLKEN1, VA_PCIEIO + PCIEIO_CLR);
		}
		wmb();
		status = readl_relaxed(VA_CLKRST3(IPCLKEN1));
		if (!(status & XPS_ALL_PCIE)) {
			/* AXI2AVB PCIe */
			/* Disable if the stop both PCIe channels */
			writel_relaxed(REG_XPS_CK_AVB_PCIE0 | REG_XPS_CK_AVB_PCIE1,
						   VA_CLKRST3(IPCLKEN0)+CLKRST_CLR);
		}
	} else {
		/* Enable clock. */
		/* AXI2AVB PCIe */
		writel_relaxed(REG_XPS_CK_AVB_PCIE0 | REG_XPS_CK_AVB_PCIE1,
					   VA_CLKRST3(IPCLKEN0)+CLKRST_SET);
		if (channel == 0) {
			/* ACLK, HCLK */
			writel_relaxed(REG_XPS_CK_AXI01_PCIE0,   VA_CLKRST3(IPCLKEN1)+CLKRST_SET);
			writel_relaxed(REG_XPS_CK_AXI01_PCIE0_H, VA_CLKRST3(IPCLKEN1)+CLKRST_SET);
			/* PCIe Reference CLK IO Gating: Gating disable */
			writel_relaxed(PCIEIO_CLKEN0, VA_PCIEIO + PCIEIO_SET);
		} else {
			/* ACLK, HCLK */
			writel_relaxed(REG_XPS_CK_AXI01_PCIE1,   VA_CLKRST3(IPCLKEN1)+CLKRST_SET);
			writel_relaxed(REG_XPS_CK_AXI01_PCIE1_H, VA_CLKRST3(IPCLKEN1)+CLKRST_SET);
			/* PCIe Reference CLK IO Gating: Gating disable */
			writel_relaxed(PCIEIO_CLKEN1, VA_PCIEIO + PCIEIO_SET);
		}
		wmb();
	}
	local_irq_restore(flags);
}
