/*
 * drivers/usb/f_usb/usb_otg_reg.h
 *
 * Copyright (C) 2011-2012 FUJITSU SEMICONDUCTOR LIMITED
 *
 * ALL RIGHTS RESERVED, COPYRIGHT (C) SOCIONEXT INC. 2015
 * LICENSED MATERIAL - PROGRAM PROPERTY OF SOCIONEXT INC.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _USB_OTG_REG_H_
#define _USB_OTG_REG_H_

static inline unsigned int get_reg_param(UDIF_VA base_address, unsigned int offset, unsigned int bit)
{
	UDIF_U32 reg_param;

	reg_param = udif_ioread32((UDIF_VA)(base_address + offset));

	return ((unsigned int)reg_param & bit);
}

static inline void set_reg_param(UDIF_VA base_address, unsigned int offset, unsigned int bit)
{
	UDIF_U32 reg_param;

	reg_param = udif_ioread32((UDIF_VA)(base_address + offset));
	reg_param |= bit;
	udif_iowrite32(reg_param, (UDIF_VA)(base_address + offset));

	return;
}

static inline void clear_reg_param(UDIF_VA base_address, unsigned int offset, unsigned int bit)
{
	UDIF_U32 reg_param;

	reg_param = udif_ioread32(base_address + offset);
	reg_param &= ~bit;
	udif_iowrite32(reg_param, (UDIF_VA)(base_address + offset));

	return;
}

static inline void write_reg_param(UDIF_VA base_address, unsigned int offset, unsigned int bit)
{
	udif_iowrite32((UDIF_U32)bit, (UDIF_VA)(base_address + offset));

	return;
}

/* OTG */
#define FUSB_REG_OTG_USB_ID_EXT_OFFSET		0x0010U			/**<  */
#define FUSB_DEF_USB_VBUS			(1U << 0)		/**<  */
#define FUSB_DEF_USB_ID 			(1U << 1)		/**<  */
#define FUSB_REG_OTG_USB_INTS_OFFSET		0x0030U			/**<  */
#define FUSB_DEF_USB_VBUS_INTS			(1U << 8)		/**<  */
#define FUSB_DEF_USB_ID_INTS			(1U << 9)		/**<  */
#define FUSB_REG_OTG_USB_INTHE_OFFSET		0x0040U			/**<  */
#define FUSB_DEF_USB_VBUS_INTHE 		(1U << 8)		/**<  */
#define FUSB_DEF_USB_ID_INTHE			(1U << 9)		/**<  */
#define FUSB_REG_OTG_USB_INTLE_OFFSET		0x0050U			/**<  */
#define FUSB_DEF_USB_VBUS_INTLE 		(1U << 8)		/**<  */
#define FUSB_DEF_USB_ID_INTLE			(1U << 9)		/**<  */
#define FUSB_REG_OTG_REFCLK_CTL_OFFSET	0x0100U			/**<  */
#define FUSB_REG_OTG_REF_SSP_EN			(1U << 16)		/**<  */
#define FUSB_REG_OTG_MULTIPLIER_OFFSET	0x0120U			/**<  */

/* xHCI */
#define FUSB_REG_XHCI_BASE_ADDR 		0x0000				/**<  */
#define FUSB_REG_XHCI_USBSTS_OFFSET		0x0024U				/**<  */
#define FUSB_DEF_USBSTS_HCH			(1U << 0)				/**<  */
#define FUSB_REG_XHCI_PORTSC_20_OFFSET	0x0420U				/**<  */
#define FUSB_REG_XHCI_PORTSC_SS_OFFSET	0x0430U				/**<  */
#define FUSB_DEF_PORT_CCS			(1U << 0)				/**<  */
#define FUSB_DEF_PORT_PED			(1U << 1)				/**<  */
#define FUSB_DEF_PORT_PSI			(0x0FU << 10)			/**<  */
#define FUSB_DEF_PSI_FS				(1U << 10)				/**<  */
#define FUSB_DEF_PSI_LS				(2U << 10)				/**<  */
#define FUSB_DEF_PSI_HS				(3U << 10)				/**<  */
#define FUSB_DEF_PSI_SS				(4U << 10)				/**<  */
#define FUSB_DEF_PORT_POWER			(1U << 9)				/**<  */

/* Global */
#define FUSB_REG_GLOBAL_BASE_ADDR 		0xC100U				/**<  */
#define FUSB_REG_GLOBAL_GUSB2PHYCFG_OFFSET	0x0100U			/**<  */
#define FUSB_DEF_GUSB2PHYCFG_SUSPENDUSB20	(0x01U << 6)			/**<  */
#define FUSB_REG_GLOBAL_GUSB3PIPECTL_OFFSET	0x01C0U			/**<  */
#define FUSB_DEF_GUSB3PIPECTL			0x11080002U			/**<  */
#define FUSB_DEF_GUSB3PIPECTL_SUS_PHY		(0x01U << 17)			/**<  */

/* Gadget(Device) */
#define FUSB_REG_GADGET_BASE_ADDR 		0xC700U				/**<  */
#define FUSB_REG_GADGET_DCTL_OFFSET		0x0004U			/**<  */
#define FUSB_DEF_RUN_STOP			(0x01U << 31)		/**<  */

/* Additional */
#define FUSB_REG_ADDITIONAL_BASE_ADDR	0x20000U				/**<  */
#define FUSB_REG_ADDITIONAL_PCNTL1_OFFSET	0x0000U		/**<  */
#define FUSB_DEF_TXVREFTUNE0_400mV		(3U << 0)		/**<  */
#define FUSB_REG_ADDITIONAL_ADPADDR_OFFSET	0x11080U
#define FUSB_DEV_ADPADDR				0x00001026U
#define FUSB_REG_ADDITIONAL_ADPDATA_OFFSET	0x11084U
#define FUSB_DEV_ADPDATA				0x00000001U

/* CLKRST_3 */
#define FUSB_REG_IPRESET2_OFFSET		0x00C0U			/**<  */
#define FUSB_REG_IPRESET2_SET_OFFSET		0x00C4U			/**<  */
#define FUSB_REG_IPRESET2_CLR_OFFSET		0x00C8U			/**<  */
#define FUSB_DEF_PRST_USB30		(1U << 9)		/**<  */
#define FUSB_DEF_PRST_USB30_PHY	(1U << 10)		/**<  */
#define FUSB_DEF_RRST_USB			(FUSB_DEF_PRST_USB30 | FUSB_DEF_PRST_USB30_PHY) /**<  */
#define FUSB_REG_IPCLKEN1_OFFSET		0x0030U			/**<  */
#define FUSB_REG_IPCLKEN1_SET_OFFSET		0x0034U			/**<  */
#define FUSB_REG_IPCLKEN1_CLR_OFFSET		0x0038U			/**<  */
#define	FUSB_DEF_USB30DRD_ACLK			(1U << 14)		/**<  */

#endif /* _F_USB_REGISTER_H_ */

