/* 2015-08-31: File added by Sony Corporation */
/*
 *  Copyright 2013 Sony Corporation
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
#ifndef LINUX_PAGE_EVENT_H
#define LINUX_PAGE_EVENT_H

enum page_event {
	PAGE_EVENT_ALLOC,
	PAGE_EVENT_FREE,
};

#ifdef CONFIG_SNSC_PAGE_EVENT_TRACE

#define PAGE_EVENT_MAX_BACKTRACE				\
	CONFIG_SNSC_PAGE_EVENT_TRACE_MAX_BACKTRACE
#define PAGE_EVENT_SKIP_BACKTRACE				\
	CONFIG_SNSC_PAGE_EVENT_TRACE_SKIP_BACKTRACE
#define PAGE_EVENT_MAX_HISTROY					\
        CONFIG_SNSC_PAGE_EVENT_TRACE_MAX_HISTORY

struct page_event_record {
	unsigned long event;
	pid_t tgid;
	pid_t pid;
	unsigned long backtrace[PAGE_EVENT_MAX_BACKTRACE];
};

struct page_event_trace {
	unsigned int next;
	struct page_event_record record[PAGE_EVENT_MAX_HISTROY];
};

#endif /* CONFIG_SNSC_PAGE_EVENT_TRACE */
#endif /* LINUX_PAGE_EVENT_H */
